/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.mcf;

import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.zeith.hammerlib.core.adapter.recipe.RecipeBuilder;
import org.zeith.hammerlib.util.shaded.json.JSONObject;
import org.zeith.hammerlib.util.shaded.json.JSONTokener;

public class RecipeRegistrationContext {
    public static final Logger LOG = LogManager.getLogger(RecipeRegistrationContext.class);
    private final Path file;
    private boolean changed;
    private final Map<String, RecipesData> allRecipes = new HashMap<String, RecipesData>();
    protected final Runnable markChanged = this::markChanged;

    public RecipeRegistrationContext(Path file) {
        this.file = file;
    }

    private void markChanged() {
        this.changed = true;
    }

    protected RecipesData create(String key) {
        return new RecipesData(key, (Object2BooleanMap<String>)new Object2BooleanArrayMap(), new HashSet<String>(), this.markChanged);
    }

    public boolean enableRecipe(IRecipeType<?> type, ResourceLocation id) {
        String idKey = id.toString();
        ResourceLocation rt = Registry.field_218367_H.func_177774_c(type);
        String key = rt == null ? "<unknown>" : rt.toString();
        RecipesData unknown = this.allRecipes.get("<unknown>");
        RecipesData data = this.allRecipes.computeIfAbsent(key, this::create);
        if (unknown != null && unknown.active.containsKey((Object)idKey)) {
            data.active.put((Object)idKey, unknown.active.removeBoolean((Object)idKey));
        }
        return data.enableRecipe(idKey);
    }

    public <T extends RecipeBuilder<T>> Optional<T> register(IRecipeType<?> type, @NotNull T builder) {
        if (this.enableRecipe(type, builder.getIdentifier())) {
            builder.register();
            return Optional.of(builder);
        }
        return Optional.empty();
    }

    public static RecipeRegistrationContext load(String modid) {
        Path recipes = FMLPaths.CONFIGDIR.get().resolve("hammerlib").resolve("recipes").resolve("modded").resolve(modid + ".json");
        RecipeRegistrationContext ctx = new RecipeRegistrationContext(recipes);
        try {
            Files.createDirectories(recipes.getParent(), new FileAttribute[0]);
            if (Files.isRegularFile(recipes, new LinkOption[0])) {
                new JSONTokener(new String(Files.readAllBytes(recipes), StandardCharsets.UTF_8)).nextValueOBJ().ifPresent(obj -> {
                    int vers = obj.optInt("version");
                    if (vers == 0) {
                        JSONObject[] objs;
                        Object2BooleanArrayMap toResolve = new Object2BooleanArrayMap();
                        for (JSONObject $ : objs = new JSONObject[]{obj.getJSONObject("active"), obj.getJSONObject("unregistered")}) {
                            for (String key : $.keySet()) {
                                toResolve.put((Object)key, $.optBoolean(key, true));
                            }
                        }
                        ctx.allRecipes.computeIfAbsent("<unknown>", ctx::create).active.putAll((Map)toResolve);
                        ctx.markChanged();
                        LOG.info("Upgrade recipe registration context of {} to v2", (Object)recipes.getFileName());
                        return;
                    }
                    if (vers == 2) {
                        JSONObject[] objs;
                        for (JSONObject $ : objs = new JSONObject[]{obj.getJSONObject("active"), obj.getJSONObject("unregistered")}) {
                            for (String type : $.keySet()) {
                                RecipesData storage = ctx.allRecipes.computeIfAbsent(type, ctx::create);
                                JSONObject $$ = $.optJSONObject(type);
                                if ($$ == null) continue;
                                for (String key : $$.keySet()) {
                                    storage.active.put((Object)key, $$.optBoolean(key, true));
                                }
                            }
                        }
                    }
                });
            }
        }
        catch (IOException err) {
            err.printStackTrace();
        }
        return ctx;
    }

    public void save() {
        if (this.changed) {
            JSONObject activeGlob = new JSONObject();
            JSONObject disabledGlob = new JSONObject();
            Function<String, JSONObject> activeByType = type -> {
                if (activeGlob.has((String)type)) {
                    return activeGlob.getJSONObject((String)type);
                }
                return activeGlob.put((String)type, new JSONObject()).getJSONObject((String)type);
            };
            Function<String, JSONObject> disabledByType = type -> {
                if (disabledGlob.has((String)type)) {
                    return disabledGlob.getJSONObject((String)type);
                }
                return disabledGlob.put((String)type, new JSONObject()).getJSONObject((String)type);
            };
            for (Map.Entry<String, RecipesData> entry : this.allRecipes.entrySet()) {
                RecipesData e = entry.getValue();
                if (e.active.isEmpty()) continue;
                LazyOptional active = LazyOptional.of(() -> (JSONObject)activeByType.apply((String)entry.getKey()));
                LazyOptional disabled = LazyOptional.of(() -> (JSONObject)disabledByType.apply((String)entry.getKey()));
                for (Object2BooleanMap.Entry st : e.active.object2BooleanEntrySet()) {
                    (e.usedKeys.contains(st.getKey()) ? active : disabled).resolve().orElse(new JSONObject()).put((String)st.getKey(), st.getBooleanValue());
                }
            }
            try {
                Files.createDirectories(this.file.getParent(), new FileAttribute[0]);
                Files.write(this.file, new JSONObject().put("version", 2).put("active", activeGlob).put("unregistered", disabledGlob).toString(4).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected final class RecipesData {
        private final String type;
        private final Object2BooleanMap<String> active;
        private final Set<String> usedKeys;
        private final Runnable changed;

        protected RecipesData(String type, Object2BooleanMap<String> active, Set<String> usedKeys, Runnable changed) {
            this.type = type;
            this.active = active;
            this.usedKeys = usedKeys;
            this.changed = changed;
        }

        public boolean enableRecipe(String id) {
            this.usedKeys.add(id);
            if (!this.active.containsKey((Object)id)) {
                this.active.put((Object)id, true);
                this.changed.run();
            }
            return this.active.getBoolean((Object)id);
        }

        public String type() {
            return this.type;
        }

        public Object2BooleanMap<String> active() {
            return this.active;
        }

        public Set<String> usedKeys() {
            return this.usedKeys;
        }

        public Runnable changed() {
            return this.changed;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            RecipesData that = (RecipesData)obj;
            return Objects.equals(this.type, that.type) && Objects.equals(this.active, that.active) && Objects.equals(this.usedKeys, that.usedKeys) && Objects.equals(this.changed, that.changed);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.active, this.usedKeys, this.changed);
        }

        public String toString() {
            return "RecipesData[type=" + this.type + ", active=" + this.active + ", usedKeys=" + this.usedKeys + ", changed=" + this.changed + ']';
        }
    }
}

