/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.item;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import dev.latvian.kubejs.KubeJSRegistries;
import dev.latvian.kubejs.item.ItemFoodEatenEventJS;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.architectury.hooks.FoodPropertiesHooks;
import net.minecraft.item.Food;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;

public class FoodBuilder {
    private int hunger;
    private float saturation;
    private boolean meat;
    private boolean alwaysEdible;
    private boolean fastToEat;
    private final List<org.apache.commons.lang3.tuple.Pair<Supplier<EffectInstance>, Float>> effects = Lists.newArrayList();
    public Consumer<ItemFoodEatenEventJS> eaten;

    public FoodBuilder() {
    }

    public FoodBuilder(Food properties) {
        this.hunger = properties.func_221466_a();
        this.saturation = properties.func_221469_b();
        this.meat = properties.func_221467_c();
        this.alwaysEdible = properties.func_221468_d();
        this.fastToEat = properties.func_221465_e();
        properties.func_221464_f().forEach(pair -> this.effects.add((org.apache.commons.lang3.tuple.Pair<Supplier<EffectInstance>, Float>)org.apache.commons.lang3.tuple.Pair.of(() -> ((Pair)pair).getFirst(), (Object)((Float)pair.getSecond()))));
    }

    public FoodBuilder hunger(int h) {
        this.hunger = h;
        return this;
    }

    public FoodBuilder saturation(float s) {
        this.saturation = s;
        return this;
    }

    public FoodBuilder meat(boolean flag) {
        this.meat = flag;
        return this;
    }

    public FoodBuilder meat() {
        return this.meat(true);
    }

    public FoodBuilder alwaysEdible(boolean flag) {
        this.alwaysEdible = flag;
        return this;
    }

    public FoodBuilder alwaysEdible() {
        return this.alwaysEdible(true);
    }

    public FoodBuilder fastToEat(boolean flag) {
        this.fastToEat = flag;
        return this;
    }

    public FoodBuilder fastToEat() {
        return this.fastToEat(true);
    }

    public FoodBuilder effect(ResourceLocation mobEffectId, int duration, int amplifier, float probability) {
        this.effects.add((org.apache.commons.lang3.tuple.Pair<Supplier<EffectInstance>, Float>)org.apache.commons.lang3.tuple.Pair.of((Object)new EffectSupplier(mobEffectId, duration, amplifier), (Object)Float.valueOf(probability)));
        return this;
    }

    public FoodBuilder removeEffect(Effect mobEffect) {
        if (mobEffect == null) {
            return this;
        }
        this.effects.removeIf(pair -> {
            EffectInstance effectInstance = (EffectInstance)((Supplier)pair.getKey()).get();
            return effectInstance.func_76453_d().equals(mobEffect.func_76393_a());
        });
        return this;
    }

    public FoodBuilder eaten(Consumer<ItemFoodEatenEventJS> e) {
        this.eaten = e;
        return this;
    }

    public Food build() {
        Food.Builder b = new Food.Builder();
        b.func_221456_a(this.hunger);
        b.func_221454_a(this.saturation);
        if (this.meat) {
            b.func_221451_a();
        }
        if (this.alwaysEdible) {
            b.func_221455_b();
        }
        if (this.fastToEat) {
            b.func_221457_c();
        }
        for (org.apache.commons.lang3.tuple.Pair<Supplier<EffectInstance>, Float> effect : this.effects) {
            FoodPropertiesHooks.effect((Food.Builder)b, (Supplier)((Supplier)effect.getLeft()), (float)((Float)effect.getRight()).floatValue());
        }
        return b.func_221453_d();
    }

    private static class EffectSupplier
    implements Supplier<EffectInstance> {
        private final ResourceLocation id;
        private final int duration;
        private final int amplifier;
        private Effect cachedEffect;

        public EffectSupplier(ResourceLocation id, int duration, int amplifier) {
            this.id = id;
            this.duration = duration;
            this.amplifier = amplifier;
        }

        @Override
        public EffectInstance get() {
            if (this.cachedEffect == null) {
                this.cachedEffect = (Effect)KubeJSRegistries.mobEffects().get(this.id);
                if (this.cachedEffect == null) {
                    Set effectIds = KubeJSRegistries.mobEffects().entrySet().stream().map(entry -> ((RegistryKey)entry.getKey()).func_240901_a_()).collect(Collectors.toSet());
                    throw new RuntimeException(String.format("Missing effect '%s'. Check spelling or maybe potion id was used instead of effect id. Possible ids: %s", this.id, effectIds));
                }
            }
            return new EffectInstance(this.cachedEffect, this.duration, this.amplifier);
        }
    }
}

