/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.item.ingredient;

import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class FilteredIngredientJS
implements IngredientJS {
    private final IngredientJS ingredient;
    private final IngredientJS filter;

    public FilteredIngredientJS(IngredientJS i, IngredientJS f) {
        this.ingredient = i;
        this.filter = f;
    }

    @Override
    public boolean test(ItemStackJS stack) {
        return this.ingredient.test(stack) && this.filter.test(stack);
    }

    @Override
    public boolean testVanilla(ItemStack stack) {
        return this.ingredient.testVanilla(stack) && this.filter.testVanilla(stack);
    }

    @Override
    public boolean testVanillaItem(Item item) {
        return this.ingredient.testVanillaItem(item) && this.filter.testVanillaItem(item);
    }

    @Override
    public Set<ItemStackJS> getStacks() {
        LinkedHashSet<ItemStackJS> set = new LinkedHashSet<ItemStackJS>();
        for (ItemStackJS stack : this.ingredient.getStacks()) {
            if (!this.filter.test(stack)) continue;
            set.add(stack);
        }
        return set;
    }

    @Override
    public Set<Item> getVanillaItems() {
        LinkedHashSet<Item> set = new LinkedHashSet<Item>();
        for (Item item : this.ingredient.getVanillaItems()) {
            if (!this.filter.testVanillaItem(item)) continue;
            set.add(item);
        }
        return set;
    }

    @Override
    public IngredientJS copy() {
        return new FilteredIngredientJS(this.ingredient.copy(), this.filter.copy());
    }

    public String toString() {
        return "Ingredient.of(" + this.ingredient + ").filter(" + this.filter + ")";
    }
}

