/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.item.ingredient;

import dev.latvian.kubejs.KubeJSRegistries;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.kubejs.recipe.RecipeJS;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;

public class ModIngredientJS
implements IngredientJS {
    private final String mod;

    public ModIngredientJS(String m) {
        this.mod = m;
        if (RecipeJS.itemErrors && this.getFirst().isEmpty()) {
            throw new RecipeExceptionJS("Mod '" + this.mod + "' doesn't have any items!").error();
        }
    }

    public String getMod() {
        return this.mod;
    }

    @Override
    public boolean test(ItemStackJS stack) {
        return !stack.isEmpty() && this.mod.equals(stack.getMod());
    }

    @Override
    public boolean testVanilla(ItemStack stack) {
        return !stack.func_190926_b() && this.mod.equals(KubeJSRegistries.items().getId((Object)stack.func_77973_b()).func_110624_b());
    }

    @Override
    public boolean testVanillaItem(Item item) {
        return item != Items.field_190931_a && this.mod.equals(KubeJSRegistries.items().getId((Object)item).func_110624_b());
    }

    @Override
    public Set<ItemStackJS> getStacks() {
        LinkedHashSet<ItemStackJS> set = new LinkedHashSet<ItemStackJS>();
        for (ItemStackJS stack : ItemStackJS.getList()) {
            if (!this.mod.equals(stack.getMod())) continue;
            set.add(stack);
        }
        return set;
    }

    @Override
    public ItemStackJS getFirst() {
        for (ItemStackJS stack : ItemStackJS.getList()) {
            if (!this.mod.equals(stack.getMod())) continue;
            return stack.copy();
        }
        return ItemStackJS.EMPTY;
    }

    public String toString() {
        return "'@" + this.mod + "'";
    }
}

