/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.recipe;

import dev.latvian.kubejs.KubeJS;
import dev.latvian.kubejs.KubeJSRegistries;
import dev.latvian.kubejs.event.EventJS;
import dev.latvian.kubejs.recipe.IgnoredRecipeTypeJS;
import dev.latvian.kubejs.recipe.RecipeJS;
import dev.latvian.kubejs.recipe.RecipeTypeJS;
import dev.latvian.kubejs.recipe.minecraft.ShapedRecipeJS;
import dev.latvian.kubejs.recipe.minecraft.ShapelessRecipeJS;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import me.shedaniel.architectury.registry.Registries;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class RecipeTypeRegistryEventJS
extends EventJS {
    private final Map<ResourceLocation, RecipeTypeJS> map;

    public RecipeTypeRegistryEventJS(Map<ResourceLocation, RecipeTypeJS> m) {
        this.map = m;
    }

    public void register(RecipeTypeJS type) {
        this.map.put(Registries.getId(type.serializer, (RegistryKey)Registry.field_239679_Q_), type);
        KubeJS.LOGGER.info("Registered custom recipe handler for type " + type);
    }

    public void register(ResourceLocation id, Supplier<RecipeJS> f) {
        this.register(new RecipeTypeJS(Objects.requireNonNull((IRecipeSerializer)KubeJSRegistries.recipeSerializers().get(id), "Cannot find recipe serializer: " + id), f));
    }

    public void ignore(ResourceLocation id) {
        this.register(new IgnoredRecipeTypeJS(Objects.requireNonNull((IRecipeSerializer)KubeJSRegistries.recipeSerializers().get(id), "Cannot find recipe serializer: " + id)));
    }

    public void registerShaped(ResourceLocation id) {
        this.register(id, ShapedRecipeJS::new);
    }

    public void registerShapeless(ResourceLocation id) {
        this.register(id, ShapelessRecipeJS::new);
    }
}

