/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.common.algoritms;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import org.anti_ad.mc.common.algoritms.WeightedNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003:\u0001\"B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J!\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00162\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\bH\u0002J\u0017\u0010\u001d\u001a\u0004\u0018\u00018\u00002\b\b\u0002\u0010\u001e\u001a\u00020\b\u00a2\u0006\u0002\u0010\u001fJ\u0013\u0010 \u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00028\u0000\u00a2\u0006\u0002\u0010!R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR$\u0010\r\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00028\u00000\u000fR\b\u0012\u0004\u0012\u00028\u00000\u00000\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\fR$\u0010\u0012\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00028\u00000\u000fR\b\u0012\u0004\u0012\u00028\u00000\u00000\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/anti_ad/mc/common/algoritms/WeightedRandomizingList;", "D", "", "", "noiseSource", "Lkotlin/random/Random;", "(Lkotlin/random/Random;)V", "iSize", "", "iWeight", "length", "getLength", "()I", "nodeList", "", "Lorg/anti_ad/mc/common/algoritms/WeightedRandomizingList$Node;", "size", "getSize", "sortedByValue", "sortedIsDirty", "", "add", "Lorg/anti_ad/mc/common/algoritms/WeightedNode;", "data", "weight", "(Ljava/lang/Comparable;I)Lorg/anti_ad/mc/common/algoritms/WeightedNode;", "adjust", "", "from", "getWeightedRandomElement", "pos", "(I)Ljava/lang/Comparable;", "remove", "(Ljava/lang/Comparable;)V", "Node", "libIPN"})
@SourceDebugExtension(value={"SMAP\nWeightedRandomizingList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WeightedRandomizingList.kt\norg/anti_ad/mc/common/algoritms/WeightedRandomizingList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,190:1\n1002#2,2:191\n*S KotlinDebug\n*F\n+ 1 WeightedRandomizingList.kt\norg/anti_ad/mc/common/algoritms/WeightedRandomizingList\n*L\n96#1:191,2\n*E\n"})
public final class WeightedRandomizingList<D extends Comparable<? super D>> {
    @NotNull
    private final Random noiseSource;
    @NotNull
    private final List<Node<D>> nodeList;
    private boolean sortedIsDirty;
    @NotNull
    private final List<Node<D>> sortedByValue;
    private int iSize;
    private int iWeight;

    public WeightedRandomizingList(@NotNull Random noiseSource) {
        Intrinsics.checkNotNullParameter((Object)noiseSource, (String)"noiseSource");
        this.noiseSource = noiseSource;
        this.nodeList = new ArrayList();
        this.sortedIsDirty = true;
        this.sortedByValue = new ArrayList();
    }

    public final int getSize() {
        return this.iSize;
    }

    public final int getLength() {
        Node node = (Node)CollectionsKt.lastOrNull(this.nodeList);
        return node != null ? node.getEnd() : 0;
    }

    @NotNull
    public final WeightedNode<D> add(@NotNull D data, int weight) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        int pos = this.nodeList.size() == 0 ? 0 : ((Node)CollectionsKt.last(this.nodeList)).getEnd();
        Node<D> newNode = new Node<D>(data, weight, pos);
        this.nodeList.add(newNode);
        newNode.setIndex(this.nodeList.size() - 1);
        this.iWeight = newNode.getEnd();
        this.sortedByValue.add(newNode);
        this.sortedIsDirty = true;
        return newNode;
    }

    private final void adjust(int from) {
        int prev = 0;
        prev = this.nodeList.get(from).getEnd();
        int n = this.nodeList.size();
        for (int i = from + 1; i < n; ++i) {
            Node<D> moving = this.nodeList.get(i);
            boolean bl = false;
            moving.setPos(prev);
            prev = moving.getEnd();
        }
    }

    public final void remove(@NotNull D data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        if (this.sortedIsDirty) {
            List<Node<D>> $this$sortBy$iv = this.sortedByValue;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Node it = (Node)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)it.getData();
                        it = (Node)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getData()));
                    }
                });
            }
            this.sortedIsDirty = false;
        }
        int it = CollectionsKt.binarySearch$default(this.sortedByValue, (int)0, (int)0, (Function1)new Function1<Node<D>, Integer>(data){
            final /* synthetic */ D $data;
            {
                this.$data = $data;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull Node<D> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return ((Comparable)it.getData()).compareTo(this.$data);
            }
        }, (int)3, null);
        boolean bl = false;
        if (it >= 0) {
            Node<D> node = this.sortedByValue.remove(it);
            int prev = 0;
            prev = node.getPos();
            int n = this.nodeList.size();
            for (int i = node.getIndex() + 1; i < n; ++i) {
                Node<D> moving = this.nodeList.get(i);
                boolean bl2 = false;
                moving.setPos(prev);
                prev = moving.getEnd();
            }
            this.nodeList.remove(node.getIndex());
        }
    }

    @Nullable
    public final D getWeightedRandomElement(int pos) {
        Comparable comparable;
        if (pos >= 0 && pos < ((Node)CollectionsKt.last(this.nodeList)).getEnd()) {
            int index2 = CollectionsKt.binarySearch$default(this.nodeList, (int)0, (int)0, (Function1)new Function1<Node<D>, Integer>(pos){
                final /* synthetic */ int $pos;
                {
                    this.$pos = $pos;
                    super(1);
                }

                @NotNull
                public final Integer invoke(@NotNull Node<D> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    return this.$pos >= it.getPos() && this.$pos < it.getEnd() ? 0 : (it.getEnd() > this.$pos ? 1 : -1);
                }
            }, (int)3, null);
            comparable = (Comparable)this.nodeList.get(index2).getData();
        } else {
            comparable = null;
        }
        return (D)comparable;
    }

    public static /* synthetic */ Comparable getWeightedRandomElement$default(WeightedRandomizingList weightedRandomizingList, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = weightedRandomizingList.noiseSource.nextInt(weightedRandomizingList.getLength());
        }
        return weightedRandomizingList.getWeightedRandomElement(n);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0013\b\u0086\u0004\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007R\u0016\u0010\u0003\u001a\u00028\u0001X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0011\u0010\u000b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\r\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\r\"\u0004\b\u0013\u0010\u0011R$\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\r\"\u0004\b\u0017\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lorg/anti_ad/mc/common/algoritms/WeightedRandomizingList$Node;", "D", "Lorg/anti_ad/mc/common/algoritms/WeightedNode;", "data", "aWeight", "", "pos", "(Lorg/anti_ad/mc/common/algoritms/WeightedRandomizingList;Ljava/lang/Object;II)V", "getData", "()Ljava/lang/Object;", "Ljava/lang/Object;", "end", "getEnd", "()I", "index", "getIndex", "setIndex", "(I)V", "getPos", "setPos", "value", "weight", "getWeight", "setWeight", "libIPN"})
    public final class Node<D>
    implements WeightedNode<D> {
        private final D data;
        private int pos;
        private int weight;
        private int index;

        public Node(D data, int aWeight, int pos) {
            this.data = data;
            this.pos = pos;
            this.weight = aWeight;
            this.index = -1;
            this.setWeight(aWeight);
        }

        @Override
        public D getData() {
            return this.data;
        }

        public final int getPos() {
            return this.pos;
        }

        public final void setPos(int n) {
            this.pos = n;
        }

        @Override
        public int getWeight() {
            return this.weight;
        }

        @Override
        public void setWeight(int value) {
            this.weight = value;
            if (this.index > -1) {
                ((WeightedRandomizingList)WeightedRandomizingList.this).adjust(this.index);
            }
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }

        public final int getEnd() {
            return this.pos + this.getWeight();
        }
    }
}

