/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.common.math2d;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.anti_ad.mc.common.math2d.Point;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B%\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\t\u0010!\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0007H\u00c6\u0003J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003J\t\u0010$\u001a\u00020\u0007H\u00c6\u0003J1\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010&\u001a\u00020\u00122\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020\u0007H\u00d6\u0001J\t\u0010)\u001a\u00020*H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0015\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000fR\u0011\u0010\u0018\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000fR\u0011\u0010\u001a\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000fR\u0011\u0010\u001c\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u000f\u00a8\u0006+"}, d2={"Lorg/anti_ad/mc/common/math2d/Line;", "", "start", "Lorg/anti_ad/mc/common/math2d/Point;", "end", "(Lorg/anti_ad/mc/common/math2d/Point;Lorg/anti_ad/mc/common/math2d/Point;)V", "startX", "", "startY", "endX", "endY", "(IIII)V", "getEnd", "()Lorg/anti_ad/mc/common/math2d/Point;", "getEndX", "()I", "getEndY", "isHorizontal", "", "()Z", "isPoint", "isVertical", "maxX", "getMaxX", "maxY", "getMaxY", "minX", "getMinX", "minY", "getMinY", "getStart", "getStartX", "getStartY", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toString", "", "libIPN"})
public final class Line {
    private final int startX;
    private final int startY;
    private final int endX;
    private final int endY;

    public Line(int startX, int startY, int endX, int endY) {
        this.startX = startX;
        this.startY = startY;
        this.endX = endX;
        this.endY = endY;
    }

    public final int getStartX() {
        return this.startX;
    }

    public final int getStartY() {
        return this.startY;
    }

    public final int getEndX() {
        return this.endX;
    }

    public final int getEndY() {
        return this.endY;
    }

    public Line(@NotNull Point start, @NotNull Point end) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        this(start.getX(), start.getY(), end.getX(), end.getY());
    }

    @NotNull
    public final Point getStart() {
        return new Point(this.startX, this.startY);
    }

    @NotNull
    public final Point getEnd() {
        return new Point(this.endX, this.endY);
    }

    public final boolean isPoint() {
        return Intrinsics.areEqual((Object)this.getStart(), (Object)this.getEnd());
    }

    public final boolean isHorizontal() {
        return this.startY == this.endY;
    }

    public final boolean isVertical() {
        return this.startX == this.endX;
    }

    public final int getMinX() {
        return Math.min(this.startX, this.endX);
    }

    public final int getMaxX() {
        return Math.max(this.startX, this.endX);
    }

    public final int getMinY() {
        return Math.min(this.startY, this.endY);
    }

    public final int getMaxY() {
        return Math.max(this.startY, this.endY);
    }

    public final int component1() {
        return this.startX;
    }

    public final int component2() {
        return this.startY;
    }

    public final int component3() {
        return this.endX;
    }

    public final int component4() {
        return this.endY;
    }

    @NotNull
    public final Line copy(int startX, int startY, int endX, int endY) {
        return new Line(startX, startY, endX, endY);
    }

    public static /* synthetic */ Line copy$default(Line line, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n = line.startX;
        }
        if ((n5 & 2) != 0) {
            n2 = line.startY;
        }
        if ((n5 & 4) != 0) {
            n3 = line.endX;
        }
        if ((n5 & 8) != 0) {
            n4 = line.endY;
        }
        return line.copy(n, n2, n3, n4);
    }

    @NotNull
    public String toString() {
        return "Line(startX=" + this.startX + ", startY=" + this.startY + ", endX=" + this.endX + ", endY=" + this.endY + ')';
    }

    public int hashCode() {
        int result = Integer.hashCode(this.startX);
        result = result * 31 + Integer.hashCode(this.startY);
        result = result * 31 + Integer.hashCode(this.endX);
        result = result * 31 + Integer.hashCode(this.endY);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Line)) {
            return false;
        }
        Line line = (Line)other;
        if (this.startX != line.startX) {
            return false;
        }
        if (this.startY != line.startY) {
            return false;
        }
        if (this.endX != line.endX) {
            return false;
        }
        return this.endY == line.endY;
    }
}

