/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.common.vanilla;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.anti_ad.mc.common.extensions.Java_ioKt;
import org.anti_ad.mc.common.input.KeybindSettings;
import org.anti_ad.mc.common.vanilla.Vanilla;
import org.anti_ad.mc.common.vanilla.VanillaUtilKt;
import org.anti_ad.mc.common.vanilla.render.ScreenKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u0004J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0006\u0010\u000f\u001a\u00020\u0004J\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u000bJ\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\tJ\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aJ\u000e\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u001aJ\u0006\u0010 \u001a\u00020\u001aJ\u0006\u0010!\u001a\u00020\u001eJ\u0006\u0010\"\u001a\u00020\u001aJ\u0006\u0010#\u001a\u00020\u001aJ\u000e\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020&J\u000e\u0010$\u001a\u00020\u00062\u0006\u0010'\u001a\u00020(J\b\u0010)\u001a\u00020\tH\u0002J\u0006\u0010*\u001a\u00020\u0004\u00a8\u0006+"}, d2={"Lorg/anti_ad/mc/common/vanilla/VanillaUtil;", "", "()V", "altDown", "", "chat", "", "message", "configDirectory", "Ljava/nio/file/Path;", "modName", "", "ctrlDown", "getResourceAsString", "identifier", "inGame", "isOnClientThread", "isValidScreen", "ctx", "Lorg/anti_ad/mc/common/input/KeybindSettings$Context;", "languageCode", "lastFrameDuration", "", "loggingString", "path", "mouseScaleX", "", "amount", "mouseScaleY", "mouseX", "", "mouseXDouble", "mouseXRaw", "mouseY", "mouseYDouble", "mouseYRaw", "open", "file", "Ljava/io/File;", "url", "Ljava/net/URL;", "runDirectory", "shiftDown", "libIPN"})
@SourceDebugExtension(value={"SMAP\nVanillaUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VanillaUtil.kt\norg/anti_ad/mc/common/vanilla/VanillaUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 common.kt\norg/anti_ad/mc/common/extensions/CommonKt\n*L\n1#1,140:1\n1#2:141\n70#3,14:142\n*S KotlinDebug\n*F\n+ 1 VanillaUtil.kt\norg/anti_ad/mc/common/vanilla/VanillaUtil\n*L\n96#1:142,14\n*E\n"})
public final class VanillaUtil {
    @NotNull
    public static final VanillaUtil INSTANCE = new VanillaUtil();

    private VanillaUtil() {
    }

    public final boolean isOnClientThread() {
        return Vanilla.INSTANCE.mc().func_213162_bc();
    }

    public final boolean inGame() {
        return Vanilla.INSTANCE.worldNullable() != null && Vanilla.INSTANCE.playerNullable() != null;
    }

    @NotNull
    public final String languageCode() {
        String string = Vanilla.INSTANCE.languageManager().func_135041_c().getCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Vanilla.languageManager().currentLanguage.code");
        return string;
    }

    public final boolean shiftDown() {
        return Screen.func_231173_s_();
    }

    public final boolean ctrlDown() {
        return Screen.func_231172_r_();
    }

    public final boolean altDown() {
        return Screen.func_231174_t_();
    }

    public final int mouseX() {
        return (int)this.mouseXDouble();
    }

    public final int mouseY() {
        return (int)this.mouseYDouble();
    }

    public final double mouseXRaw() {
        return Vanilla.INSTANCE.mouse().func_198024_e();
    }

    public final double mouseYRaw() {
        return Vanilla.INSTANCE.mouse().func_198026_f();
    }

    public final double mouseXDouble() {
        return this.mouseScaleX(this.mouseXRaw());
    }

    public final double mouseYDouble() {
        return this.mouseScaleY(this.mouseYRaw());
    }

    public final double mouseScaleX(double amount) {
        return amount * (double)ScreenKt.getRScreenWidth() / (double)Vanilla.INSTANCE.window().func_198105_m();
    }

    public final double mouseScaleY(double amount) {
        return amount * (double)ScreenKt.getRScreenHeight() / (double)Vanilla.INSTANCE.window().func_198083_n();
    }

    public final float lastFrameDuration() {
        return Vanilla.INSTANCE.mc().func_193989_ak();
    }

    private final Path runDirectory() {
        Path path = Vanilla.INSTANCE.runDirectoryFile().toPath().normalize();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Vanilla.runDirectoryFile().toPath().normalize()");
        return path;
    }

    @NotNull
    public final Path configDirectory() {
        return Java_ioKt.div(this.runDirectory(), "config");
    }

    @NotNull
    public final Path configDirectory(@NotNull String modName) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)modName, (String)"modName");
        Path $this$configDirectory_u24lambda_u240 = path = Java_ioKt.div(this.configDirectory(), modName);
        boolean bl = false;
        Java_ioKt.createDirectories($this$configDirectory_u24lambda_u240);
        return path;
    }

    @Nullable
    public final String getResourceAsString(@NotNull String identifier) {
        String string;
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        boolean $i$f$tryCatch = false;
        boolean $i$f$tryCatch2 = false;
        try {
            boolean bl = false;
            InputStream inputStream = Vanilla.INSTANCE.resourceManager().func_199002_a(new ResourceLocation(identifier)).func_199027_b();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"Vanilla.resourceManager(\u2026(identifier)).inputStream");
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            string = TextStreamsKt.readText((Reader)new InputStreamReader(inputStream2, charset));
        }
        catch (Throwable e$iv$iv) {
            e$iv$iv.printStackTrace();
            Throwable it$iv = e$iv$iv;
            boolean bl = false;
            string = null;
        }
        return string;
    }

    @NotNull
    public final String loggingString(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return ((Object)(path.isAbsolute() ? Java_ioKt.pathFrom(path, Java_ioKt.div(this.runDirectory(), "..")) : path)).toString();
    }

    public final void open(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(file2){
            final /* synthetic */ File $file;
            {
                this.$file = $file;
                super(0);
            }

            public final void invoke() {
                Util.func_110647_a().func_195641_a(this.$file);
            }
        }), (int)31, null);
    }

    public final void open(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(url){
            final /* synthetic */ URL $url;
            {
                this.$url = $url;
                super(0);
            }

            public final void invoke() {
                Util.func_110647_a().func_195639_a(this.$url);
            }
        }), (int)31, null);
    }

    public final boolean isValidScreen(@NotNull KeybindSettings.Context ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        return VanillaUtilKt.access$isValid(ctx, Vanilla.INSTANCE.screen());
    }

    public final void chat(@NotNull Object message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Vanilla.INSTANCE.chatHud().func_146227_a(message2 instanceof ITextComponent ? (ITextComponent)message2 : (ITextComponent)new StringTextComponent(message2.toString()));
    }
}

