/*
 * Decompiled with CFR 0.152.
 */
package com.ccr4ft3r.lightspeed.events;

import com.ccr4ft3r.lightspeed.cache.GlobalCache;
import com.ccr4ft3r.lightspeed.util.LogUtils;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.BrandingControl;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="lightspeed", value={Dist.CLIENT})
public class TitleScreenInjector {
    private static boolean launchComplete = false;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onScreenInit(GuiScreenEvent.InitGuiEvent.Post event) {
        if (!(event.getGui() instanceof MainMenuScreen) || launchComplete) {
            return;
        }
        launchComplete = true;
        try {
            long secondsToStart = ManagementFactory.getRuntimeMXBean().getUptime() / 1000L;
            LogUtils.getLogger().info("Lightspeed: Launch took {}s", (Object)secondsToStart);
            BrandingControl brandingControl = new BrandingControl();
            Field f = BrandingControl.class.getDeclaredField("brandings");
            f.setAccessible(true);
            Method computeBranding = BrandingControl.class.getDeclaredMethod("computeBranding", new Class[0]);
            computeBranding.setAccessible(true);
            computeBranding.invoke(null, new Object[0]);
            ArrayList brandings = new ArrayList((List)f.get(brandingControl));
            if (brandings.size() > 1) {
                ArrayList<String> newBrandings = new ArrayList<String>(brandings);
                f.set(brandingControl, newBrandings);
                newBrandings.add("Lightspeed: Launch took " + secondsToStart + "s");
            }
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            LogUtils.getLogger().error("Cannot add launch time to title screen", (Throwable)e);
        }
        GlobalCache.EXECUTOR.execute(GlobalCache::disablePersistAndClear);
        GlobalCache.EXECUTOR.shutdown();
    }
}

