/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.entity;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.item.minecart.ContainerMinecartEntity;
import net.minecraft.entity.monster.piglin.PiglinTasks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.network.NetworkHooks;
import noobanidus.mods.lootr.Lootr;
import noobanidus.mods.lootr.api.entity.ILootCart;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.init.ModBlocks;
import noobanidus.mods.lootr.init.ModEntities;
import noobanidus.mods.lootr.networking.OpenCart;
import noobanidus.mods.lootr.networking.PacketHandler;
import noobanidus.mods.lootr.util.ChestUtil;

public class LootrChestMinecartEntity
extends ContainerMinecartEntity
implements ILootCart {
    private final Set<UUID> openers = new HashSet<UUID>();
    private boolean opened = false;
    private static final BlockState cartNormal = (BlockState)ModBlocks.CHEST.func_176223_P().func_206870_a((Property)ChestBlock.field_176459_a, (Comparable)Direction.NORTH);

    public LootrChestMinecartEntity(EntityType<LootrChestMinecartEntity> type, World world) {
        super(type, world);
    }

    public LootrChestMinecartEntity(World worldIn, double x, double y, double z) {
        super(ModEntities.LOOTR_MINECART_ENTITY, x, y, z, worldIn);
    }

    @Override
    public Set<UUID> getOpeners() {
        return this.openers;
    }

    public void addOpener(PlayerEntity player) {
        this.openers.add(player.func_110124_au());
    }

    public boolean isOpened() {
        return this.opened;
    }

    public void setOpened() {
        this.opened = true;
    }

    public void setClosed() {
        this.opened = false;
    }

    public boolean func_180431_b(DamageSource source) {
        if (this.func_190530_aW() && source != DamageSource.field_76380_i) {
            return true;
        }
        if (source.func_76346_g() instanceof FakePlayer) {
            return false;
        }
        if (source.func_76346_g() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)source.func_76346_g();
            if ((((Boolean)ConfigManager.DISABLE_BREAK.get()).booleanValue() && player.func_184812_l_() || !((Boolean)ConfigManager.DISABLE_BREAK.get()).booleanValue()) && source.func_76346_g().func_225608_bj_()) {
                return false;
            }
        } else {
            return true;
        }
        source.func_76346_g().func_145747_a((ITextComponent)new TranslationTextComponent("lootr.message.cart_should_sneak").func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.AQUA))), Util.field_240973_b_);
        source.func_76346_g().func_145747_a((ITextComponent)new TranslationTextComponent("lootr.message.should_sneak2", new Object[]{new TranslationTextComponent("lootr.message.cart_should_sneak3").func_230530_a_(Style.field_240709_b_.func_240713_a_(Boolean.valueOf(true)))}).func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.AQUA))), Util.field_240973_b_);
        return true;
    }

    public void func_94095_a(DamageSource source) {
        this.func_70106_y();
        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            ItemStack itemstack = new ItemStack((IItemProvider)Items.field_151143_au);
            ItemStack itemstack2 = new ItemStack((IItemProvider)Items.field_221675_bZ);
            if (this.func_145818_k_()) {
                itemstack.func_200302_a(this.func_200201_e());
                itemstack2.func_200302_a(this.func_200201_e());
            }
            this.func_199701_a_(itemstack);
            this.func_199701_a_(itemstack2);
        }
    }

    public int func_70302_i_() {
        return 27;
    }

    public AbstractMinecartEntity.Type func_184264_v() {
        return AbstractMinecartEntity.Type.CHEST;
    }

    public BlockState func_180457_u() {
        return cartNormal;
    }

    public int func_94085_r() {
        return 8;
    }

    public Container func_213968_a(int id, PlayerInventory playerInventoryIn) {
        return ChestContainer.func_216992_a((int)id, (PlayerInventory)playerInventoryIn, (IInventory)this);
    }

    public void remove(boolean keepData) {
        this.field_70128_L = true;
        if (!keepData) {
            this.invalidateCaps();
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        if (this.field_184290_c != null) {
            compound.func_74778_a("LootTable", this.field_184290_c.toString());
        }
        compound.func_74772_a("LootTableSeed", this.field_184291_d);
        ListNBT list = new ListNBT();
        for (UUID opener : this.openers) {
            list.add((Object)NBTUtil.func_240626_a_((UUID)opener));
        }
        compound.func_218657_a("LootrOpeners", (INBT)list);
        super.func_213281_b(compound);
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.field_184290_c = new ResourceLocation(compound.func_74779_i("LootTable"));
        this.field_184291_d = compound.func_74763_f("LootTableSeed");
        if (compound.func_150297_b("LootrOpeners", 9)) {
            ListNBT openers = compound.func_150295_c("LootrOpeners", 11);
            this.openers.clear();
            for (INBT item : openers) {
                this.openers.add(NBTUtil.func_186860_b((INBT)item));
            }
        }
        super.func_70037_a(compound);
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        ActionResultType ret = ActionResultType.PASS;
        if (ret.func_226246_a_()) {
            return ret;
        }
        if (player.func_225608_bj_()) {
            ChestUtil.handleLootCartSneak(player.field_70170_p, this, player);
            if (!player.field_70170_p.field_72995_K) {
                return ActionResultType.CONSUME;
            }
            return ActionResultType.SUCCESS;
        }
        ChestUtil.handleLootCart(player.field_70170_p, this, player);
        if (!player.field_70170_p.field_72995_K) {
            PiglinTasks.func_234478_a_((PlayerEntity)player, (boolean)true);
            return ActionResultType.CONSUME;
        }
        return ActionResultType.SUCCESS;
    }

    public void addLoot(@Nullable PlayerEntity player, IInventory inventory, @Nullable ResourceLocation overrideTable, long seed) {
        if (this.field_184290_c != null && this.field_70170_p.func_73046_m() != null) {
            LootTable loottable = this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(overrideTable != null ? overrideTable : this.field_184290_c);
            if (loottable == LootTable.field_186464_a) {
                Lootr.LOG.error("Unable to fill loot cart in " + this.field_70170_p.func_234923_W_() + " at " + this.func_213303_ch() + " as the loot table '" + (overrideTable != null ? overrideTable : this.field_184290_c) + "' couldn't be resolved! Please search the loot table in `latest.log` to see if there are errors in loading.");
                if (((Boolean)ConfigManager.REPORT_UNRESOLVED_TABLES.get()).booleanValue() && player != null) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("lootr.message.invalid_table", new Object[]{(overrideTable != null ? overrideTable : this.field_184290_c).toString()}).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.DARK_RED).func_240713_a_(Boolean.valueOf(true))), Util.field_240973_b_);
                }
            }
            if (player instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_232608_N_.func_235478_a_((ServerPlayerEntity)player, overrideTable != null ? overrideTable : this.field_184290_c);
            }
            LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.field_70170_p).func_216015_a(LootParameters.field_237457_g_, (Object)this.func_213303_ch()).func_216016_a((Boolean)ConfigManager.RANDOMISE_SEED.get() != false ? ThreadLocalRandom.current().nextLong() : (seed == Long.MIN_VALUE ? this.field_184291_d : seed));
            lootcontext$builder.func_216015_a(LootParameters.field_216284_d, (Object)this);
            if (player != null) {
                lootcontext$builder.func_186469_a(player.func_184817_da()).func_216015_a(LootParameters.field_216281_a, (Object)player);
            }
            loottable.func_216118_a(inventory, lootcontext$builder.func_216022_a(LootParameterSets.field_216261_b));
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_174889_b(PlayerEntity player) {
        if (!player.func_175149_v()) {
            OpenCart cart = new OpenCart(this.func_145782_y());
            PacketHandler.sendToInternal(cart, (ServerPlayerEntity)player);
        }
    }

    public void func_174886_c(PlayerEntity player) {
        if (!player.func_175149_v()) {
            this.addOpener(player);
        }
    }

    public void func_184288_f(@Nullable PlayerEntity pPlayer) {
    }
}

