/*
 * Decompiled with CFR 0.152.
 */
package com.ma;

import com.ma.KeybindInit;
import com.ma.api.particles.ParticleInit;
import com.ma.blocks.BlockClientInit;
import com.ma.blocks.BlockInit;
import com.ma.blocks.tileentities.init.TileEntityClientInit;
import com.ma.blocks.tileentities.init.TileEntityInit;
import com.ma.brewing.BrewingInit;
import com.ma.commands.CommandInit;
import com.ma.commands.CommandSerializerInit;
import com.ma.config.MAClientConfig;
import com.ma.config.MAConfig;
import com.ma.config.MAEntityConfig;
import com.ma.config.MASpellConfig;
import com.ma.effects.EffectInit;
import com.ma.effects.particles.EffectParticleSpawner;
import com.ma.enchantments.EnchantmentInit;
import com.ma.entities.EntityClientInit;
import com.ma.entities.EntityInit;
import com.ma.entities.attributes.AttributeInit;
import com.ma.events.ClientEventHandler;
import com.ma.gui.GuiInit;
import com.ma.gui.HUDOverlayRenderer;
import com.ma.gui.containers.ContainerInit;
import com.ma.guide.GuideBookEntries;
import com.ma.items.ItemClientInit;
import com.ma.items.ItemInit;
import com.ma.items.armor.BoneArmorItem;
import com.ma.items.armor.CouncilArmorItem;
import com.ma.items.armor.DemonArmorItem;
import com.ma.items.armor.FeyArmorItem;
import com.ma.items.artifice.ItemThaumaturgicCompass;
import com.ma.items.renderers.BoneArmorRenderer;
import com.ma.items.renderers.CouncilArmorRenderer;
import com.ma.items.renderers.DemonArmorRenderer;
import com.ma.items.renderers.FeyArmorRenderer;
import com.ma.loot.GlobalLootModifiers;
import com.ma.particles.ParticleClientInit;
import com.ma.recipes.RecipeInit;
import com.ma.tools.ISidedProxy;
import com.ma.tools.debugging.ForgeLoggerTweaker;
import com.ma.tools.proxy.ClientProxy;
import com.ma.tools.proxy.ServerProxy;
import com.ma.worldgen.structures.MAStructures;
import java.lang.management.ManagementFactory;
import javax.annotation.Nullable;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib3.GeckoLib;
import software.bernie.geckolib3.renderers.geo.GeoArmorRenderer;

@Mod(value="mana-and-artifice")
public class ManaAndArtifice {
    public static final Logger LOGGER = LogManager.getLogger();
    public static ManaAndArtifice instance;
    public static final ResourceLocation EMPTY;
    final IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
    public ISidedProxy proxy;
    public final boolean isDebug;

    public ManaAndArtifice() {
        boolean HIDE_CONSOLE_NOISE = this.isDebug = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0;
        if (HIDE_CONSOLE_NOISE) {
            ForgeLoggerTweaker.setMinimumLevel(Level.WARN);
            ForgeLoggerTweaker.applyLoggerFilter();
        }
        MAConfig.loadServerConfig(MAConfig.SERVERCONFIG, FMLPaths.CONFIGDIR.get().resolve("mana-and-artifice-general.toml"));
        MASpellConfig.initServerConfig();
        MAEntityConfig.initServerConfig();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, MAClientConfig.CLIENT_SPEC);
        LOGGER.info("M&A -> Config Loaded");
        instance = this;
        ItemInit.ITEMS.register(this.modEventBus);
        BlockInit.BLOCKS.register(this.modEventBus);
        TileEntityInit.TILE_ENTITY_TYPES.register(this.modEventBus);
        AttributeInit.ATTRIBUTES.register(this.modEventBus);
        EntityInit.ENTITY_TYPES.register(this.modEventBus);
        ParticleInit.PARTICLES.register(this.modEventBus);
        ContainerInit.CONTAINERS.register(this.modEventBus);
        RecipeInit.SERIALIZERS.register(this.modEventBus);
        GlobalLootModifiers.LOOT_MODIFIERS.register(this.modEventBus);
        MAStructures.DEFERRED_REGISTRY_STRUCTURE.register(this.modEventBus);
        EffectInit.EFFECTS.register(this.modEventBus);
        EnchantmentInit.ENCHANTMENTS.register(this.modEventBus);
        BrewingInit.POTIONS.register(this.modEventBus);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            MinecraftForge.EVENT_BUS.register(HUDOverlayRenderer.class);
            MinecraftForge.EVENT_BUS.register(ClientEventHandler.class);
            MinecraftForge.EVENT_BUS.register(EffectParticleSpawner.class);
            MinecraftForge.EVENT_BUS.register(GuideBookEntries.class);
            this.modEventBus.addListener(this::clientInit);
            this.modEventBus.register(GuiInit.class);
            this.modEventBus.register(KeybindInit.class);
            this.modEventBus.register(ParticleClientInit.class);
            this.modEventBus.register(TileEntityClientInit.class);
            this.modEventBus.register(BlockClientInit.class);
            this.modEventBus.register(ItemClientInit.class);
            this.modEventBus.register(EntityClientInit.class);
            this.proxy = new ClientProxy();
        });
        DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> {
            this.proxy = new ServerProxy();
        });
        MinecraftForge.EVENT_BUS.register(CommandInit.class);
        this.modEventBus.register(CommandSerializerInit.class);
        GeckoLib.initialize();
        LOGGER.info("M&A -> Mod Event Bus Handlers Registered");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientInit(FMLClientSetupEvent event) {
        GeoArmorRenderer.registerArmorRenderer(BoneArmorItem.class, (GeoArmorRenderer)new BoneArmorRenderer());
        GeoArmorRenderer.registerArmorRenderer(DemonArmorItem.class, (GeoArmorRenderer)new DemonArmorRenderer());
        GeoArmorRenderer.registerArmorRenderer(FeyArmorItem.class, (GeoArmorRenderer)new FeyArmorRenderer());
        GeoArmorRenderer.registerArmorRenderer(CouncilArmorItem.class, (GeoArmorRenderer)new CouncilArmorRenderer());
        ItemModelsProperties.func_239418_a_((Item)((Item)ItemInit.THAUMATURGIC_COMPASS.get()), (ResourceLocation)new ResourceLocation("angle"), (IItemPropertyGetter)new IItemPropertyGetter(){
            private final Angle wobble;
            private final Angle wobbleRandom;
            {
                this.wobble = new Angle();
                this.wobbleRandom = new Angle();
            }

            public float call(ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity living) {
                LivingEntity entity;
                Object object = entity = living != null ? living : stack.func_234694_A_();
                if (entity == null) {
                    return 0.0f;
                }
                if (world == null && entity.field_70170_p instanceof ClientWorld) {
                    world = (ClientWorld)entity.field_70170_p;
                }
                BlockPos blockpos = ((ItemThaumaturgicCompass)ItemInit.THAUMATURGIC_COMPASS.get()).getTrackedPosition(stack, (RegistryKey<World>)world.func_234923_W_());
                long i = world.func_82737_E();
                if (blockpos != null && !(entity.func_213303_ch().func_186679_c((double)blockpos.func_177958_n() + 0.5, entity.func_213303_ch().func_82617_b(), (double)blockpos.func_177952_p() + 0.5) < (double)1.0E-5f)) {
                    double d3;
                    boolean flag = living instanceof PlayerEntity && ((PlayerEntity)living).func_175144_cb();
                    double d1 = 0.0;
                    if (flag) {
                        d1 = living.field_70177_z;
                    } else if (entity instanceof ItemFrameEntity) {
                        d1 = this.getFrameRotation((ItemFrameEntity)entity);
                    } else if (entity instanceof ItemEntity) {
                        d1 = 180.0f - ((ItemEntity)entity).func_234272_a_(0.5f) / ((float)Math.PI * 2) * 360.0f;
                    } else if (living != null) {
                        d1 = living.field_70761_aq;
                    }
                    d1 = MathHelper.func_191273_b((double)(d1 / 360.0), (double)1.0);
                    double d2 = this.getAngleTo(Vector3d.func_237489_a_((Vector3i)blockpos), (Entity)entity) / 6.2831854820251465;
                    if (flag) {
                        if (this.wobble.shouldUpdate(i)) {
                            this.wobble.update(i, 0.5 - (d1 - 0.25));
                        }
                        d3 = d2 + this.wobble.rotation;
                    } else {
                        d3 = 0.5 - (d1 - 0.25 - d2);
                    }
                    return MathHelper.func_188207_b((float)((float)d3), (float)1.0f);
                }
                if (this.wobbleRandom.shouldUpdate(i)) {
                    this.wobbleRandom.update(i, Math.random());
                }
                double d0 = this.wobbleRandom.rotation + (double)((float)stack.hashCode() / 2.1474836E9f);
                return MathHelper.func_188207_b((float)((float)d0), (float)1.0f);
            }

            private double getFrameRotation(ItemFrameEntity p_239441_1_) {
                Direction direction = p_239441_1_.func_174811_aO();
                int i = direction.func_176740_k().func_200128_b() ? 90 * direction.func_176743_c().func_179524_a() : 0;
                return MathHelper.func_188209_b((int)(180 + direction.func_176736_b() * 90 + p_239441_1_.func_82333_j() * 45 + i));
            }

            private double getAngleTo(Vector3d p_239443_1_, Entity p_239443_2_) {
                return Math.atan2(p_239443_1_.func_82616_c() - p_239443_2_.func_226281_cx_(), p_239443_1_.func_82615_a() - p_239443_2_.func_226277_ct_());
            }
        });
    }

    static {
        EMPTY = new ResourceLocation("mana-and-artifice", "empty");
    }

    @OnlyIn(value=Dist.CLIENT)
    class Angle {
        private double rotation;
        private double deltaRotation;
        private long lastUpdateTick;

        private Angle() {
        }

        private boolean shouldUpdate(long p_239448_1_) {
            return this.lastUpdateTick != p_239448_1_;
        }

        private void update(long p_239449_1_, double p_239449_3_) {
            this.lastUpdateTick = p_239449_1_;
            double d0 = p_239449_3_ - this.rotation;
            d0 = MathHelper.func_191273_b((double)(d0 + 0.5), (double)1.0) - 0.5;
            this.deltaRotation += d0 * 0.1;
            this.deltaRotation *= 0.8;
            this.rotation = MathHelper.func_191273_b((double)(this.rotation + this.deltaRotation), (double)1.0);
        }
    }
}

