/*
 * Decompiled with CFR 0.152.
 */
package com.ma.api.blocks.tile;

import com.ma.api.blocks.tile.IMultiblockDefinition;
import com.ma.api.blocks.tile.TileEntityWithInventory;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;

public abstract class MultiblockTile
extends TileEntityWithInventory
implements ITickableTileEntity {
    protected final ResourceLocation structure_path;
    protected IMultiblockDefinition _cachedMultiblockRecipe;
    protected boolean structureMatched = false;
    protected int reMatchRate = 20;
    protected int playerRadius = 32;

    public MultiblockTile(TileEntityType<?> type, ResourceLocation structure, int inventorySize) {
        super(type, inventorySize);
        this.structure_path = structure;
    }

    public MultiblockTile(TileEntityType<?> type, ResourceLocation structure) {
        this(type, structure, 0);
    }

    public void func_73660_a() {
        this.match();
    }

    protected void match() {
        PlayerEntity nearby;
        if (this.field_145850_b.func_82737_E() % (long)this.reMatchRate == 0L && (nearby = this.field_145850_b.func_190525_a((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)this.playerRadius, null)) != null) {
            this.structureMatched = false;
            this.getDefinition().ifPresent(r -> {
                this.structureMatched = r.match(this.field_145850_b, this.getMatchOrigin(), Rotation.NONE, this.matchOriginIsCenter());
                if (this.structureMatched && this.reMatchRate == this.getFastRematchRate()) {
                    this.reMatchRate = this.getSlowRematchRate();
                } else if (!this.structureMatched) {
                    this.reMatchRate = this.getFastRematchRate();
                }
            });
        }
    }

    protected boolean matchOriginIsCenter() {
        return true;
    }

    protected BlockPos getMatchOrigin() {
        return this.func_174877_v();
    }

    protected int getSlowRematchRate() {
        this.reMatchRate = 1000 + (int)(Math.random() * 100.0);
        return this.reMatchRate;
    }

    protected int getFastRematchRate() {
        this.reMatchRate = 20;
        return 20;
    }

    protected Optional<IMultiblockDefinition> getDefinition() {
        if (this._cachedMultiblockRecipe == null) {
            this.field_145850_b.func_199532_z().func_215367_a(this.structure_path).ifPresent(r -> {
                if (r instanceof IMultiblockDefinition) {
                    this._cachedMultiblockRecipe = (IMultiblockDefinition)r;
                }
            });
        }
        return Optional.ofNullable(this._cachedMultiblockRecipe);
    }
}

