/*
 * Decompiled with CFR 0.152.
 */
package com.ma.api.capabilities;

import com.ma.api.affinity.Affinity;
import com.ma.api.capabilities.Faction;
import com.ma.tools.math.MathUtils;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;

public class WellspringNode {
    public static final float MIN_STRENGTH = 5.0f;
    public static final float MAX_STRENGTH = 25.0f;
    private final float strength;
    private Affinity affinity;
    private UUID claimedBy;
    private Faction claimedByFaction;
    private int yLevel = -1;

    public WellspringNode(Affinity affinity, float strength) {
        this.affinity = affinity;
        this.strength = MathUtils.clamp(strength, 5.0f, 25.0f);
        this.claimedByFaction = Faction.NONE;
    }

    public void writeToNBT(CompoundNBT nbt) {
        nbt.func_74768_a("affinity", this.affinity.ordinal());
        nbt.func_74776_a("strength", this.strength);
        if (this.claimedBy != null) {
            nbt.func_74778_a("claimedBy", this.claimedBy.toString());
        }
        if (this.claimedByFaction != Faction.NONE) {
            nbt.func_74778_a("claimedByFaction", this.claimedByFaction.name());
        }
        if (this.yLevel > -1) {
            nbt.func_74768_a("y", this.yLevel);
        }
    }

    public void setClaimedBy(UUID playerUUID, Faction faction, int y) {
        this.claimedBy = playerUUID;
        this.claimedByFaction = faction;
        this.yLevel = y;
    }

    public boolean setAffinity(Affinity affinity) {
        if (this.affinity == Affinity.UNKNOWN) {
            this.affinity = affinity;
            return true;
        }
        return false;
    }

    public void clearClaimedBy() {
        this.claimedBy = null;
        this.claimedByFaction = Faction.NONE;
        this.yLevel = -1;
    }

    public boolean isClaimedBy(UUID playerUUID) {
        if (playerUUID == null || this.claimedBy == null) {
            return false;
        }
        return this.claimedBy.equals(playerUUID);
    }

    public boolean isClaimedBy(Faction faction) {
        if (this.claimedByFaction == Faction.NONE) {
            return false;
        }
        return this.claimedByFaction == faction;
    }

    public boolean isClaimed() {
        return this.claimedBy != null && this.claimedByFaction != Faction.NONE;
    }

    public boolean hasForcedYLevel() {
        return this.yLevel > -1;
    }

    public Affinity getAffinity() {
        return this.affinity;
    }

    public float getStrength() {
        return this.strength;
    }

    @Nullable
    public UUID getClaimedBy() {
        return this.claimedBy;
    }

    public Faction getClaimedByFaction() {
        return this.claimedByFaction;
    }

    public int getYLevel() {
        return this.yLevel;
    }

    @Nullable
    public static WellspringNode fromNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("affinity") && nbt.func_74764_b("strength")) {
            WellspringNode lln = new WellspringNode(Affinity.values()[nbt.func_74762_e("affinity")], nbt.func_74760_g("strength"));
            if (nbt.func_74764_b("claimedBy") && nbt.func_74764_b("claimedByFaction") && nbt.func_74764_b("y")) {
                lln.setClaimedBy(UUID.fromString(nbt.func_74779_i("claimedBy")), Faction.valueOf(nbt.func_74779_i("claimedByFaction")), nbt.func_74762_e("y"));
            }
            return lln;
        }
        return null;
    }
}

