/*
 * Decompiled with CFR 0.152.
 */
package com.ma.api.entities;

import com.ma.api.ManaAndArtificeMod;
import com.ma.api.capabilities.Faction;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;

public interface IFactionEnemy<T extends LivingEntity> {
    public void setRaidTarget(PlayerEntity var1);

    public PlayerEntity getRaidTarget();

    public Faction getFaction();

    default public void setDamageResists(String typeID, int level) {
        this.getDamageResists().put(typeID, level);
    }

    public HashMap<String, Integer> getDamageResists();

    public int getTier();

    public void setTier(int var1);

    default public int getTierMax() {
        return 3;
    }

    default public void raidTargetDespawn() {
        if (this.getRaidTarget() != null) {
            if (!this.getRaidTarget().func_70089_S()) {
                this.onDespawnDueToTargetDeath();
                ((LivingEntity)this).remove(false);
            } else if (this.getRaidTarget().func_70068_e((Entity)this) > 4096.0) {
                this.onDespawnDueToDistance();
                ((LivingEntity)this).remove(false);
            }
        }
    }

    default public boolean factionTargetPlayerPredicate(LivingEntity potentialTarget) {
        if (!(potentialTarget instanceof PlayerEntity)) {
            return false;
        }
        IPlayerProgression progression = (IPlayerProgression)potentialTarget.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        if (progression == null) {
            return false;
        }
        return potentialTarget.func_70089_S() && progression.getAlliedFaction() != Faction.NONE && progression.getAlliedFaction() != this.getFaction();
    }

    default public boolean factionTargetHelpPredicate(LivingEntity potentialTarget) {
        if (!(potentialTarget instanceof MobEntity)) {
            return false;
        }
        MobEntity mob = (MobEntity)potentialTarget;
        if (mob instanceof IFactionEnemy && ((IFactionEnemy)mob).getFaction() == this.getFaction()) {
            return false;
        }
        if (mob.func_70089_S() && mob.func_70638_az() instanceof PlayerEntity) {
            MutableBoolean isFaction = new MutableBoolean(false);
            ((PlayerEntity)mob.func_70638_az()).getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
                if (p.getAlliedFaction() == this.getFaction()) {
                    isFaction.setTrue();
                }
            });
            return isFaction.booleanValue();
        }
        return false;
    }

    default public void writeFactionData(CompoundNBT nbt) {
        CompoundNBT factionData = new CompoundNBT();
        factionData.func_74768_a("tier", this.getTier());
        nbt.func_218657_a("faction_data", (INBT)factionData);
    }

    default public void readFactionData(CompoundNBT nbt) {
        if (!nbt.func_74764_b("faction_data")) {
            return;
        }
        CompoundNBT factionData = nbt.func_74775_l("faction_data");
        this.setTier(factionData.func_74762_e("tier"));
    }

    default public void onKilled(DamageSource source) {
        if (source.func_76346_g() instanceof PlayerEntity) {
            ((PlayerEntity)source.func_76346_g()).getCapability(ManaAndArtificeMod.getProgressionCapability()).ifPresent(p -> p.getFactionDifficultyStats(this.getFaction()).onFactionMobKilled(source));
        }
    }

    default public void onDespawnDueToDistance() {
        if (this.getRaidTarget() != null) {
            this.getRaidTarget().getCapability(ManaAndArtificeMod.getProgressionCapability()).ifPresent(p -> p.getFactionDifficultyStats(this.getFaction()).onFactionMobDespawnDueToDistance());
        }
    }

    default public void onDespawnDueToTargetDeath() {
        if (this.getRaidTarget() != null) {
            this.getRaidTarget().getCapability(ManaAndArtificeMod.getProgressionCapability()).ifPresent(p -> p.getFactionDifficultyStats(this.getFaction()).onFactionKilledPlayer());
        }
    }

    default public float applyDamageResists(DamageSource source, float amount) {
        return amount - amount * ((float)this.getDamageResists().getOrDefault(source.field_76373_n, 0).intValue() * 0.2f);
    }

    default public void applyInitialSpawnTier(IWorld world) {
        int tier;
        MutableInt enemyTiers = new MutableInt(0);
        world.func_217369_A().forEach(player -> player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
            if (player.func_70068_e((Entity)((LivingEntity)this)) < 4096.0) {
                enemyTiers.add(p.getTier());
            }
        }));
        float tierTotal = enemyTiers.getValue().intValue();
        double[] weights = new double[]{this.getTierWeight(tierTotal, 0.0f, 8.0f), this.getTierWeight(tierTotal, 6.0f, 4.0f), tierTotal <= 10.0f ? this.getTierWeight(tierTotal, 10.0f, 7.0f) : 1.0};
        double totalWeight = 0.0;
        for (int i = 0; i < weights.length; ++i) {
            totalWeight += weights[i];
        }
        double r = Math.random() * totalWeight;
        for (tier = 0; tier < weights.length - 1 && !((r -= weights[tier]) <= 0.0); ++tier) {
        }
        this.setTier(tier);
    }

    default public double getTierWeight(float x, float shift, float steepness) {
        return Math.E * (-1.0 * (Math.pow(x - shift, 2.0) / (double)steepness));
    }
}

