/*
 * Decompiled with CFR 0.152.
 */
package com.ma.api.particles;

import com.ma.api.particles.IParticleMoveType;
import com.ma.api.particles.ParticleInit;
import com.ma.api.particles.parameters.ParticleBoolean;
import com.ma.api.particles.parameters.ParticleColor;
import com.ma.api.particles.parameters.ParticleFloat;
import com.ma.api.particles.parameters.ParticleInt;
import com.ma.api.particles.parameters.ParticleItemStack;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;

public class MAParticleType
extends ParticleType<MAParticleType>
implements IParticleData {
    private ParticleType<MAParticleType> type;
    private ParticleColor color;
    private ParticleFloat scale;
    private ParticleInt life;
    private ParticleInt lifePadding;
    private ParticleFloat gravity;
    private ParticleBoolean physics;
    private IParticleMoveType mover;
    private ParticleItemStack stack;
    public boolean disableDepthTest;
    public static final Codec<MAParticleType> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("r").forGetter(d -> Float.valueOf(d.color != null ? d.color.getRed() : 1.0f)), (App)Codec.FLOAT.fieldOf("g").forGetter(d -> Float.valueOf(d.color != null ? d.color.getGreen() : 1.0f)), (App)Codec.FLOAT.fieldOf("b").forGetter(d -> Float.valueOf(d.color != null ? d.color.getBlue() : 1.0f)), (App)Codec.FLOAT.fieldOf("scale").forGetter(d -> Float.valueOf(d.scale != null ? d.scale.value() : 1.0f)), (App)Codec.INT.fieldOf("life").forGetter(d -> d.life != null ? d.life.value() : 20), (App)Codec.INT.fieldOf("lifePadding").forGetter(d -> d.lifePadding != null ? d.lifePadding.value() : 0), (App)Codec.FLOAT.fieldOf("gravity").forGetter(d -> Float.valueOf(d.gravity != null ? d.gravity.value() : 0.0f)), (App)Codec.BOOL.fieldOf("physics").forGetter(d -> d.physics != null ? d.physics.value() : false), (App)Codec.BOOL.fieldOf("disableDepthTest").forGetter(d -> d.disableDepthTest)).apply((Applicative)instance, MAParticleType::new));
    static final IParticleData.IDeserializer<MAParticleType> DESERIALIZER = new IParticleData.IDeserializer<MAParticleType>(){

        public MAParticleType fromCommand(ParticleType<MAParticleType> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            String colorString = null;
            String scaleString = null;
            String lifeString = null;
            String lifePaddingString = null;
            String gravityString = null;
            String physString = null;
            String stackString = null;
            try {
                colorString = reader.readString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                scaleString = reader.readString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                lifeString = reader.readString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                lifePaddingString = reader.readString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                gravityString = reader.readString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                physString = reader.readString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                stackString = reader.readString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new MAParticleType(type, ParticleColor.deserialize(colorString), ParticleFloat.deserialize(scaleString), ParticleInt.deserialize(lifeString), ParticleInt.deserialize(lifePaddingString), ParticleFloat.deserialize(gravityString), ParticleBoolean.deserialize(physString), ParticleItemStack.deserialize(stackString), null, reader.readBoolean());
        }

        public MAParticleType fromNetwork(ParticleType<MAParticleType> type, PacketBuffer buffer) {
            ParticleColor color = null;
            if (buffer.readBoolean()) {
                color = ParticleColor.deserialize(buffer.func_150789_c(Short.MAX_VALUE));
            }
            return new MAParticleType(type, color, ParticleFloat.deserialize(buffer), ParticleInt.deserialize(buffer), ParticleInt.deserialize(buffer), ParticleFloat.deserialize(buffer), ParticleBoolean.deserialize(buffer), ParticleItemStack.deserialize(buffer), IParticleMoveType.fromID(buffer.readInt()).deserialize(buffer), buffer.readBoolean());
        }
    };

    public MAParticleType() {
        super(false, DESERIALIZER);
    }

    public MAParticleType(ParticleType<MAParticleType> type) {
        this();
        this.type = type;
    }

    private MAParticleType(float r, float g, float b, float scale, int life, int lifePadding, float gravity, boolean physics, boolean disableDepth) {
        super(disableDepth, DESERIALIZER);
        this.setColor(r, g, b);
        this.setScale(scale);
        this.setGravity(gravity);
        this.setPhysics(physics);
        this.setMaxAge(life);
    }

    private MAParticleType(ParticleType<MAParticleType> type, ParticleColor color, ParticleFloat scale, ParticleInt life, ParticleInt lifePadding, ParticleFloat gravity, ParticleBoolean physics, ParticleItemStack stack, IParticleMoveType mover, boolean disableDepth) {
        super(disableDepth, DESERIALIZER);
        this.color = color;
        this.scale = scale;
        this.life = life;
        this.lifePadding = lifePadding;
        this.gravity = gravity;
        this.physics = physics;
        this.mover = mover;
    }

    public Codec<MAParticleType> func_230522_e_() {
        return CODEC;
    }

    public void func_197553_a(PacketBuffer packetBuffer) {
        if (this.color != null) {
            packetBuffer.writeBoolean(true);
            packetBuffer.func_180714_a(this.color.serialize());
        } else {
            packetBuffer.writeBoolean(false);
        }
        ParticleFloat.serialize(this.scale, packetBuffer);
        ParticleInt.serialize(this.life, packetBuffer);
        ParticleInt.serialize(this.lifePadding, packetBuffer);
        ParticleFloat.serialize(this.gravity, packetBuffer);
        ParticleBoolean.serialize(this.physics, packetBuffer);
        if (this.mover != null) {
            packetBuffer.writeBoolean(true);
            this.mover.serialize(packetBuffer);
        } else {
            packetBuffer.writeBoolean(false);
        }
        packetBuffer.writeBoolean(this.disableDepthTest);
    }

    public String func_197555_a() {
        return this.func_197554_b().getRegistryName().toString() + " " + (this.color != null ? this.color.serialize() : "NO COLOR OVERRIDE") + " " + (this.scale != null ? this.scale.serialize() : "NO SCALE OVERRIDE") + (this.life != null ? this.life.serialize() : "NO LIFE OVERRIDE") + (this.lifePadding != null ? this.lifePadding.serialize() : "NO LIFE PADDING") + (this.mover != null ? this.mover.serialize() : "NO MOVE OVERRIDE");
    }

    public MAParticleType setColor(float r, float g, float b) {
        this.color = new ParticleColor(r, g, b);
        return this;
    }

    public MAParticleType setScale(float scale) {
        this.scale = new ParticleFloat(scale);
        return this;
    }

    public MAParticleType setColor(int r, int g, int b) {
        this.color = new ParticleColor(r, g, b);
        return this;
    }

    public MAParticleType setMaxAge(int age) {
        this.life = new ParticleInt(age);
        return this;
    }

    public MAParticleType setAgePadding(int padding) {
        this.lifePadding = new ParticleInt(padding);
        return this;
    }

    public MAParticleType setGravity(float gravity) {
        this.gravity = new ParticleFloat(gravity);
        return this;
    }

    public MAParticleType setPhysics(boolean physics) {
        this.physics = new ParticleBoolean(physics);
        return this;
    }

    public MAParticleType setStack(ItemStack stack) {
        this.stack = new ParticleItemStack(stack);
        return this;
    }

    public MAParticleType setMover(IParticleMoveType mover) {
        this.mover = mover;
        return this;
    }

    @Nullable
    public IParticleMoveType getMover() {
        return this.mover;
    }

    @Nullable
    public ParticleColor getColor() {
        return this.color;
    }

    @Nullable
    public ParticleFloat getScale() {
        return this.scale;
    }

    @Nullable
    public ParticleInt getLife() {
        return this.life;
    }

    @Nullable
    public ParticleInt getLifePadding() {
        return this.lifePadding;
    }

    @Nullable
    public ParticleFloat getGravity() {
        return this.gravity;
    }

    @Nullable
    public ParticleBoolean getPhysics() {
        return this.physics;
    }

    @Nullable
    public ParticleItemStack getStack() {
        return this.stack;
    }

    public ParticleType<MAParticleType> func_197554_b() {
        return this.type == null ? (ParticleType)ParticleInit.BLUE_SPARKLE_VELOCITY.get() : this.type;
    }
}

