/*
 * Decompiled with CFR 0.152.
 */
package com.ma.api.spells.base;

import com.ma.api.capabilities.Faction;
import com.ma.api.spells.SpellCraftingContext;
import com.ma.api.spells.SpellPartTags;
import com.ma.api.spells.base.SpellBlacklistResult;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public interface ISpellComponent {
    public ResourceLocation getRegistryName();

    public ResourceLocation getGuiIcon();

    public boolean isCraftable(SpellCraftingContext var1);

    public boolean isUseableByPlayers();

    public int requiredXPForRote();

    public SpellPartTags getUseTag();

    default public Faction getFactionRequirement() {
        return Faction.NONE;
    }

    default public boolean canBeOnRandomStaff() {
        return true;
    }

    public int getTier(World var1);

    public SpellBlacklistResult canBeCastAt(World var1, Vector3d var2);

    default public boolean magnitudeHealthCheck(SpellSource source, SpellTarget target, int magnitude, int healthPerMagnitude) {
        if (source.getCaster() == target.getEntity()) {
            return true;
        }
        if (!target.isLivingEntity()) {
            return false;
        }
        int maxHP = healthPerMagnitude * magnitude;
        if (target.getLivingEntity().func_110138_aP() > (float)maxHP) {
            if (source.isPlayerCaster()) {
                source.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("mana-and-artifice:generic.too_powerful"), Util.field_240973_b_);
            }
            return false;
        }
        return true;
    }
}

