/*
 * Decompiled with CFR 0.152.
 */
package com.ma.api.spells.parts;

import com.google.common.collect.ImmutableList;
import com.ma.api.affinity.Affinity;
import com.ma.api.recipes.IMARecipe;
import com.ma.api.sound.SFX;
import com.ma.api.spells.ComponentApplicationResult;
import com.ma.api.spells.SpellCraftingContext;
import com.ma.api.spells.SpellPartTags;
import com.ma.api.spells.SpellReagent;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiable;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.base.ISpellComponent;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.base.SpellBlacklistResult;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.config.MASpellConfig;
import com.ma.config.SpellModConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class Component
extends ForgeRegistryEntry<Component>
implements IModifiable,
ISpellComponent {
    private final ResourceLocation guiIcon;
    private final ImmutableList<AttributeValuePair> modifiableAttributes;
    private Integer tier;

    public Component(ResourceLocation registryName, ResourceLocation guiIcon, AttributeValuePair ... attributeValuePairs) {
        this.setRegistryName(registryName);
        ArrayList<AttributeValuePair> list = new ArrayList<AttributeValuePair>(Arrays.asList(attributeValuePairs));
        if (!list.stream().anyMatch(m -> m.getAttribute() == Attribute.DELAY)) {
            list.add(new AttributeValuePair(Attribute.DELAY, 0.0f, 0.0f, 3.0f, 0.1f, 0.5f));
        }
        SpellModConfig.initForPart(MASpellConfig.BUILDER, this, list.toArray(new AttributeValuePair[0]));
        this.modifiableAttributes = ImmutableList.copyOf(list);
        this.guiIcon = guiIcon;
    }

    @Override
    public final ImmutableList<AttributeValuePair> getModifiableAttributes() {
        return AttributeValuePair.deepCopy(this.modifiableAttributes);
    }

    public final void lookupAttributeConfig() {
        this.modifiableAttributes.forEach(m -> m.lookupConfig(this));
    }

    @Override
    public SpellBlacklistResult canBeCastAt(World world, Vector3d position) {
        if (world.field_72995_K) {
            return SpellBlacklistResult.ALLOWED;
        }
        BlockPos bp = new BlockPos(position);
        Biome biome = world.func_226691_t_(bp);
        if (SpellModConfig.isDimensionBlacklisted(this, world.func_234923_W_().getRegistryName())) {
            return SpellBlacklistResult.DIMENSION_BLOCKED;
        }
        if (SpellModConfig.isBiomeBlacklisted(this, biome.getRegistryName())) {
            return SpellBlacklistResult.BIOME_BLOCKED;
        }
        return SpellBlacklistResult.ALLOWED;
    }

    public abstract ComponentApplicationResult ApplyEffect(SpellSource var1, SpellTarget var2, IModifiedSpellPart<Component> var3, SpellContext var4);

    public SoundEvent SoundEffect() {
        return SFX.Spell.Impact.Single.ARCANE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void SpawnParticles(World world, Vector3d impact_position, int age, @Nullable PlayerEntity caster, @Nullable ISpellDefinition recipe) {
    }

    public abstract Affinity getAffinity();

    @Override
    public final ResourceLocation getGuiIcon() {
        return this.guiIcon;
    }

    @Override
    public boolean isCraftable(SpellCraftingContext context) {
        return true;
    }

    public abstract float initialComplexity();

    public int baselineCooldown() {
        return 0;
    }

    public boolean canBeChanneled() {
        return true;
    }

    public boolean targetsEntities() {
        return true;
    }

    public boolean targetsBlocks() {
        return true;
    }

    public Direction defaultBlockFace() {
        return Direction.UP;
    }

    @Override
    public boolean isUseableByPlayers() {
        return true;
    }

    @Nullable
    public List<SpellReagent> getRequiredReagents(@Nullable PlayerEntity caster) {
        return null;
    }

    public boolean autoConsumeReagents() {
        return true;
    }

    @Override
    public int getTier(World world) {
        if (this.tier == null) {
            Optional recipe = world.func_199532_z().func_215367_a(this.getRegistryName());
            this.tier = recipe.isPresent() && recipe.get() instanceof IMARecipe ? Integer.valueOf(((IMARecipe)recipe.get()).getTier()) : Integer.valueOf(0);
            if (this.tier < 0) {
                this.tier = 0;
            }
        }
        return this.tier;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.NEUTRAL;
    }

    protected boolean casterTeamCheck(SpellSource source, SpellTarget target) {
        if (source.getCaster() == target.getEntity()) {
            return true;
        }
        if (!target.isEntity()) {
            return false;
        }
        if (source.isPlayerCaster() && target.getLivingEntity() instanceof PlayerEntity) {
            PlayerEntity caster = source.getPlayer();
            PlayerEntity tgt = (PlayerEntity)target.getLivingEntity();
            return caster.func_184191_r((Entity)tgt);
        }
        return true;
    }

    public static class PhantomComponent
    extends Component {
        public static PhantomComponent instance = new PhantomComponent();
        private static final ResourceLocation _default = new ResourceLocation("mana-and-artifice:component_default");

        public PhantomComponent() {
            super(_default, _default, new AttributeValuePair[0]);
        }

        @Override
        public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<Component> modificationData, SpellContext context) {
            return ComponentApplicationResult.SUCCESS;
        }

        @Override
        public Affinity getAffinity() {
            return Affinity.UNKNOWN;
        }

        @Override
        public float initialComplexity() {
            return 0.0f;
        }

        @Override
        public int requiredXPForRote() {
            return -1;
        }

        @Override
        public SpellPartTags getUseTag() {
            return SpellPartTags.NEUTRAL;
        }
    }
}

