/*
 * Decompiled with CFR 0.152.
 */
package com.ma.api.spells.targeting;

import com.ma.api.spells.parts.Component;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;

public final class SpellTarget {
    private BlockPos BlockTarget;
    private Direction BlockFace;
    private Entity EntityTarget;
    private boolean offsetFace = true;
    public static SpellTarget NONE = new SpellTarget();

    private SpellTarget() {
        this.BlockTarget = null;
        this.EntityTarget = null;
        this.BlockFace = Direction.UP;
    }

    public SpellTarget(BlockPos pos, @Nullable Direction face) {
        this.BlockTarget = pos;
        this.EntityTarget = null;
        this.BlockFace = face;
    }

    public SpellTarget(Entity entity) {
        this.EntityTarget = entity;
        this.BlockTarget = null;
        this.BlockFace = Direction.UP;
    }

    public SpellTarget doNotOffsetFace() {
        this.offsetFace = false;
        return this;
    }

    public final boolean isBlock() {
        return this.BlockTarget != null;
    }

    public final boolean isEntity() {
        return this.EntityTarget != null;
    }

    public final boolean isLivingEntity() {
        return this.isEntity() && this.EntityTarget instanceof LivingEntity;
    }

    public final BlockPos getBlock() {
        return this.isBlock() ? this.BlockTarget : new BlockPos(this.EntityTarget.func_213303_ch());
    }

    public final Direction getBlockFace(@Nullable Component c) {
        return this.BlockFace != null ? this.BlockFace : (c != null ? c.defaultBlockFace() : Direction.DOWN);
    }

    public boolean offsetFace() {
        return this.offsetFace;
    }

    @Nullable
    public final Entity getEntity() {
        return this.EntityTarget;
    }

    public final Vector3d getPosition() {
        return this.isBlock() ? new Vector3d((double)this.BlockTarget.func_177958_n(), (double)this.BlockTarget.func_177956_o(), (double)this.BlockTarget.func_177952_p()).func_72441_c(0.5, 0.5, 0.5) : this.EntityTarget.func_213303_ch();
    }

    @Nullable
    public final LivingEntity getLivingEntity() {
        if (this.isLivingEntity()) {
            return (LivingEntity)this.EntityTarget;
        }
        return null;
    }

    public final void overrideSpellTarget(Entity e) {
        this.EntityTarget = e;
        this.BlockTarget = null;
        this.BlockFace = Direction.UP;
    }

    public final void overrideSpellTarget(BlockPos pos, Direction face) {
        this.EntityTarget = null;
        this.BlockTarget = pos;
        this.BlockFace = face;
    }
}

