/*
 * Decompiled with CFR 0.152.
 */
package com.ma.api.spells.targeting;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class SpellTargetHelper {
    @Nullable
    public static EntityRayTraceResult rayTraceEntities(World world, Entity caster, Vector3d startVec, Vector3d endVec, AxisAlignedBB boundingBox, Predicate<Entity> filter) {
        return SpellTargetHelper.rayTraceEntities(world, caster, startVec, endVec, boundingBox, filter, Double.MAX_VALUE);
    }

    @Nullable
    public static EntityRayTraceResult rayTraceEntities(World worldIn, @Nullable Entity projectile, Vector3d startVec, Vector3d endVec, AxisAlignedBB boundingBox, Predicate<Entity> filter, double max_distance) {
        double cur_distance = max_distance;
        Entity target_candidate = null;
        for (Entity entity : worldIn.func_175674_a(projectile, boundingBox, filter)) {
            double entityDistance;
            AxisAlignedBB entityBoundingBox = entity.func_174813_aQ().func_186662_g((double)0.3f);
            Optional optional = entityBoundingBox.func_216365_b(startVec, endVec);
            if (!optional.isPresent() || !((entityDistance = startVec.func_72436_e((Vector3d)optional.get())) < cur_distance)) continue;
            target_candidate = entity;
            cur_distance = entityDistance;
        }
        return target_candidate == null ? null : new EntityRayTraceResult(target_candidate);
    }

    @Nullable
    public static RayTraceResult rayTrace(@Nullable Entity caster, World world, Vector3d casterPosition, Vector3d casterLook, boolean checkEntityCollision, boolean includeCaster, RayTraceContext.BlockMode blockModeIn, Predicate<Entity> filter, AxisAlignedBB boundingBox, double range) {
        Vector3d look_projected = casterPosition.func_178787_e(casterLook.func_216372_d(range, range, range));
        BlockRayTraceResult raytraceresult = world.func_217299_a(new RayTraceContext(casterPosition, look_projected, blockModeIn, RayTraceContext.FluidMode.NONE, caster));
        if (checkEntityCollision) {
            EntityRayTraceResult entity_trace_result;
            if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
                look_projected = raytraceresult.func_216347_e();
            }
            if ((entity_trace_result = SpellTargetHelper.rayTraceEntities(world, caster, casterPosition, look_projected, boundingBox, filter)) != null) {
                raytraceresult = entity_trace_result;
            }
        }
        return raytraceresult;
    }
}

