/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks;

import com.ma.ManaAndArtifice;
import com.ma.blocks.BlockInit;
import com.ma.blocks.interfaces.ICutoutBlock;
import com.ma.blocks.interfaces.ITranslucentBlock;
import com.ma.tools.RLoc;
import net.minecraft.block.Block;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class BlockClientInit {
    @SubscribeEvent
    public static void onClientSetupEvent(FMLClientSetupEvent event) {
        BlockInit.BLOCKS.getEntries().stream().map(RegistryObject::get).forEach(block -> {
            if (block instanceof ICutoutBlock || block instanceof FlowerPotBlock) {
                RenderTypeLookup.setRenderLayer((Block)block, (RenderType)RenderType.func_228643_e_());
            } else if (block instanceof ITranslucentBlock) {
                RenderTypeLookup.setRenderLayer((Block)block, (RenderType)RenderType.func_228645_f_());
            }
        });
        RenderTypeLookup.setRenderLayer((Block)((Block)BlockInit.SLIPSTREAM_GENERATOR.get()), (RenderType)RenderType.func_228641_d_());
        ManaAndArtifice.LOGGER.info("M&A -> Block Render Layers Set");
    }

    @SubscribeEvent
    public static void onRegisterBlockColors(ColorHandlerEvent.Block event) {
        event.getBlockColors().func_186722_a((blockstate, lightReader, position, d) -> lightReader != null && position != null ? BiomeColors.func_228363_c_((IBlockDisplayReader)lightReader, (BlockPos)position) : -1, new Block[]{(Block)BlockInit.RUNESCRIBING_TABLE.get()});
        ManaAndArtifice.LOGGER.info("M&A -> Block Colors Registered");
    }

    @SubscribeEvent
    public static void onRegisterSpecialModels(ModelRegistryEvent event) {
        ModelLoader.addSpecialModel((ResourceLocation)RLoc.create("block/arcane_sentry"));
        ModelLoader.addSpecialModel((ResourceLocation)RLoc.create("block/pedestal"));
        ModelLoader.addSpecialModel((ResourceLocation)RLoc.create("block/mana_resevoir/full"));
        ModelLoader.addSpecialModel((ResourceLocation)RLoc.create("block/mana_crystal"));
        ModelLoader.addSpecialModel((ResourceLocation)RLoc.create("block/manaweaving_altar_crystal_a"));
        ModelLoader.addSpecialModel((ResourceLocation)RLoc.create("block/manaweaving_altar_crystal_b"));
        ModelLoader.addSpecialModel((ResourceLocation)RLoc.create("block/manaweaving_altar_crystal_c"));
        ModelLoader.addSpecialModel((ResourceLocation)RLoc.create("block/occulus_eye_shell_interior"));
        ModelLoader.addSpecialModel((ResourceLocation)RLoc.create("block/occulus_eye_shell"));
        ModelLoader.addSpecialModel((ResourceLocation)RLoc.create("block/eldrin/wellspring_pillar_cap"));
        ModelLoader.addSpecialModel((ResourceLocation)RLoc.create("block/eldrin/supplier_lower_exterior"));
        ModelLoader.addSpecialModel((ResourceLocation)RLoc.create("block/eldrin/supplier_lower_interior"));
        ModelLoader.addSpecialModel((ResourceLocation)RLoc.create("block/eldrin/supplier_upper"));
        ModelLoader.addSpecialModel((ResourceLocation)RLoc.create("block/eldrin/receiver_crystal"));
        ModelLoader.addSpecialModel((ResourceLocation)RLoc.create("block/inscription_table"));
        ModelLoader.addSpecialModel((ResourceLocation)RLoc.create("block/inscription_table_ash"));
        ModelLoader.addSpecialModel((ResourceLocation)RLoc.create("block/inscription_table_ink"));
        ModelLoader.addSpecialModel((ResourceLocation)RLoc.create("block/inscription_table_vellum"));
        ModelLoader.addSpecialModel((ResourceLocation)RLoc.create("block/illusion_block"));
        ModelLoader.addSpecialModel((ResourceLocation)RLoc.create("block/lodestar_base"));
        ModelLoader.addSpecialModel((ResourceLocation)RLoc.create("block/lodestar_crystalsmall"));
        ModelLoader.addSpecialModel((ResourceLocation)RLoc.create("block/lodestar_crystalbig"));
        ModelLoader.addSpecialModel((ResourceLocation)RLoc.create("block/lodestar_gearsmall"));
        ModelLoader.addSpecialModel((ResourceLocation)RLoc.create("block/lodestar_stabilizer"));
    }
}

