/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.artifice;

import com.ma.api.affinity.Affinity;
import com.ma.api.blocks.ISpellInteractibleBlock;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.blocks.WaterloggableBlock;
import com.ma.capabilities.worlddata.WorldMagicProvider;
import com.ma.config.GeneralModConfig;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class WardingCandleBlock
extends WaterloggableBlock
implements ISpellInteractibleBlock<WardingCandleBlock> {
    public static final BooleanProperty ACTIVE = BooleanProperty.func_177716_a((String)"active");
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public WardingCandleBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151577_b).func_226896_b_().func_200943_b(1.0f), false);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult p_225533_6_) {
        if (!worldIn.field_72995_K) {
            BlockState newstate = state;
            newstate = (BlockState)state.func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((Property)ACTIVE) == false));
            if (((Boolean)newstate.func_177229_b((Property)ACTIVE)).booleanValue()) {
                if (player.func_184586_b(handIn).func_77973_b() != Items.field_151033_d) {
                    return ActionResultType.FAIL;
                }
                worldIn.getCapability(WorldMagicProvider.MAGIC).ifPresent(w -> w.addWardingCandleLocation(pos));
                worldIn.func_184133_a(null, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, 1.0f);
            } else {
                worldIn.getCapability(WorldMagicProvider.MAGIC).ifPresent(w -> w.removeWardingCandleLocation(pos));
                worldIn.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            worldIn.func_180501_a(pos, newstate, 1);
            worldIn.func_184138_a(pos, state, newstate, 2);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((Property)ACTIVE)).booleanValue()) {
            worldIn.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_FLAME.get())), (double)((float)pos.func_177958_n() + 0.5f), (double)(pos.func_177956_o() + 1), (double)((float)pos.func_177952_p() + 0.5f), 0.0, (double)0.01f, 0.0);
        }
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{ACTIVE});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return 15;
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, TileEntity te, ItemStack stack) {
        if (!worldIn.field_72995_K) {
            worldIn.getCapability(WorldMagicProvider.MAGIC).ifPresent(w -> w.removeWardingCandleLocation(pos));
        }
        super.func_180657_a(worldIn, player, pos, state, te, stack);
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        if (!worldIn.field_72995_K) {
            worldIn.getCapability(WorldMagicProvider.MAGIC).ifPresent(w -> w.removeWardingCandleLocation(pos));
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!worldIn.field_72995_K) {
            worldIn.getCapability(WorldMagicProvider.MAGIC).ifPresent(w -> w.removeWardingCandleLocation(pos));
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    @Override
    public boolean onHitBySpell(World world, BlockPos pos, ISpellDefinition spell) {
        BlockState existing;
        if (!world.field_72995_K && spell.getAffinity().containsKey((Object)Affinity.FIRE) && (existing = world.func_180495_p(pos)).func_235901_b_((Property)ACTIVE) && !((Boolean)existing.func_177229_b((Property)ACTIVE)).booleanValue()) {
            BlockState newState = (BlockState)existing.func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(true));
            world.getCapability(WorldMagicProvider.MAGIC).ifPresent(w -> w.addWardingCandleLocation(pos));
            world.func_180501_a(pos, newState, 1);
            world.func_184138_a(pos, existing, newState, 2);
            return true;
        }
        return false;
    }

    public static boolean shouldEntityBeBlocked(Entity entity) {
        String regName = entity.func_200600_R().getRegistryName().toString();
        if (((String)GeneralModConfig.MA_WARD_BLACKLIST.get()).contains(regName)) {
            return false;
        }
        if (((String)GeneralModConfig.MA_WARD_WHITELIST.get()).contains(regName)) {
            return true;
        }
        if (!entity.func_184222_aU()) {
            return false;
        }
        return entity instanceof IMob || entity instanceof ChickenEntity && ((ChickenEntity)entity).func_152116_bZ();
    }
}

