/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.sorcery;

import com.ma.blocks.interfaces.IDontCreateBlockItem;
import com.ma.blocks.interfaces.ITranslucentBlock;
import com.ma.blocks.tileentities.TransitoryTile;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;

public class TransitoryTileBlock
extends Block
implements ITranslucentBlock,
IDontCreateBlockItem {
    public static final IntegerProperty DURATION = IntegerProperty.func_177719_a((String)"duration", (int)0, (int)30);

    public TransitoryTileBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_175972_I).func_200943_b(1.0f).harvestTool(ToolType.PICKAXE).harvestLevel(1).func_226896_b_().func_235847_c_((state, reader, pos) -> false));
    }

    public boolean func_200123_i(BlockState p_200123_1_, IBlockReader p_200123_2_, BlockPos p_200123_3_) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{DURATION});
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (worldIn instanceof ServerWorld) {
            this.checkNeighbors((IWorldReader)worldIn, pos);
        }
    }

    public void func_180633_a(World p_180633_1_, BlockPos p_180633_2_, BlockState p_180633_3_, LivingEntity p_180633_4_, ItemStack p_180633_5_) {
        p_180633_1_.func_195593_d(p_180633_2_, (Block)this);
    }

    private void checkNeighbors(IWorldReader worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof TransitoryTile) {
            for (Direction d : Direction.values()) {
                BlockPos directionOffset = pos.func_177971_a(d.func_176730_m());
                BlockState directionState = worldIn.func_180495_p(directionOffset);
                if (directionState.func_177230_c() != this) continue;
                ((TransitoryTile)te).setNeighborOnSide(d);
                TileEntity neighbor = worldIn.func_175625_s(directionOffset);
                if (neighbor == null || !(neighbor instanceof TransitoryTile)) continue;
                ((TransitoryTile)neighbor).setNeighborOnSide(d.func_176734_d());
            }
        }
    }

    public void onNeighborChange(BlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        TileEntity te;
        if (!world.func_201670_d() && (te = world.func_175625_s(pos)) != null && te instanceof TransitoryTile) {
            BlockState neighborState = world.func_180495_p(neighbor);
            if (neighborState.func_177230_c() == this) {
                ((TransitoryTile)te).setNeighborOnSide(this.directionBetweenPositions(pos, neighbor));
            } else {
                ((TransitoryTile)te).clearNeighborOnSide(this.directionBetweenPositions(pos, neighbor));
            }
        }
    }

    @Nullable
    private Direction directionBetweenPositions(BlockPos a, BlockPos b) {
        if (a.func_177984_a().equals((Object)b)) {
            return Direction.UP;
        }
        if (a.func_177977_b().equals((Object)b)) {
            return Direction.DOWN;
        }
        if (a.func_177974_f().equals((Object)b)) {
            return Direction.EAST;
        }
        if (a.func_177976_e().equals((Object)b)) {
            return Direction.WEST;
        }
        if (a.func_177978_c().equals((Object)b)) {
            return Direction.NORTH;
        }
        if (a.func_177968_d().equals((Object)b)) {
            return Direction.SOUTH;
        }
        return null;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TransitoryTile();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.INVISIBLE;
    }
}

