/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.tileentities;

import com.ma.api.affinity.Affinity;
import com.ma.api.blocks.IRequirePlayerReference;
import com.ma.api.blocks.tile.BlockPosCache;
import com.ma.api.blocks.tile.IMultiblockDefinition;
import com.ma.api.blocks.tile.IPowerSupplierTile;
import com.ma.api.blocks.tile.MultiblockTile;
import com.ma.api.capabilities.Faction;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.blocks.BlockInit;
import com.ma.blocks.tileentities.PedestalTile;
import com.ma.blocks.tileentities.init.TileEntityInit;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.capabilities.worlddata.WorldMagicProvider;
import com.ma.entities.utility.EntityPresentItem;
import com.ma.particles.types.movers.ParticleBezierMover;
import com.ma.particles.types.movers.ParticleLerpMover;
import com.ma.particles.types.movers.ParticleSphereOrbitMover;
import com.ma.particles.types.movers.ParticleVelocityMover;
import com.ma.recipes.ItemAndPatternCraftingInventory;
import com.ma.recipes.RecipeInit;
import com.ma.recipes.eldrin.EldrinAltarRecipe;
import com.ma.recipes.manaweaving.ManaweavingPattern;
import com.ma.recipes.manaweaving.ManaweavingPatternHelper;
import com.ma.sound.PredicateLoopingSound;
import com.ma.tools.MATags;
import com.ma.tools.RLoc;
import com.ma.tools.math.MathUtils;
import com.ma.tools.render.MultiblockRenderer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeTileEntity;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;

public class EldrinAltarTile
extends MultiblockTile
implements ITickableTileEntity,
IForgeTileEntity,
IRequirePlayerReference<EldrinAltarTile> {
    private static final int MAX_ITEMS = 1;
    public static final int INVENTORY_SLOT_INDEX = 0;
    public static final Vector3d[] crystal_offsets = new Vector3d[]{new Vector3d(1.0, 0.0, 0.0), new Vector3d(-1.0, 0.0, 0.0), new Vector3d(0.5, 0.0, 1.0), new Vector3d(-0.5, 0.0, 1.0), new Vector3d(0.5, 0.0, -1.0), new Vector3d(-0.5, 0.0, -1.0)};
    private int stage = Stage.IDLE.ordinal();
    private int stageTicks = 0;
    private EldrinAltarRecipe __cachedRecipe;
    private ResourceLocation __cachedRecipeId;
    private BlockPosCache __powerSuppliers;
    private ArrayList<String> pendingPatterns;
    private ArrayList<ManaweavingPattern> addedPatterns;
    private UUID __crafterID;
    private PlayerEntity __crafter;
    private final ArrayList<ActiveCrystal> activeCrystals = new ArrayList();
    private final ArrayList<CollectedItem> collectedItems = new ArrayList();

    public EldrinAltarTile(TileEntityType<?> p_i48289_1_) {
        super(p_i48289_1_, RLoc.create("multiblock/eldrin_altar"), 1);
        this.__powerSuppliers = new BlockPosCache(this, 7, bp -> {
            if (!this.losCheck(bp.func_177984_a())) {
                return false;
            }
            TileEntity te = this.field_145850_b.func_175625_s(bp);
            return te != null && te instanceof IPowerSupplierTile;
        });
        this.addedPatterns = new ArrayList();
        this.pendingPatterns = new ArrayList();
    }

    protected boolean losCheck(BlockPos pos) {
        Vector3d vector3d1;
        Vector3d vector3d = Vector3d.func_237489_a_((Vector3i)this.func_174877_v().func_177984_a());
        BlockRayTraceResult result = this.field_145850_b.func_217299_a(new RayTraceContext(vector3d, vector3d1 = Vector3d.func_237489_a_((Vector3i)pos), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, null));
        if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
            return result.func_216350_a().equals((Object)pos);
        }
        return false;
    }

    public EldrinAltarTile() {
        this((TileEntityType)TileEntityInit.ELDRIN_ALTAR_TILE.get());
    }

    public Stage getStage() {
        return Stage.values()[this.stage];
    }

    public int getStageTicks() {
        return this.stageTicks;
    }

    private void setStage(Stage stage) {
        this.stage = stage.ordinal();
        this.stageTicks = 0;
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    private void resolvePendingPatterns() {
        if (this.field_145850_b != null && this.pendingPatterns.size() > 0) {
            for (String s : this.pendingPatterns) {
                ManaweavingPattern p = ManaweavingPatternHelper.GetManaweavingRecipe(this.field_145850_b, new ResourceLocation(s));
                if (p == null) continue;
                this.addedPatterns.add(p);
            }
            this.pendingPatterns.clear();
        }
    }

    private EldrinAltarRecipe getCachedRecipe() {
        if (this.__cachedRecipe == null && this.__cachedRecipeId != null) {
            this.field_145850_b.func_199532_z().func_215367_a(this.__cachedRecipeId).ifPresent(r -> {
                if (r instanceof EldrinAltarRecipe) {
                    this.__cachedRecipe = (EldrinAltarRecipe)r;
                }
            });
        }
        return this.__cachedRecipe;
    }

    private PlayerEntity getCrafter() {
        if (this.__crafter == null && this.__crafterID != null) {
            this.__crafter = this.field_145850_b.func_217371_b(this.__crafterID);
        }
        return this.__crafter;
    }

    @Override
    public void setPlayerReference(PlayerEntity player) {
        this.__crafter = player;
        this.__crafterID = player.func_110124_au();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v()).func_186662_g(5.0);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.__powerSuppliers.tick();
        ++this.stageTicks;
        if (this.field_145850_b.field_72995_K) {
            this.spawnParticles();
            this.playSounds();
        } else {
            switch (this.getStage()) {
                case FINDING_POWER: {
                    this.tickLogic_findPower();
                    break;
                }
                case CONSUMING_REAGENTS: {
                    this.tickLogic_consumeReagents();
                    break;
                }
                case REQUESTING_MANAWEAVES: {
                    this.tickLogic_requestManaweaves();
                    break;
                }
                case CRAFTING: {
                    this.tickLogic_craft();
                    break;
                }
                case COMPLETING: {
                    this.tickLogic_complete();
                    break;
                }
            }
        }
    }

    public boolean structureMatched() {
        return this.structureMatched;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setGhostMultiblock() {
        this.getDefinition().ifPresent(r -> {
            BlockPos anchorPos = this.getMatchOrigin();
            MultiblockRenderer.setMultiblock(r, (ITextComponent)new TranslationTextComponent(r.func_199560_c().toString()), false);
            MultiblockRenderer.anchorTo(anchorPos, Rotation.NONE);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnParticles() {
        if (this.getStage() != Stage.IDLE) {
            this.spawnParticles_active();
            this.spawnParticles_crystals();
            this.spawnParticles_items();
            this.spawnParticles_lights();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnParticles_active() {
        double angle;
        int i;
        int angleStep = 60;
        Vector3d center = Vector3d.func_237489_a_((Vector3i)this.func_174877_v()).func_178786_a(0.0, 0.5, 0.0);
        for (i = 0; i < 360; i += angleStep) {
            angle = (double)((i + this.stageTicks) % 360) * Math.PI / 180.0;
            Vector3d offset = center.func_178787_e(new Vector3d(Math.sin(angle), 0.0, Math.cos(angle)).func_72432_b().func_186678_a(4.0)).func_72441_c(0.0, 1.0, 0.0);
            this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.TRAIL_ORBIT.get())).setScale(0.25f).setMaxAge(50).setColor(2, 1, 5).setMover(new ParticleBezierMover(center, offset)), center.field_72450_a, center.field_72448_b, center.field_72449_c, 0.0, 0.0, 0.0);
        }
        for (i = 0; i < 20; ++i) {
            angle = Math.random() * 360.0;
            double distance = Math.random() * 2.0 + 3.0;
            Vector3d offset = new Vector3d(Math.sin(angle), 0.0, Math.cos(angle)).func_72432_b().func_186678_a(distance);
            this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.LIGHT_VELOCITY.get())).setScale(0.6f).setMaxAge(20).setColor(98, 149, 181), center.field_72450_a + offset.field_72450_a, center.field_72448_b, center.field_72449_c + offset.field_72449_c, 0.0, 0.01, 0.0);
        }
        if (this.stageTicks == 1) {
            angleStep = 10;
            for (i = 0; i <= 360; i += angleStep) {
                int angle2 = (i + this.stageTicks * 2) % 360;
                Vector3d offset = new Vector3d(Math.sin((double)angle2 * Math.PI / 180.0), 0.0, Math.cos((double)angle2 * Math.PI / 180.0)).func_72432_b().func_186678_a(0.1);
                this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_VELOCITY.get())).setScale(0.5f).setMaxAge(20), center.field_72450_a, center.field_72448_b, center.field_72449_c, offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnParticles_crystals() {
        this.activeCrystals.forEach(e -> {
            Vector3d offset = Vector3d.func_237489_a_((Vector3i)this.func_174877_v()).func_178787_e(crystal_offsets[e.offsetIndex]);
            Vector3d crystalWidth = new Vector3d(0.1, 0.0, 0.1);
            int[] color = e.affinity.getShiftAffinity().getColor();
            for (int i = 0; i < 5; ++i) {
                this.field_145850_b.func_195594_a((IParticleData)new MAParticleType(((MAParticleType)ParticleInit.LIGHT_VELOCITY.get()).setColor(color[0], color[1], color[2])), offset.field_72450_a - crystalWidth.field_72450_a + Math.random() * crystalWidth.field_72450_a * 2.0, offset.field_72448_b + 0.55, offset.field_72449_c - crystalWidth.field_72449_c + Math.random() * crystalWidth.field_72449_c * 2.0, 0.0, 0.01, 0.0);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnParticles_items() {
        if (this.stage < Stage.CONSUMING_REAGENTS.ordinal()) {
            return;
        }
        Vector3d center = Vector3d.func_237489_a_((Vector3i)this.func_174877_v()).func_72441_c(0.0, 1.0, 0.0);
        int burstIndex = this.collectedItems.size() - this.stageTicks / 20;
        for (int i = 0; i < this.collectedItems.size(); ++i) {
            CollectedItem ci = this.collectedItems.get(i);
            Vector3d pedestalParticleCenter = new Vector3d((double)ci.tilePos.func_177958_n() + 0.5, (double)ci.tilePos.func_177956_o() + 1.5, (double)ci.tilePos.func_177952_p() + 0.5);
            if (this.stage == Stage.CONSUMING_REAGENTS.ordinal() && this.stageTicks > 0 && this.stageTicks % 20 == 0 && i == burstIndex) {
                for (int n = 0; n < 20; ++n) {
                    this.field_145850_b.func_195594_a((IParticleData)this.createRandomParticle(ci.stack).setMaxAge(5).setMover(new ParticleVelocityMover(Math.random() * 0.2 - 0.1, Math.random() * 0.2 - 0.1, Math.random() * 0.2 - 0.1, true)), pedestalParticleCenter.field_72450_a, pedestalParticleCenter.field_72448_b, pedestalParticleCenter.field_72449_c, 0.0, 0.0, 0.0);
                }
            }
            if (this.stage == Stage.CONSUMING_REAGENTS.ordinal() && i >= burstIndex || i <= burstIndex && this.stage == Stage.CRAFTING.ordinal()) {
                this.field_145850_b.func_195594_a((IParticleData)this.createRandomParticle(ci.stack).setMover(new ParticleSphereOrbitMover(pedestalParticleCenter.field_72450_a, pedestalParticleCenter.field_72448_b, pedestalParticleCenter.field_72449_c, 0.01f, Math.random() * 360.0, 0.5)), pedestalParticleCenter.field_72450_a, pedestalParticleCenter.field_72448_b, pedestalParticleCenter.field_72449_c, 0.0, 0.0, 0.0);
            }
            if (this.stage != Stage.CRAFTING.ordinal() || i != burstIndex) continue;
            this.field_145850_b.func_195594_a((IParticleData)this.createRandomParticle(ci.stack).setMover(new ParticleLerpMover(pedestalParticleCenter.field_72450_a, pedestalParticleCenter.field_72448_b, pedestalParticleCenter.field_72449_c, center.field_72450_a, center.field_72448_b, center.field_72449_c)), pedestalParticleCenter.field_72450_a, pedestalParticleCenter.field_72448_b, pedestalParticleCenter.field_72449_c, 0.0, 0.0, 0.0);
        }
        if (this.stage >= Stage.CRAFTING.ordinal()) {
            float radius = 0.75f;
            float scale = 0.1f;
            if (this.getStage() == Stage.COMPLETING) {
                if (this.stageTicks > 40) {
                    float pct = MathUtils.clamp01((float)(this.stageTicks - 40) / 40.0f);
                    radius -= 0.74f * pct;
                    scale = (float)((double)scale - 0.09 * (double)pct);
                } else if (this.stageTicks > 80) {
                    return;
                }
            }
            for (int i = 0; i < this.collectedItems.size(); ++i) {
                if (this.getStage() == Stage.CRAFTING && i <= burstIndex) continue;
                CollectedItem ci = this.collectedItems.get(i);
                this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ITEM.get())).setStack(ci.stack).setScale(scale).setMover(new ParticleSphereOrbitMover(center.field_72450_a, center.field_72448_b, center.field_72449_c, 0.01f, Math.random() * 360.0, radius)), center.field_72450_a, center.field_72448_b, center.field_72449_c, 0.0, 0.0, 0.0);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnParticles_lights() {
        for (int i = 0; i < this.collectedItems.size(); ++i) {
            CollectedItem item = this.collectedItems.get(i);
            if (item.stack.func_190926_b()) continue;
            Vector3d offset = Vector3d.func_237489_a_((Vector3i)item.tilePos);
            Vector3d crystalWidth = new Vector3d(0.25, 0.0, 0.25);
            for (int n = 0; n < 10; ++n) {
                this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.LIGHT_VELOCITY.get())), offset.field_72450_a - crystalWidth.field_72450_a + Math.random() * crystalWidth.field_72450_a * 2.0, offset.field_72448_b + 0.55, offset.field_72449_c - crystalWidth.field_72449_c + Math.random() * crystalWidth.field_72449_c * 2.0, 0.0, 0.01, 0.0);
            }
        }
        if (this.getStage() == Stage.COMPLETING && this.stageTicks == 129) {
            int i;
            Random rnd = new Random();
            Vector3d basePoint = Vector3d.func_237492_c_((Vector3i)this.func_174877_v());
            Vector3d srcPoint = basePoint.func_72441_c(0.5, 1.5, 0.5);
            for (i = 0; i < 150; ++i) {
                this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_GRAVITY.get())), srcPoint.func_82615_a(), srcPoint.func_82617_b(), srcPoint.func_82616_c(), -0.5 + Math.random(), 0.01, -0.5 + Math.random());
            }
            for (i = 0; i < 50; ++i) {
                Vector3d lightPoint = new Vector3d(srcPoint.func_82615_a() - (double)0.2f + (double)(rnd.nextFloat() * 0.4f), srcPoint.func_82617_b() - (double)0.3f, srcPoint.func_82616_c() - (double)0.2f + (double)(rnd.nextFloat() * 0.4f));
                this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.LIGHT_VELOCITY.get())), lightPoint.func_82615_a(), lightPoint.func_82617_b(), lightPoint.func_82616_c(), 0.0, 0.01, 0.0);
            }
            int angleStep = 10;
            for (int i2 = 0; i2 <= 360; i2 += angleStep) {
                int angle = (i2 + this.stageTicks * 2) % 360;
                Vector3d offset = new Vector3d(Math.sin((double)angle * Math.PI / 180.0), 0.0, Math.cos((double)angle * Math.PI / 180.0)).func_72432_b().func_186678_a(0.3);
                this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_VELOCITY.get())).setScale(0.5f).setMaxAge(20), basePoint.field_72450_a, basePoint.field_72448_b, basePoint.field_72449_c, offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private MAParticleType createRandomParticle(ItemStack stack) {
        if (Math.random() < 0.5 && this.getCachedRecipe() != null) {
            ArrayList<Affinity> affs = new ArrayList<Affinity>();
            affs.addAll(this.getCachedRecipe().getPowerRequirements().keySet());
            if (affs.size() > 0) {
                Affinity rand = (Affinity)((Object)affs.get((int)(Math.random() * (double)affs.size())));
                switch (rand) {
                    case ARCANE: {
                        return new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ARCANE_MAGELIGHT.get()));
                    }
                    case EARTH: {
                        return new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DUST.get()));
                    }
                    case ENDER: {
                        return new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ENDER_VELOCITY.get()));
                    }
                    case FIRE: 
                    case HELLFIRE: {
                        return new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME.get()));
                    }
                    case WATER: 
                    case ICE: {
                        return new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.WATER.get())).setScale(0.03f);
                    }
                    case WIND: 
                    case LIGHTNING: {
                        return new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_VELOCITY.get()));
                    }
                }
            }
        }
        return new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ITEM.get())).setStack(stack).setScale(0.1f);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playSounds() {
        if (this.getStage() == Stage.FINDING_POWER && this.stageTicks == 1) {
            this.PlaySound(SFX.Spell.Cast.ENDER);
            this.PlayLoopingSound(SFX.Loops.ELDRIN_ALTAR);
        }
        int ticksPerBeam = 5;
        if (this.stage == Stage.CONSUMING_REAGENTS.ordinal() && this.stageTicks % ticksPerBeam == 0 && this.stageTicks < this.getActiveCrystals().size() * ticksPerBeam) {
            this.PlaySound(SFX.Spell.Cast.ARCANE);
        }
        int burstFreq = 20;
        if (this.stage == Stage.CONSUMING_REAGENTS.ordinal() && this.stageTicks > 0 && this.stageTicks % burstFreq == 0 && this.stageTicks <= burstFreq * this.getCollectedItems().size()) {
            this.PlaySound(SFX.Spell.Impact.Single.EARTH);
        }
        if (this.stage == Stage.CRAFTING.ordinal() && this.stageTicks > 0 && this.stageTicks % burstFreq == 0 && this.stageTicks < burstFreq * this.getCollectedItems().size()) {
            this.PlaySound(SFX.Event.Eldrin.DRAW_IN_ITEM);
        }
        if (this.getStage() == Stage.COMPLETING && this.stageTicks == 129) {
            this.PlaySound(SFX.Event.Eldrin.CRAFT_COMPLETE);
        }
    }

    private void PlaySound(SoundEvent soundID) {
        this.field_145850_b.func_184134_a((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), soundID, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void PlayLoopingSound(SoundEvent soundID) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new PredicateLoopingSound(soundID, "eldrin_altar", this::soundLoopPredicate).setVolume(0.2f));
    }

    private boolean soundLoopPredicate(String id) {
        return this.stage > 0;
    }

    public boolean startCrafting(PlayerEntity player) {
        if (!this.structureMatched) {
            return false;
        }
        if (!this.cacheRecipe(player, false)) {
            return false;
        }
        LazyOptional progression = player.getCapability(PlayerProgressionProvider.PROGRESSION);
        if (!progression.isPresent()) {
            return false;
        }
        if (this.__cachedRecipe == null || this.__cachedRecipe.getTier() > ((IPlayerProgression)progression.resolve().get()).getTier()) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("gui.mana-and-artifice.recipe.lowtier"), Util.field_240973_b_);
            return false;
        }
        this.activeCrystals.clear();
        this.collectedItems.clear();
        MutableObject playerNWStr = new MutableObject();
        MutableBoolean canStart = new MutableBoolean(true);
        this.field_145850_b.getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> playerNWStr.setValue(m.getWellspringRegistry().getNodeNetworkStrengthFor(player)));
        this.getCachedRecipe().getPowerRequirements().forEach((a, f) -> {
            if (((HashMap)playerNWStr.getValue()).getOrDefault(a, Float.valueOf(0.0f)).floatValue() < f.floatValue()) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("gui.mana-and-artifice.recipe.missing_wellspring", new Object[]{a.toString()}), Util.field_240973_b_);
                canStart.setFalse();
            }
        });
        if (canStart.booleanValue()) {
            this.__crafter = player;
            this.setStage(Stage.FINDING_POWER);
        }
        return canStart.booleanValue();
    }

    private boolean cacheRecipe(PlayerEntity crafter, boolean consume) {
        ItemStack stack;
        if (this.getDisplayedItem().func_190926_b() || crafter == null) {
            return false;
        }
        Optional<IMultiblockDefinition> def = this.getDefinition();
        if (!def.isPresent()) {
            return false;
        }
        List<BlockPos> offsets = def.get().getPositions(Arrays.asList(BlockInit.PEDESTAL.getId(), BlockInit.PEDESTAL_WITH_SIGN.getId()), null);
        if (offsets.size() != 8) {
            throw new RuntimeException("THIS IS NOT AN M&A ISSUE.  A packmaker has replaced the structure for the Runic Altar and didn't put exactly 8 pedestals.  The pedestals are required to match the recipe.  Go tell them to fix it.");
        }
        BlockPos origin = BlockPos.field_177992_a;
        if (this.matchOriginIsCenter()) {
            origin = origin.func_177973_b(new Vector3i(def.get().getSize().func_177958_n() / 2, 0, def.get().getSize().func_177952_p() / 2));
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        stacks.add(this.getDisplayedItem().func_77946_l());
        if (consume && !(stack = this.func_70298_a(0, 1)).func_190926_b()) {
            this.collectedItems.add(new CollectedItem(this.func_174877_v(), stack));
        }
        for (BlockPos pos : offsets) {
            ItemStack stack2;
            BlockPos adjustedpos = origin.func_177971_a((Vector3i)pos);
            if (adjustedpos.func_177958_n() == 0 && adjustedpos.func_177956_o() == 0 && adjustedpos.func_177952_p() == 0) continue;
            TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177971_a((Vector3i)adjustedpos));
            if (te == null || !(te instanceof PedestalTile)) {
                return false;
            }
            stacks.add(((PedestalTile)te).getDisplayedItem().func_77946_l());
            if (!consume || (stack2 = ((PedestalTile)te).func_70298_a(0, 1)).func_190926_b()) continue;
            this.collectedItems.add(new CollectedItem(te.func_174877_v(), stack2));
        }
        ItemAndPatternCraftingInventory craftinginventory = new ItemAndPatternCraftingInventory(9, new ArrayList<String>());
        for (int i = 0; i < 9; ++i) {
            craftinginventory.func_70299_a(i, (ItemStack)stacks.get(i));
        }
        this.__cachedRecipe = this.field_145850_b.func_199532_z().func_215371_a(RecipeInit.ELDRIN_ALTAR_TYPE, (IInventory)craftinginventory, this.field_145850_b).orElse(null);
        if (this.__cachedRecipe != null) {
            IPlayerProgression progression = (IPlayerProgression)crafter.getCapability(PlayerProgressionProvider.PROGRESSION).resolve().get();
            Faction playerfaction = progression.getAlliedFaction();
            int playerTier = progression.getTier();
            if (this.__cachedRecipe.getFactionRequirement() != Faction.NONE && this.__cachedRecipe.getFactionRequirement() != playerfaction) {
                this.__cachedRecipe = null;
                if (!crafter.field_70170_p.field_72995_K) {
                    crafter.func_145747_a((ITextComponent)new TranslationTextComponent("block.mana-and-artifice.eldrin_altar.wrongFaction"), Util.field_240973_b_);
                }
            }
            if (this.__cachedRecipe.getTier() > playerTier) {
                this.__cachedRecipe = null;
                if (!crafter.field_70170_p.field_72995_K) {
                    crafter.func_145747_a((ITextComponent)new TranslationTextComponent("block.mana-and-artifice.runic_anvil.low_tier"), Util.field_240973_b_);
                }
            }
        }
        return this.__cachedRecipe != null;
    }

    private void tickLogic_findPower() {
        if (this.stageTicks == 1) {
            this.__powerSuppliers.queueRecheck();
        } else if (!this.__powerSuppliers.isSearching()) {
            if (this.getCachedRecipe() == null) {
                this.setStage(Stage.IDLE);
                return;
            }
            HashMap requiredpower = new HashMap();
            this.getCachedRecipe().getPowerRequirements().forEach((k, v) -> requiredpower.put(k, v));
            this.__powerSuppliers.getCachedPositions().forEach(bp -> {
                TileEntity te = this.field_145850_b.func_175625_s(bp);
                if (te != null && te instanceof IPowerSupplierTile) {
                    requiredpower.remove((Object)((IPowerSupplierTile)te).getAffinity());
                    this.activeCrystals.add(new ActiveCrystal(((IPowerSupplierTile)te).getAffinity(), this.getClosestOffset((BlockPos)bp), (BlockPos)bp));
                }
            });
            if (requiredpower.size() == 0) {
                this.setStage(Stage.CONSUMING_REAGENTS);
            } else {
                if (this.getCrafter() != null) {
                    this.getCrafter().func_145747_a((ITextComponent)new TranslationTextComponent("gui.mana-and-artifice.recipe.missing_conduit"), Util.field_240973_b_);
                }
                this.setStage(Stage.IDLE);
            }
        }
    }

    private int getClosestOffset(BlockPos pos) {
        int output = -1;
        double dist = Double.MAX_VALUE;
        Vector3d center = Vector3d.func_237489_a_((Vector3i)this.func_174877_v());
        Vector3d target = Vector3d.func_237489_a_((Vector3i)pos);
        for (int i = 0; i < crystal_offsets.length; ++i) {
            double loopDist = center.func_178787_e(crystal_offsets[i]).func_72436_e(target);
            if (!(loopDist < dist)) continue;
            dist = loopDist;
            output = i;
        }
        return output;
    }

    private void tickLogic_consumeReagents() {
        if (this.stageTicks == 1) {
            EldrinAltarRecipe prev = this.getCachedRecipe();
            if (!this.cacheRecipe(this.getCrafter(), true) || prev != this.getCachedRecipe()) {
                this.setStage(Stage.IDLE);
                return;
            }
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
        }
        if (this.stageTicks >= 30 * this.getCachedRecipe().getRequiredItems().length) {
            this.setStage(Stage.REQUESTING_MANAWEAVES);
        }
    }

    private void tickLogic_requestManaweaves() {
        this.setStage(Stage.CRAFTING);
    }

    private void tickLogic_craft() {
        if (this.stageTicks >= 30 * this.getCachedRecipe().getRequiredItems().length) {
            this.setStage(Stage.COMPLETING);
        }
    }

    private void tickLogic_complete() {
        if (this.stageTicks >= 130) {
            Vector3d center = Vector3d.func_237489_a_((Vector3i)this.func_174877_v());
            EntityPresentItem epi = new EntityPresentItem(this.field_145850_b, center.field_72450_a, center.field_72448_b + 0.5, center.field_72449_c, this.getCachedRecipe().func_77571_b());
            this.field_145850_b.func_217376_c((Entity)epi);
            this.activeCrystals.clear();
            this.collectedItems.clear();
            this.setStage(Stage.IDLE);
        }
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        super.func_70299_a(index, stack);
        this.updateBlockState();
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        ItemStack out = super.func_70298_a(index, count);
        this.updateBlockState();
        return out;
    }

    private void updateBlockState() {
        this.updateBlockState("invChange", 131);
    }

    private void updateBlockState(String id, Integer data) {
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), data.intValue());
    }

    @Override
    public int func_70302_i_() {
        return 1;
    }

    public int func_70297_j_() {
        return 1;
    }

    public ItemStack getDisplayedItem() {
        return this.func_70301_a(0);
    }

    @Override
    public int[] func_180463_a(Direction side) {
        return new int[]{0};
    }

    @Override
    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        return this.func_70301_a(0).func_190926_b();
    }

    @Override
    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return !this.func_70301_a(0).func_190926_b();
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT base = super.func_189517_E_();
        CompoundNBT sub = this.writeAdditonal(new CompoundNBT());
        base.func_218657_a("invSync", (INBT)sub);
        return base;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        CompoundNBT sub = tag.func_74775_l("invSync");
        this.readAdditional(sub);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT data = new CompoundNBT();
        this.writeAdditonal(data);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, data);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT data = pkt.func_148857_g();
        this.readAdditional(data);
    }

    private CompoundNBT writeAdditonal(CompoundNBT compound) {
        ItemStackHelper.func_191282_a((CompoundNBT)compound, (NonNullList)this.inventoryItems);
        this.resolvePendingPatterns();
        CompoundNBT patterns = new CompoundNBT();
        int count = 0;
        for (ManaweavingPattern pattern : this.addedPatterns) {
            patterns.func_74778_a("pattern_" + count++, pattern.func_199560_c().toString());
        }
        compound.func_74768_a("patterns_count", this.addedPatterns.size());
        compound.func_218657_a("patterns", (INBT)patterns);
        compound.func_74768_a("stage", this.stage);
        compound.func_74768_a("stageTicks", this.stageTicks);
        ListNBT activeCrystals = new ListNBT();
        this.activeCrystals.forEach(a -> activeCrystals.add((Object)a.toNBT()));
        compound.func_218657_a("activeCrystals", (INBT)activeCrystals);
        ListNBT collectedItems = new ListNBT();
        this.collectedItems.forEach(i -> collectedItems.add((Object)i.toNBT()));
        compound.func_218657_a("collectedItems", (INBT)collectedItems);
        if (this.__crafterID != null) {
            compound.func_74778_a("crafter_uuid", this.__crafterID.toString());
        }
        if (this.__cachedRecipe != null) {
            compound.func_74778_a("cachedRecipeId", this.__cachedRecipe.func_199560_c().toString());
        }
        return compound;
    }

    private void readAdditional(CompoundNBT compound) {
        this.func_174888_l();
        this.addedPatterns.clear();
        this.pendingPatterns.clear();
        ItemStackHelper.func_191283_b((CompoundNBT)compound, (NonNullList)this.inventoryItems);
        if (compound.func_74764_b("patterns") && compound.func_74764_b("patterns_count")) {
            int count = compound.func_74762_e("patterns_count");
            CompoundNBT patterns = compound.func_74775_l("patterns");
            for (int i = 0; i < count; ++i) {
                String identifier = "pattern_" + i;
                if (!patterns.func_74764_b(identifier)) continue;
                this.pendingPatterns.add(patterns.func_74779_i(identifier));
            }
        }
        this.stage = compound.func_74762_e("stage");
        this.stageTicks = compound.func_74762_e("stageTicks");
        if (compound.func_74764_b("cachedRecipeId")) {
            this.__cachedRecipeId = new ResourceLocation(compound.func_74779_i("cachedRecipeId"));
        }
        ListNBT list = compound.func_150295_c("activeCrystals", 10);
        this.activeCrystals.clear();
        list.forEach(inbt -> {
            CompoundNBT activeCrystal = (CompoundNBT)inbt;
            this.activeCrystals.add(ActiveCrystal.fromNBT(activeCrystal));
        });
        list = compound.func_150295_c("collectedItems", 10);
        this.collectedItems.clear();
        list.forEach(inbt -> {
            CompoundNBT collectedItem = (CompoundNBT)inbt;
            this.collectedItems.add(CollectedItem.fromNBT(collectedItem));
        });
        if (compound.func_74764_b("crafter_uuid")) {
            this.__crafterID = UUID.fromString(compound.func_74779_i("crafter_uuid"));
        }
    }

    public boolean MatchesReagent(ResourceLocation rLoc) {
        if (this.func_70301_a(0).func_190926_b()) {
            return false;
        }
        return MATags.isItemEqual(this.func_70301_a(0), rLoc);
    }

    public ArrayList<ActiveCrystal> getActiveCrystals() {
        return this.activeCrystals;
    }

    public ArrayList<CollectedItem> getCollectedItems() {
        return this.collectedItems;
    }

    public static class CollectedItem {
        public final BlockPos tilePos;
        public final ItemStack stack;

        public CollectedItem(BlockPos pos, ItemStack stack) {
            this.tilePos = pos;
            this.stack = stack;
        }

        public CompoundNBT toNBT() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74772_a("pos", this.tilePos.func_218275_a());
            this.stack.func_77955_b(nbt);
            return nbt;
        }

        public static CollectedItem fromNBT(CompoundNBT nbt) {
            return new CollectedItem(BlockPos.func_218283_e((long)nbt.func_74763_f("pos")), ItemStack.func_199557_a((CompoundNBT)nbt));
        }
    }

    public static class ActiveCrystal {
        public final Affinity affinity;
        public final int offsetIndex;
        public final BlockPos tilePos;

        public ActiveCrystal(Affinity affinity, int offsetIndex, BlockPos tilePos) {
            this.affinity = affinity;
            this.offsetIndex = offsetIndex;
            this.tilePos = tilePos;
        }

        public CompoundNBT toNBT() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74778_a("affinity", this.affinity.name());
            nbt.func_74768_a("offsetIndex", this.offsetIndex);
            nbt.func_74772_a("position", this.tilePos.func_218275_a());
            return nbt;
        }

        public static ActiveCrystal fromNBT(CompoundNBT nbt) {
            return new ActiveCrystal(Affinity.valueOf(nbt.func_74779_i("affinity")), nbt.func_74762_e("offsetIndex"), BlockPos.func_218283_e((long)nbt.func_74763_f("position")));
        }
    }

    public static enum Stage {
        IDLE,
        FINDING_POWER,
        CONSUMING_REAGENTS,
        REQUESTING_MANAWEAVES,
        CRAFTING,
        COMPLETING;

    }
}

