/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.tileentities;

import com.ma.ManaAndArtifice;
import com.ma.blocks.tileentities.init.TileEntityInit;
import com.ma.entities.constructs.ai.base.ConstructActions;
import com.ma.entities.constructs.ai.base.ConstructCommand;
import com.ma.entities.constructs.animated.EntityAnimatedConstruct;
import com.ma.gui.containers.block.ContainerLodestar;
import com.ma.network.ClientMessageDispatcher;
import com.ma.network.messages.to_server.LodestarGUIActionMessage;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.block.BlockState;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fml.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class LodestarTile
extends TileEntity
implements ITickableTileEntity,
Consumer<PacketBuffer>,
INamedContainerProvider,
IAnimatable {
    private ArrayList<ConfigurableConstructCommand> commandsList = new ArrayList();
    private boolean expanded;
    private int expansionCount;
    public static final int ROTATION_TIME = 40;
    public static final int EXPAND_TIME = 20;
    private AnimationFactory animFactory = new AnimationFactory((IAnimatable)this);

    public LodestarTile() {
        super((TileEntityType)TileEntityInit.LODESTAR.get());
    }

    public int getCommandCount() {
        return this.commandsList.size();
    }

    public ConstructCommand getCommand(int index) {
        return this.commandsList.get(index).getCommand();
    }

    public Inventory getCommandInventory(int index) {
        return this.commandsList.get(index).getConfigurationItems();
    }

    public void addCommand(ConstructActions type) {
        if (type.getAIClass() == null) {
            return;
        }
        try {
            ConstructCommand instance = type.getAIClass().getConstructor(EntityAnimatedConstruct.class).newInstance(new Object[]{null});
            this.commandsList.add(new ConfigurableConstructCommand(instance));
        }
        catch (Exception ex) {
            ManaAndArtifice.LOGGER.error("Failed to instantiate new construct command of type " + type.toString());
        }
        if (this.field_145850_b.field_72995_K) {
            ClientMessageDispatcher.sendLodestarGuiAction(this, -1, type, LodestarGUIActionMessage.Action.ADD);
        }
    }

    public void removeCommand(PlayerEntity player, ConstructActions type, int index) {
        if (index < this.commandsList.size()) {
            ConstructCommand cmd = this.commandsList.get(index).getCommand();
            if (type.getAIClass().isAssignableFrom(((Object)((Object)cmd)).getClass())) {
                if (!this.field_145850_b.field_72995_K) {
                    for (int i = 0; i < this.commandsList.get(index).getConfigurationItems().func_70302_i_(); ++i) {
                        ItemStack stack = this.commandsList.get(index).getConfigurationItems().func_70301_a(i);
                        if (stack.func_190926_b() || player.func_191521_c(stack)) continue;
                        player.func_71019_a(stack, false);
                    }
                } else {
                    ClientMessageDispatcher.sendLodestarGuiAction(this, index, type, LodestarGUIActionMessage.Action.REMOVE);
                }
                this.commandsList.remove(index);
            }
        }
    }

    public void openEditor(PlayerEntity player, ConstructActions type, int index) {
        if (index >= this.commandsList.size()) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            INamedContainerProvider provider;
            ConstructCommand cmd = this.commandsList.get(index).getCommand();
            if (type.getAIClass().isAssignableFrom(((Object)((Object)cmd)).getClass()) && (provider = type.instantiateContainer(this.commandsList.get(index).configurationItems, this)) != null) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)provider);
            }
        } else {
            ClientMessageDispatcher.sendLodestarGuiAction(this, index, type, LodestarGUIActionMessage.Action.EDIT);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        ListNBT list = new ListNBT();
        for (ConfigurableConstructCommand ccc : this.commandsList) {
            CompoundNBT subCommand = new CompoundNBT();
            subCommand.func_218657_a("inventory", (INBT)ccc.configurationItems.func_70487_g());
            subCommand.func_218657_a("commandData", (INBT)ccc.cmd.writeNBT());
            list.add((Object)subCommand);
        }
        compound.func_218657_a("commands", (INBT)list);
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        this.commandsList.clear();
        if (nbt.func_74764_b("commands")) {
            ListNBT list = nbt.func_150295_c("commands", 10);
            list.stream().map(n -> (CompoundNBT)n).forEach(c -> {
                try {
                    CompoundNBT commandData = (CompoundNBT)c.func_74781_a("commandData");
                    ConstructActions cmd = ConstructCommand.getTypeFromNBT(commandData);
                    ConstructCommand instance = cmd.getAIClass().getConstructor(EntityAnimatedConstruct.class).newInstance(new Object[]{null});
                    instance.readNBT(commandData);
                    ConfigurableConstructCommand ccc = new ConfigurableConstructCommand(instance);
                    ccc.getConfigurationItems().func_70486_a((ListNBT)c.func_74781_a("inventory"));
                    this.commandsList.add(ccc);
                }
                catch (Exception ex) {
                    ManaAndArtifice.LOGGER.error("Failed to parse lodestar saved command data, skipping.");
                }
            });
        }
        super.func_230337_a_(state, nbt);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189515_b(nbt));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        return this.func_189515_b(nbt);
    }

    @Override
    public void accept(PacketBuffer t) {
        t.func_179255_a(this.func_174877_v());
        CompoundNBT compound = this.func_189515_b(new CompoundNBT());
        t.func_150786_a(compound);
    }

    public LodestarTile readFrom(PacketBuffer data) {
        CompoundNBT compound = data.func_150793_b();
        this.func_230337_a_(this.func_195044_w(), compound);
        return this;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public int expandCount() {
        return this.expansionCount;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        PlayerEntity player = ManaAndArtifice.instance.proxy.getClientPlayer();
        double reachDist = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e();
        if (this.field_145850_b.func_82737_E() % 40L == 0L) {
            if (this.func_174877_v().func_218141_a((Vector3i)player.func_233580_cy_(), reachDist)) {
                this.expanded = true;
            } else {
                this.expanded = false;
                if (this.expansionCount > 20) {
                    this.expansionCount %= 20;
                    this.expansionCount += 20;
                }
            }
        }
    }

    public void handleMessage(PlayerEntity player, LodestarGUIActionMessage message) {
        switch (message.getActionType()) {
            case ADD: {
                this.addCommand(message.getCommandType());
                break;
            }
            case EDIT: {
                this.openEditor(player, message.getCommandType(), message.getIndex());
                break;
            }
            case REMOVE: {
                this.removeCommand(player, message.getCommandType(), message.getIndex());
            }
        }
    }

    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerLodestar(id, playerInventory, this);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent("");
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 20.0f, this::predicate);
        data.addAnimationController(controller);
    }

    public AnimationFactory getFactory() {
        return this.animFactory;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        event.getController().transitionLengthTicks = 20.0;
        if (this.field_145850_b.func_175640_z(this.func_174877_v())) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.lodestar_armature.inactive", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.lodestar_armature.active", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    class ConfigurableConstructCommand {
        private ConstructCommand cmd;
        private Inventory configurationItems;

        public ConfigurableConstructCommand(ConstructCommand cmd) {
            this.cmd = cmd;
            this.configurationItems = cmd.createConfigurationInventory();
        }

        public ConstructCommand getCommand() {
            return this.cmd;
        }

        public Inventory getConfigurationItems() {
            return this.configurationItems;
        }
    }
}

