/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.tileentities;

import com.ma.api.blocks.tile.TileEntityWithInventory;
import com.ma.blocks.tileentities.init.TileEntityInit;
import com.ma.gui.containers.block.ContainerMagiciansWorkbench;
import java.util.LinkedList;
import java.util.function.Consumer;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class MagiciansWorkbenchTile
extends TileEntityWithInventory
implements INamedContainerProvider,
Consumer<PacketBuffer> {
    public static final int MAX_RECIPES = 8;
    public CraftResultInventory firstResultInv = new CraftResultInventory();
    public CraftResultInventory secondResultInv = new CraftResultInventory();
    private final LinkedList<RememberedRecipe> rememberedRecipes = new LinkedList();

    public MagiciansWorkbenchTile(TileEntityType<?> type) {
        super(type, 38);
    }

    public MagiciansWorkbenchTile() {
        this((TileEntityType)TileEntityInit.MAGICIANS_WORKBENCH.get());
    }

    public MagiciansWorkbenchTile readFrom(PacketBuffer data) {
        return this;
    }

    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
        return new ContainerMagiciansWorkbench(id, playerInventory, this);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("mana-and-artifice:container.magicians_workbench");
    }

    @Override
    public void accept(PacketBuffer data) {
        data.func_179255_a(this.func_174877_v());
    }

    public void rememberRecipe(ItemStack output, ItemStack[] recipeItems) {
        if (output.func_190926_b()) {
            return;
        }
        for (RememberedRecipe recipe : this.rememberedRecipes) {
            if (!recipe.output.func_77969_a(output)) continue;
            return;
        }
        if (!this.popRecipe()) {
            return;
        }
        this.rememberedRecipes.add(new RememberedRecipe(output, recipeItems));
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
    }

    private boolean popRecipe() {
        if (this.rememberedRecipes.size() < 8) {
            return true;
        }
        for (int index = 0; index < this.rememberedRecipes.size(); ++index) {
            if (this.rememberedRecipes.get(index).isLocked) continue;
            this.rememberedRecipes.remove(index);
            return true;
        }
        return false;
    }

    public LinkedList<RememberedRecipe> getRememberedRecipeItems() {
        return this.rememberedRecipes;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        ListNBT recall = new ListNBT();
        for (RememberedRecipe recipe : this.rememberedRecipes) {
            try {
                CompoundNBT output = new CompoundNBT();
                recipe.output.func_77955_b(output);
                ListNBT components = new ListNBT();
                for (int i = 0; i < recipe.components.length; ++i) {
                    CompoundNBT component = new CompoundNBT();
                    component.func_74757_a("componentExisted", recipe.components[i] != null);
                    if (recipe.components[i] != null) {
                        recipe.components[i].func_77955_b(component);
                    }
                    components.add((Object)component);
                }
                output.func_218657_a("components", (INBT)components);
                output.func_74757_a("isLocked", recipe.isLocked);
                recall.add((Object)output);
            }
            catch (Throwable throwable) {}
        }
        compound.func_218657_a("rememberedRecipes", (INBT)recall);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        ListNBT recall = compound.func_150295_c("rememberedRecipes", 10);
        this.rememberedRecipes.clear();
        if (recall != null) {
            for (int i = 0; i < recall.size(); ++i) {
                CompoundNBT rememberedRecipe = (CompoundNBT)recall.get(i);
                ItemStack output = ItemStack.func_199557_a((CompoundNBT)rememberedRecipe);
                ListNBT componentNBT = rememberedRecipe.func_150295_c("components", 10);
                ItemStack[] components = new ItemStack[componentNBT.size()];
                for (int n = 0; n < componentNBT.size(); ++n) {
                    ItemStack component;
                    CompoundNBT componentTAG = (CompoundNBT)componentNBT.get(n);
                    components[n] = componentTAG.func_74767_n("componentExisted") ? (component = ItemStack.func_199557_a((CompoundNBT)componentTAG)) : null;
                }
                if (output.func_190926_b()) continue;
                RememberedRecipe rec = new RememberedRecipe(output, components);
                rec.isLocked = rememberedRecipe.func_74767_n("isLocked");
                this.rememberedRecipes.add(rec);
            }
        }
        super.func_230337_a_(state, compound);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(super.func_189517_E_());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189515_b(new CompoundNBT()));
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        this.func_230337_a_(state, tag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public class RememberedRecipe {
        public final ItemStack output;
        public final ItemStack[] components;
        private boolean isLocked;

        public RememberedRecipe(ItemStack output, ItemStack[] components) {
            this.output = output.func_77946_l();
            this.components = new ItemStack[components.length];
            for (int i = 0; i < components.length; ++i) {
                this.components[i] = components[i].func_77946_l();
                this.components[i].func_190920_e(1);
            }
            this.isLocked = false;
        }

        public void lock() {
            this.isLocked = true;
        }

        public void unlock() {
            this.isLocked = false;
        }

        public boolean isLocked() {
            return this.isLocked;
        }
    }
}

