/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.tileentities;

import com.ma.api.blocks.IRequirePlayerReference;
import com.ma.api.blocks.tile.TileEntityWithInventory;
import com.ma.api.capabilities.Faction;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.blocks.tileentities.init.TileEntityInit;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.config.GeneralModConfig;
import com.ma.events.EventDispatcher;
import com.ma.network.ServerMessageDispatcher;
import com.ma.network.messages.to_client.SpawnParticleEffectMessage;
import com.ma.recipes.ItemAndPatternCraftingInventory;
import com.ma.recipes.RecipeInit;
import com.ma.recipes.manaweaving.ManaweavingPattern;
import com.ma.recipes.manaweaving.ManaweavingPatternHelper;
import com.ma.recipes.manaweaving.ManaweavingRecipe;
import com.ma.tools.InventoryUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class ManaweavingAltarTile
extends TileEntityWithInventory
implements ITickableTileEntity,
IRequirePlayerReference<ManaweavingAltarTile> {
    public static final int MAX_ITEMS = 9;
    private ArrayList<String> pendingPatterns;
    private ArrayList<ManaweavingPattern> addedPatterns;
    private boolean crafting = false;
    private int craftTicks = 0;
    private ManaweavingRecipe __cachedRecipe;
    private ItemStack __cachedRecipeOutput;
    private UUID __crafterID;
    private PlayerEntity __crafter;
    private boolean copyNBT = false;
    private int lastCraftPatternCount = 0;
    private int lastCraftTier = 0;
    private Faction lastCraftFaction = Faction.NONE;
    private NonNullList<ItemStack> lastCraftItems;
    private NonNullList<ItemStack> lastCraftItemsMerged;
    private ItemStack lastCraftOutput = ItemStack.field_190927_a;
    private LazyOptional<IItemHandlerModifiable> handler;

    public ManaweavingAltarTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn, 9);
        this.addedPatterns = new ArrayList();
        this.pendingPatterns = new ArrayList();
        this.lastCraftItems = NonNullList.func_191196_a();
        this.lastCraftItemsMerged = NonNullList.func_191196_a();
    }

    public ManaweavingAltarTile() {
        this((TileEntityType)TileEntityInit.MANAWEAVING_ALTAR.get());
    }

    public void pushPattern(ManaweavingPattern pattern, PlayerEntity player) {
        if (this.crafting) {
            return;
        }
        this.setPlayerReference(player);
        this.resolvePendingPatterns();
        if (this.addedPatterns.size() == 6) {
            return;
        }
        this.addedPatterns.add(pattern);
        if (this.MatchesRecipe(player)) {
            this.setCrafting(true);
        }
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        super.func_70299_a(index, stack);
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    @Override
    public ItemStack func_70304_b(int index) {
        if (this.isCrafting()) {
            return ItemStack.field_190927_a;
        }
        ItemStack output = super.func_70304_b(index);
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
        }
        return output;
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        if (this.isCrafting()) {
            return ItemStack.field_190927_a;
        }
        ItemStack output = super.func_70298_a(index, count);
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
        }
        return output;
    }

    public void popPattern(PlayerEntity player) {
        if (this.crafting) {
            return;
        }
        this.setPlayerReference(player);
        this.resolvePendingPatterns();
        if (this.addedPatterns.size() <= 0) {
            return;
        }
        this.addedPatterns.remove(this.addedPatterns.size() - 1);
        if (this.MatchesRecipe(player)) {
            this.setCrafting(true);
        }
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    public boolean pushItem(PlayerEntity player, ItemStack stack) {
        if (this.crafting) {
            return false;
        }
        this.setPlayerReference(player);
        if (stack.func_190916_E() != 1) {
            return false;
        }
        boolean success = false;
        for (int i = 0; i < 9; ++i) {
            if (!this.func_70301_a(i).func_190926_b()) continue;
            this.func_70299_a(i, stack);
            success = true;
            break;
        }
        if (success && this.MatchesRecipe(player)) {
            this.setCrafting(true);
        }
        return success;
    }

    public ItemStack popItem(PlayerEntity player) {
        if (this.crafting) {
            return ItemStack.field_190927_a;
        }
        this.setPlayerReference(player);
        ItemStack output = ItemStack.field_190927_a;
        for (int i = 8; i >= 0; --i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            output = this.func_70304_b(i);
            break;
        }
        if (this.MatchesRecipe(player)) {
            this.setCrafting(true);
        }
        return output;
    }

    public void clearPatterns() {
        this.addedPatterns.clear();
    }

    public Collection<ManaweavingPattern> getAddedPatterns() {
        this.resolvePendingPatterns();
        return this.addedPatterns;
    }

    @Override
    public int func_70302_i_() {
        return 9;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT base = super.func_189517_E_();
        CompoundNBT sub = this.writeAdditonal(new CompoundNBT());
        base.func_218657_a("invSync", (INBT)sub);
        return base;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        CompoundNBT sub = tag.func_74775_l("invSync");
        this.readAdditional(sub);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT data = new CompoundNBT();
        this.writeAdditonal(data);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, data);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT data = pkt.func_148857_g();
        this.readAdditional(data);
    }

    public int func_70297_j_() {
        return 1;
    }

    public ItemStack[] getDisplayedItems() {
        ItemStack[] stacks = new ItemStack[9];
        for (int i = 0; i < 9; ++i) {
            stacks[i] = this.func_70301_a(i);
        }
        return stacks;
    }

    private boolean MatchesRecipe(PlayerEntity player) {
        IPlayerProgression progression;
        int tier = 1;
        Faction faction = Faction.NONE;
        if (player != null && (progression = (IPlayerProgression)player.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null)) != null) {
            tier = progression.getTier();
            faction = progression.getAlliedFaction();
        }
        this.__cachedRecipe = null;
        this.__cachedRecipeOutput = null;
        ManaweavingRecipe recipe = this.field_145850_b.func_199532_z().func_215371_a(RecipeInit.MANAWEAVING_RECIPE_TYPE, (IInventory)this.createCraftingInventory(), this.field_145850_b).orElse(null);
        if (recipe != null && recipe.getTier() <= tier) {
            this.__cachedRecipe = recipe;
            this.__cachedRecipeOutput = recipe.func_77571_b().func_77946_l();
            this.copyNBT = recipe.getCopyNBT();
        }
        if (this.__cachedRecipeOutput != null && !this.__cachedRecipeOutput.func_190926_b()) {
            if (this.__cachedRecipe.getFactionRequirement() != Faction.NONE && this.__cachedRecipe.getFactionRequirement() != faction) {
                this.__cachedRecipeOutput = ItemStack.field_190927_a;
                this.__cachedRecipe = null;
                if (player != null) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("gui.mana-and-artifice.recipe.wrongfaction"), Util.field_240973_b_);
                }
                return false;
            }
            this.lastCraftTier = recipe.getTier();
            this.lastCraftFaction = recipe.getFactionRequirement();
            return true;
        }
        return false;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.writeAdditonal(compound);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.readAdditional(compound);
        super.func_230337_a_(state, compound);
    }

    private CompoundNBT writeAdditonal(CompoundNBT compound) {
        ItemStackHelper.func_191282_a((CompoundNBT)compound, (NonNullList)this.inventoryItems);
        this.resolvePendingPatterns();
        CompoundNBT patterns = new CompoundNBT();
        int count = 0;
        for (ManaweavingPattern pattern : this.addedPatterns) {
            patterns.func_74778_a("pattern_" + count++, pattern.func_199560_c().toString());
        }
        compound.func_74768_a("patterns_count", this.addedPatterns.size());
        compound.func_218657_a("patterns", (INBT)patterns);
        compound.func_74757_a("crafting", this.crafting);
        compound.func_74757_a("copyNBT", this.copyNBT);
        compound.func_74768_a("craftTicks", this.craftTicks);
        CompoundNBT lastCraft = new CompoundNBT();
        lastCraft.func_218657_a("lastCraftReagents", (INBT)ItemStackHelper.func_191282_a((CompoundNBT)new CompoundNBT(), this.lastCraftItems));
        lastCraft.func_74768_a("patterns_count", this.lastCraftPatternCount);
        lastCraft.func_74768_a("tier", this.lastCraftTier);
        lastCraft.func_74778_a("faction", this.lastCraftFaction.name());
        lastCraft.func_218657_a("lastCraftOutput", (INBT)this.lastCraftOutput.func_77955_b(new CompoundNBT()));
        compound.func_218657_a("lastCraft", (INBT)lastCraft);
        if (this.__crafterID != null) {
            compound.func_74778_a("crafter_uuid", this.__crafterID.toString());
        }
        return compound;
    }

    private void readAdditional(CompoundNBT compound) {
        this.func_174888_l();
        this.addedPatterns.clear();
        this.pendingPatterns.clear();
        this.lastCraftItems.clear();
        for (int i = 0; i < 9; ++i) {
            this.lastCraftItems.add((Object)ItemStack.field_190927_a);
        }
        ItemStackHelper.func_191283_b((CompoundNBT)compound, (NonNullList)this.inventoryItems);
        if (compound.func_74764_b("patterns") && compound.func_74764_b("patterns_count")) {
            int count = compound.func_74762_e("patterns_count");
            CompoundNBT patterns = compound.func_74775_l("patterns");
            for (int i = 0; i < count; ++i) {
                String identifier = "pattern_" + i;
                if (!patterns.func_74764_b(identifier)) continue;
                this.pendingPatterns.add(patterns.func_74779_i(identifier));
            }
        }
        this.crafting = compound.func_74767_n("crafting");
        this.craftTicks = compound.func_74762_e("craftTicks");
        this.copyNBT = compound.func_74767_n("copyNBT");
        if (compound.func_74764_b("crafter_uuid")) {
            this.__crafterID = UUID.fromString(compound.func_74779_i("crafter_uuid"));
        }
        if (compound.func_74764_b("lastCraft")) {
            CompoundNBT lastCraft = compound.func_74775_l("lastCraft");
            this.lastCraftOutput = ItemStack.func_199557_a((CompoundNBT)lastCraft.func_74775_l("lastCraftOutput"));
            ItemStackHelper.func_191283_b((CompoundNBT)lastCraft.func_74775_l("lastCraftReagents"), this.lastCraftItems);
            this.lastCraftPatternCount = lastCraft.func_74762_e("patterns_count");
            this.lastCraftTier = lastCraft.func_74762_e("tier");
            if (lastCraft.func_74764_b("faction")) {
                this.lastCraftFaction = Faction.valueOf(lastCraft.func_74779_i("faction"));
            }
            for (ItemStack stack : this.lastCraftItems) {
                Optional<ItemStack> existing = this.lastCraftItemsMerged.stream().filter(is -> ItemStack.func_185132_d((ItemStack)is, (ItemStack)stack)).findFirst();
                if (existing.isPresent()) {
                    existing.get().func_190920_e(existing.get().func_190916_E() + stack.func_190916_E());
                    continue;
                }
                this.lastCraftItemsMerged.add((Object)stack.func_77946_l());
            }
        }
    }

    public void spawnCraftingParticles() {
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        Random rnd = new Random();
        BlockPos pos = this.func_174877_v();
        Vector3f srcPoint = new Vector3f((float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.9f, (float)pos.func_177952_p() + 0.5f);
        for (int i = 0; i < 10; ++i) {
            Vector3f lightPoint = new Vector3f(srcPoint.func_195899_a() - 0.2f + rnd.nextFloat() * 0.4f, srcPoint.func_195900_b(), srcPoint.func_195902_c() - 0.2f + rnd.nextFloat() * 0.4f);
            this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.LIGHT_VELOCITY.get())), (double)lightPoint.func_195899_a(), (double)lightPoint.func_195900_b(), (double)lightPoint.func_195902_c(), 0.0, 0.01, 0.0);
        }
        float SPEED = 0.1f;
        float RADIUS = 0.25f;
        int i = 0;
        while ((double)i < (double)this.craftTicks * 1.5) {
            this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_SPHERE_ORBIT.get())), (double)srcPoint.func_195899_a(), (double)(srcPoint.func_195900_b() + 0.4f), (double)srcPoint.func_195902_c(), (double)SPEED, (double)rnd.nextInt(360), (double)RADIUS);
            ++i;
        }
        if (this.getCraftTicks() > this.getMaxCraftTicks() - 20) {
            RADIUS = 0.6f - rnd.nextFloat() * 0.25f;
            for (i = 0; i < 100; ++i) {
                this.field_145850_b.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_SPHERE_ORBIT.get())), (double)srcPoint.func_195899_a(), (double)(srcPoint.func_195900_b() + 0.2f), (double)srcPoint.func_195902_c(), (double)SPEED + rnd.nextGaussian() * (double)0.1f, (double)(-30 + rnd.nextInt(30)), (double)RADIUS);
            }
        }
    }

    public static void spawnCraftCompleteParticles(World level, Vector3f srcPoint) {
        int i;
        Random rnd = new Random();
        for (i = 0; i < 150; ++i) {
            level.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_GRAVITY.get())), (double)srcPoint.func_195899_a(), (double)srcPoint.func_195900_b(), (double)srcPoint.func_195902_c(), -0.5 + Math.random(), 0.01, -0.5 + Math.random());
        }
        for (i = 0; i < 50; ++i) {
            Vector3f lightPoint = new Vector3f(srcPoint.func_195899_a() - 0.2f + rnd.nextFloat() * 0.4f, srcPoint.func_195900_b() - 0.3f, srcPoint.func_195902_c() - 0.2f + rnd.nextFloat() * 0.4f);
            level.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.LIGHT_VELOCITY.get())), (double)lightPoint.func_195899_a(), (double)lightPoint.func_195900_b(), (double)lightPoint.func_195902_c(), 0.0, 0.01, 0.0);
        }
    }

    private void resolvePendingPatterns() {
        if (this.field_145850_b != null && this.pendingPatterns.size() > 0) {
            for (String s : this.pendingPatterns) {
                ManaweavingPattern p = ManaweavingPatternHelper.GetManaweavingRecipe(this.field_145850_b, new ResourceLocation(s));
                if (p == null) continue;
                this.addedPatterns.add(p);
            }
            this.pendingPatterns.clear();
        }
    }

    private void setCrafting(boolean crafting) {
        this.crafting = crafting;
        if (!this.field_145850_b.field_72995_K && this.crafting) {
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), SFX.Event.Block.MANAWEAVE_ALTAR_CRAFT, SoundCategory.BLOCKS, 1.0f, (float)((double)0.95f + Math.random() * (double)0.05f));
        }
    }

    public boolean isCrafting() {
        return this.crafting;
    }

    public int getCraftTicks() {
        return this.craftTicks;
    }

    public int getMaxCraftTicks() {
        return 85;
    }

    public void func_73660_a() {
        if (!this.crafting) {
            return;
        }
        this.spawnCraftingParticles();
        ++this.craftTicks;
        if (this.craftTicks >= this.getMaxCraftTicks()) {
            this.setCrafting(false);
            this.craftTicks = 0;
            if (!this.field_145850_b.field_72995_K) {
                if (!EventDispatcher.DispatchManaweaveCrafting(this.__cachedRecipe, this.__cachedRecipeOutput, this.getCrafter())) {
                    this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
                    return;
                }
                if (this.copyNBT) {
                    CompoundNBT nbt = this.__cachedRecipeOutput.func_196082_o();
                    for (ItemStack stack : this.inventoryItems) {
                        if (!stack.func_77942_o()) continue;
                        nbt.func_197643_a(stack.func_77978_p());
                    }
                }
                this.copyCraftInputToLastCraft();
                ServerMessageDispatcher.sendParticleEffect((RegistryKey<World>)this.field_145850_b.func_234923_W_(), 32.0f, (float)this.func_174877_v().func_177958_n() + 0.5f, (float)this.func_174877_v().func_177956_o() + 1.3f, (float)this.func_174877_v().func_177952_p() + 0.5f, SpawnParticleEffectMessage.ParticleTypes.MANAWEAVE_CRAFT_COMPLETE);
            }
            this.pendingPatterns.clear();
            this.addedPatterns.clear();
            this.func_174888_l();
            this.setOutputItem(this.__cachedRecipeOutput);
        }
    }

    private void setOutputItem(ItemStack stack) {
        if (!this.field_145850_b.field_72995_K) {
            this.ignoreQtyLimit = true;
            if (stack != null) {
                this.func_70299_a(0, stack);
            }
            this.ignoreQtyLimit = false;
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    @Override
    public void setPlayerReference(PlayerEntity player) {
        this.__crafter = player;
        this.__crafterID = player.func_110124_au();
    }

    private boolean checkReCraftReagents(PlayerEntity player) {
        if (player.func_184812_l_()) {
            return true;
        }
        MutableBoolean progressionMet = new MutableBoolean(false);
        player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
            if (p.getTier() < this.lastCraftTier) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("gui.mana-and-artifice.recipe.lowtier"), Util.field_240973_b_);
            } else if (this.lastCraftFaction != Faction.NONE && p.getAlliedFaction() != this.lastCraftFaction) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("gui.mana-and-artifice.recipe.wrongfaction"), Util.field_240973_b_);
            } else {
                progressionMet.setTrue();
            }
        });
        if (!progressionMet.booleanValue()) {
            return false;
        }
        float mana = this.getReCraftManaCost();
        MutableBoolean enoughMana = new MutableBoolean(true);
        player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> enoughMana.setValue(m.getCastingResource().getAmount() >= mana));
        if (!enoughMana.getValue().booleanValue()) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("gui.mana-and-artifice.recipe.missing_mana"), Util.field_240973_b_);
            return false;
        }
        MutableBoolean reagentsPresent = new MutableBoolean(true);
        this.lastCraftItemsMerged.forEach(stack -> {
            if (!stack.func_190926_b() && !InventoryUtilities.hasStackInInventory(stack, true, true, (IItemHandlerModifiable)new InvWrapper((IInventory)player.field_71071_by))) {
                reagentsPresent.setFalse();
            }
        });
        if (!reagentsPresent.getValue().booleanValue()) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("gui.mana-and-artifice.recipe.missing_items"), Util.field_240973_b_);
            return false;
        }
        return true;
    }

    private void consumeReCraftReagents(PlayerEntity player) {
        if (player.func_184812_l_()) {
            return;
        }
        float mana = this.getReCraftManaCost();
        player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> m.getCastingResource().consume(mana));
        this.lastCraftItemsMerged.forEach(stack -> InventoryUtilities.removeItemFromInventory(stack, true, true, (IItemHandlerModifiable)new InvWrapper((IInventory)player.field_71071_by)));
    }

    private void copyCraftInputToLastCraft() {
        this.lastCraftItems.clear();
        this.lastCraftItemsMerged.clear();
        for (ItemStack stack : this.inventoryItems) {
            this.lastCraftItems.add((Object)stack.func_77946_l());
            Optional<ItemStack> existing = this.lastCraftItemsMerged.stream().filter(is -> ItemStack.func_185132_d((ItemStack)is, (ItemStack)stack)).findFirst();
            if (existing.isPresent()) {
                existing.get().func_190920_e(existing.get().func_190916_E() + stack.func_190916_E());
                continue;
            }
            this.lastCraftItemsMerged.add((Object)stack.func_77946_l());
        }
        this.lastCraftPatternCount = this.addedPatterns.size();
        this.lastCraftOutput = this.__cachedRecipeOutput.func_77946_l();
    }

    public boolean reCraft(PlayerEntity player) {
        if (this.addedPatterns.size() != 0 || !this.func_191420_l() || this.field_145850_b.field_72995_K) {
            return false;
        }
        if (this.checkReCraftReagents(player)) {
            ServerMessageDispatcher.sendParticleEffect((RegistryKey<World>)this.field_145850_b.func_234923_W_(), 32.0f, (float)this.func_174877_v().func_177958_n() + 0.5f, (float)this.func_174877_v().func_177956_o() + 1.1f, (float)this.func_174877_v().func_177952_p() + 0.5f, SpawnParticleEffectMessage.ParticleTypes.MANAWEAVE_CRAFT_COMPLETE);
            this.field_145850_b.func_184148_a(null, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 1.0f, (float)(0.9 + Math.random() * 0.2));
            this.setPlayerReference(player);
            this.consumeReCraftReagents(player);
            ItemStack output = this.lastCraftOutput.func_77946_l();
            if (!player.field_71071_by.func_70441_a(output)) {
                this.setOutputItem(output);
                this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
            }
            return true;
        }
        return false;
    }

    public ItemStack getReCraftOutput() {
        return this.lastCraftOutput;
    }

    public int getReCraftManaCost() {
        return this.lastCraftPatternCount * (Integer)GeneralModConfig.MA_AVERAGE_MANAWEAVE_COST.get();
    }

    public List<ItemStack> getReCraftInput() {
        return this.lastCraftItems.stream().filter(stack -> !stack.func_190926_b()).collect(Collectors.toList());
    }

    private PlayerEntity getCrafter() {
        if (this.__crafter == null && this.__crafterID != null) {
            this.__crafter = this.field_145850_b.func_217371_b(this.__crafterID);
        }
        return this.__crafter;
    }

    @Override
    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        return this.getCrafter() != null && this.func_70301_a(index).func_190926_b() && itemStackIn.func_190916_E() == 1;
    }

    @Override
    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return !this.isCrafting() && this.getCrafter() != null && !this.func_70301_a(index).func_190926_b() && stack.func_190916_E() == 1;
    }

    @Override
    public int[] func_180463_a(Direction side) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72321_a(0.0, 1.0, 0.0);
    }

    private ItemAndPatternCraftingInventory createCraftingInventory() {
        ArrayList<String> patterns = new ArrayList<String>();
        for (ManaweavingPattern p : this.addedPatterns) {
            patterns.add(p.func_199560_c().toString());
        }
        for (String s : this.pendingPatterns) {
            patterns.add(s);
        }
        ItemAndPatternCraftingInventory craftinginventory = new ItemAndPatternCraftingInventory(9, patterns);
        for (int i = 0; i < 9; ++i) {
            craftinginventory.func_70299_a(i, this.func_70301_a(i));
        }
        return craftinginventory;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.field_145846_f && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.handler == null) {
                this.handler = LazyOptional.of(this::createHandler);
            }
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    private IItemHandlerModifiable createHandler() {
        BlockState state = this.func_195044_w();
        if (!(state.func_177230_c() instanceof ChestBlock)) {
            return new InvWrapper((IInventory)this);
        }
        IInventory inv = ChestBlock.func_226916_a_((ChestBlock)((ChestBlock)state.func_177230_c()), (BlockState)state, (World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (boolean)true);
        return new InvWrapper((IInventory)(inv == null ? this : inv));
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (this.getCrafter() != null) {
            return super.func_94041_b(index, stack);
        }
        return false;
    }

    @Override
    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventoryItems.get(index);
    }
}

