/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.tileentities;

import com.ma.api.blocks.tile.TileEntityWithInventory;
import com.ma.blocks.BlockInit;
import com.ma.blocks.tileentities.init.TileEntityInit;
import com.ma.events.EventDispatcher;
import com.ma.gui.containers.block.ContainerRunescribingTable;
import com.ma.items.ItemInit;
import com.ma.items.runes.ItemRunePattern;
import com.ma.network.ClientMessageDispatcher;
import com.ma.network.messages.to_server.RunescribingTableMutexChangeMessage;
import com.ma.recipes.RecipeInit;
import com.ma.recipes.runeforging.RunescribingRecipe;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.extensions.IForgeTileEntity;

public class RunescribingTableTile
extends TileEntityWithInventory
implements INamedContainerProvider,
Consumer<PacketBuffer>,
IForgeTileEntity,
ISidedInventory {
    public static final int SLOT_HAMMER = 0;
    public static final int SLOT_CHISEL = 1;
    public static final int SLOT_PATTERN = 2;
    public static final int SLOT_GUIDE = 3;
    private UUID tableuuid;

    public RunescribingTableTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn, 4);
    }

    public RunescribingTableTile() {
        this((TileEntityType)TileEntityInit.RUNESCRIBING_TABLE.get());
    }

    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerRunescribingTable(id, playerInventory, this);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("mana-and-artifice:container.inscription_table");
    }

    @Override
    public void accept(PacketBuffer data) {
        data.func_179255_a(this.func_174877_v());
    }

    public RunescribingTableTile readFrom(PacketBuffer data) {
        return this;
    }

    public boolean writeMutexChanges(long hMutex, long vMutex, PlayerEntity player, int playerTier) {
        RunescribingRecipe recipe;
        boolean returnValue = false;
        if (this.field_145850_b.field_72995_K) {
            ClientMessageDispatcher.sendRunescribingMutexChange(this, hMutex, vMutex, playerTier);
            return returnValue;
        }
        ItemStack patternStack = this.func_70301_a(2);
        if (patternStack.func_77973_b() == ItemInit.RUNE_PATTERN.get()) {
            ((ItemRunePattern)ItemInit.RUNE_PATTERN.get()).setHMutex(patternStack, hMutex);
            ((ItemRunePattern)ItemInit.RUNE_PATTERN.get()).setVMutex(patternStack, vMutex);
        }
        if ((recipe = (RunescribingRecipe)this.field_145850_b.func_199532_z().func_215371_a(RecipeInit.RUNESCRIBING_TYPE, (IInventory)this.createDummyCraftingInventory(patternStack), this.field_145850_b).orElse(null)) != null && (playerTier < 0 || recipe.getTier() <= playerTier) && EventDispatcher.DispatchRunescribeCraft(recipe, recipe.func_77571_b(), player)) {
            this.func_70299_a(2, recipe.func_77571_b());
            returnValue = true;
        }
        if (playerTier > 0) {
            this.damageHammerAndChisel();
        }
        return returnValue;
    }

    public long getHMutex() {
        ItemStack patternStack = this.func_70301_a(2);
        if (patternStack.func_77973_b() == ItemInit.RUNE_PATTERN.get() && patternStack.func_77942_o()) {
            return patternStack.func_196082_o().func_74763_f("hmutex");
        }
        return 0L;
    }

    public long getVMutex() {
        ItemStack patternStack = this.func_70301_a(2);
        if (patternStack.func_77973_b() == ItemInit.RUNE_PATTERN.get() && patternStack.func_77942_o()) {
            return patternStack.func_77978_p().func_74763_f("vmutex");
        }
        return 0L;
    }

    public boolean hasRequiredItems(boolean toolsRequired) {
        ItemStack patternStack = this.func_70301_a(2);
        ItemStack chiselStack = this.func_70301_a(1);
        ItemStack hammerStack = this.func_70301_a(0);
        if (toolsRequired) {
            return patternStack.func_77973_b() == ItemInit.RUNE_PATTERN.get() && chiselStack.func_77973_b() == ItemInit.RUNESMITH_CHISEL.get() && hammerStack.func_77973_b() == ItemInit.RUNESMITH_HAMMER.get();
        }
        return patternStack.func_77973_b() == ItemInit.RUNE_PATTERN.get();
    }

    private void damageHammerAndChisel() {
        ItemStack chiselStack = this.func_70301_a(1);
        ItemStack hammerStack = this.func_70301_a(0);
        if (chiselStack.func_77973_b() == ItemInit.RUNESMITH_CHISEL.get()) {
            chiselStack.func_196085_b(chiselStack.func_77952_i() + 1);
            if (chiselStack.func_77952_i() >= chiselStack.func_77958_k()) {
                this.func_70299_a(1, ItemStack.field_190927_a);
            }
        }
        if (hammerStack.func_77973_b() == ItemInit.RUNESMITH_HAMMER.get()) {
            hammerStack.func_196085_b(hammerStack.func_77952_i() + 1);
            if (hammerStack.func_77952_i() >= hammerStack.func_77958_k()) {
                this.func_70299_a(0, ItemStack.field_190927_a);
            }
        }
    }

    private static RunescribingTableTile getAndVerify(World world, BlockPos position) {
        TileEntity te;
        if (world.func_195588_v(position) && world.func_180495_p(position).func_177230_c() == BlockInit.RUNESCRIBING_TABLE.get() && (te = world.func_175625_s(position)) != null && te instanceof RunescribingTableTile) {
            return (RunescribingTableTile)te;
        }
        return null;
    }

    public static void handleMutexChangeMessage(ServerPlayerEntity sendingPlayer, RunescribingTableMutexChangeMessage message) {
        RunescribingTableTile te = RunescribingTableTile.getAndVerify(sendingPlayer.field_70170_p, message.getPosition());
        if (te == null) {
            return;
        }
        te.writeMutexChanges(message.getHMutex(), message.getVMutex(), (PlayerEntity)sendingPlayer, message.getPlayerTier());
    }

    private CraftingInventory createDummyCraftingInventory(ItemStack stack) {
        CraftingInventory craftinginventory = new CraftingInventory(new Container(null, -1){

            public boolean func_75145_c(PlayerEntity playerIn) {
                return false;
            }
        }, 1, 1);
        craftinginventory.func_70299_a(0, stack);
        return craftinginventory;
    }

    @Override
    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        if (itemStackIn.func_190916_E() != 1) {
            return false;
        }
        if (direction == Direction.EAST || direction == Direction.WEST || direction == Direction.NORTH || direction == Direction.SOUTH) {
            if (index == 0 && this.func_70301_a(0).func_190926_b() && itemStackIn.func_77973_b() == ItemInit.RUNESMITH_HAMMER.get()) {
                return true;
            }
            if (index == 1 && this.func_70301_a(1).func_190926_b() && itemStackIn.func_77973_b() == ItemInit.RUNESMITH_CHISEL.get()) {
                return true;
            }
        } else if ((direction == Direction.DOWN || direction == Direction.UP) && index == 2 && this.func_70301_a(2).func_190926_b() && itemStackIn.func_77973_b() == ItemInit.RUNE_PATTERN.get()) {
            return true;
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        if (this.func_70301_a(index).func_190926_b() || !ItemStack.func_179545_c((ItemStack)this.func_70301_a(index), (ItemStack)stack)) {
            return false;
        }
        return direction == Direction.EAST || direction == Direction.WEST || direction == Direction.NORTH || direction == Direction.SOUTH ? index == 0 || index == 1 : (direction == Direction.DOWN || direction == Direction.UP) && index == 2;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        switch (slot) {
            case 0: {
                return stack.func_77973_b() == ItemInit.RUNESMITH_HAMMER.get();
            }
            case 1: {
                return stack.func_77973_b() == ItemInit.RUNESMITH_CHISEL.get();
            }
            case 2: {
                return stack.func_77973_b() == ItemInit.RUNE_PATTERN.get();
            }
            case 3: {
                return stack.func_77973_b() == ItemInit.RECIPE_SCRAP_RUNESCRIBING.get();
            }
        }
        return false;
    }

    @Override
    public int[] func_180463_a(Direction side) {
        if (side == null) {
            return new int[0];
        }
        switch (side) {
            case DOWN: 
            case UP: {
                return new int[]{2};
            }
            case EAST: 
            case NORTH: 
            case SOUTH: 
            case WEST: {
                return new int[]{0, 1};
            }
        }
        return new int[0];
    }

    public int func_70297_j_() {
        return 1;
    }
}

