/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.tileentities.renderers;

import com.ma.blocks.tileentities.LodestarTile;
import com.ma.blocks.tileentities.models.ModelLodestar;
import com.ma.tools.render.ModelUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoBlockRenderer;
import software.bernie.geckolib3.util.RenderUtils;

public class LodestarRenderer
extends GeoBlockRenderer<LodestarTile> {
    private final ResourceLocation base = new ResourceLocation("mana-and-artifice", "block/lodestar_base");
    private final ResourceLocation small_crystal = new ResourceLocation("mana-and-artifice", "block/lodestar_crystalsmall");
    private final ResourceLocation big_crystal = new ResourceLocation("mana-and-artifice", "block/lodestar_crystalbig");
    private final ResourceLocation small_gear = new ResourceLocation("mana-and-artifice", "block/lodestar_gearsmall");
    private final ResourceLocation stabilizer = new ResourceLocation("mana-and-artifice", "block/lodestar_stabilizer");
    protected IRenderTypeBuffer rtb;
    protected Minecraft mc = Minecraft.func_71410_x();
    protected BlockPos pos;
    protected BlockState state;

    public LodestarRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn, (AnimatedGeoModel)new ModelLodestar());
    }

    public RenderType getRenderType(LodestarTile animatable, float partialTicks, MatrixStack stack, IRenderTypeBuffer renderTypeBuffer, IVertexBuilder vertexBuilder, int packedLightIn, ResourceLocation textureLocation) {
        return RenderType.func_228646_f_((ResourceLocation)textureLocation);
    }

    public void renderEarly(LodestarTile animatable, MatrixStack stackIn, float ticks, IRenderTypeBuffer renderTypeBuffer, IVertexBuilder vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float partialTicks) {
        this.rtb = renderTypeBuffer;
        this.pos = animatable.func_174877_v();
        this.state = animatable.func_195044_w();
        super.renderEarly((Object)animatable, stackIn, ticks, renderTypeBuffer, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, partialTicks);
    }

    public void renderRecursively(GeoBone bone, MatrixStack stack, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        stack.func_227860_a_();
        RenderUtils.translate((GeoBone)bone, (MatrixStack)stack);
        RenderUtils.moveToPivot((GeoBone)bone, (MatrixStack)stack);
        RenderUtils.rotate((GeoBone)bone, (MatrixStack)stack);
        RenderUtils.scale((GeoBone)bone, (MatrixStack)stack);
        if (!bone.isHidden) {
            stack.func_227860_a_();
            switch (bone.getName()) {
                case "ROOT": {
                    ModelUtils.renderModel(this.rtb, (World)this.mc.field_71441_e, this.pos, this.state, this.base, stack, packedLightIn, packedOverlayIn);
                    break;
                }
                case "CRYSTAL_BIG": {
                    ModelUtils.renderModel(this.rtb, (World)this.mc.field_71441_e, this.pos, this.state, this.big_crystal, stack, packedLightIn, packedOverlayIn);
                    break;
                }
                case "STABILIZER": {
                    ModelUtils.renderModel(this.rtb, (World)this.mc.field_71441_e, this.pos, this.state, this.stabilizer, stack, packedLightIn, packedOverlayIn);
                    break;
                }
                case "GEAR_ROTATION": {
                    ModelUtils.renderModel(this.rtb, (World)this.mc.field_71441_e, this.pos, this.state, this.small_gear, stack, packedLightIn, packedOverlayIn);
                    break;
                }
                case "CRYSTAL_SMALL": {
                    ModelUtils.renderModel(this.rtb, (World)this.mc.field_71441_e, this.pos, this.state, this.small_crystal, stack, packedLightIn, packedOverlayIn);
                }
            }
            stack.func_227865_b_();
            for (GeoBone childBone : bone.childBones) {
                this.renderRecursively(childBone, stack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            }
        }
        stack.func_227865_b_();
    }
}

