/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.utility;

import com.ma.blocks.BlockInit;
import com.ma.blocks.WaterloggableBlock;
import com.ma.blocks.interfaces.IDontCreateBlockItem;
import com.ma.blocks.tileentities.OffsetBlockTile;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.particle.DiggingParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FillerBlock
extends WaterloggableBlock
implements IDontCreateBlockItem {
    public FillerBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_175972_I).func_226896_b_().func_222380_e().func_200943_b(3.0f), false);
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
        BlockPos offsetPos = this.getOffsetPos((IBlockReader)world, pos);
        if (!world.func_175623_d(offsetPos) && !offsetPos.equals((Object)pos)) {
            world.func_217377_a(offsetPos, true);
        }
        super.onBlockExploded(state, world, pos, explosion);
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean p_196243_5_) {
        BlockPos offsetPos = this.getOffsetPos((IBlockReader)world, pos);
        if (!world.func_175623_d(offsetPos) && !offsetPos.equals((Object)pos)) {
            world.func_175655_b(offsetPos, p_196243_5_);
        }
        super.func_196243_a(state, world, pos, newState, p_196243_5_);
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        BlockPos offsetPos = this.getOffsetPos((IBlockReader)world, pos);
        if (!world.func_175623_d(offsetPos) && !offsetPos.equals((Object)pos)) {
            BlockState offsetState = world.func_180495_p(offsetPos);
            FluidState fluidState = world.func_204610_c(offsetPos);
            offsetState.removedByPlayer(world, offsetPos, player, true, fluidState);
        }
        super.func_176208_a(world, pos, state, player);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity te = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (te != null && te instanceof OffsetBlockTile) {
            ServerWorld world = builder.func_216018_a();
            BlockPos offset = te.func_174877_v().func_177971_a((Vector3i)((OffsetBlockTile)te).getOffset());
            BlockState offsetState = world.func_180495_p(offset);
            LootContext.Builder lootContextBuilder = new LootContext.Builder(world).func_216023_a(world.field_73012_v).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)offset)).func_216015_a(LootParameters.field_216289_i, builder.func_216024_a(LootParameters.field_216289_i)).func_216021_b(LootParameters.field_216281_a, builder.func_216024_a(LootParameters.field_216281_a)).func_216021_b(LootParameters.field_216288_h, (Object)te);
            return offsetState.func_215693_a(lootContextBuilder);
        }
        return super.func_220076_a(state, builder);
    }

    public PushReaction func_149656_h(BlockState p_149656_1_) {
        return PushReaction.BLOCK;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTrace) {
        BlockPos offsetPos = this.getOffsetPos((IBlockReader)world, pos);
        if (!world.func_175623_d(offsetPos) && !offsetPos.equals((Object)pos)) {
            BlockRayTraceResult brtr = new BlockRayTraceResult(rayTrace.func_216347_e(), rayTrace.func_216354_b(), offsetPos, rayTrace.func_216353_d());
            return world.func_180495_p(offsetPos).func_227031_a_(world, player, hand, brtr);
        }
        return ActionResultType.CONSUME;
    }

    public boolean func_200122_a(BlockState p_200122_1_, BlockState p_200122_2_, Direction p_200122_3_) {
        return true;
    }

    private BlockPos getOffsetPos(IBlockReader world, BlockPos origin) {
        OffsetBlockTile tile = (OffsetBlockTile)world.func_175625_s(origin);
        if (tile == null) {
            return origin;
        }
        BlockPos offset = tile.getOffset();
        return origin.func_177971_a((Vector3i)offset);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new OffsetBlockTile();
    }

    public static void setAtOffsetFrom(IWorld world, BlockPos pos, BlockPos offset) {
        BlockPos offsetPos = pos.func_177971_a((Vector3i)offset);
        world.func_180501_a(offsetPos, ((FillerBlock)BlockInit.EMPTY_FILLER_BLOCK.get()).func_176223_P(), 3);
        ((OffsetBlockTile)world.func_175625_s(offsetPos)).setOffset(new BlockPos(offset.func_177958_n() * -1, offset.func_177956_o() * -1, offset.func_177952_p() * -1));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        if (state.func_177230_c() != this) {
            return true;
        }
        BlockPos offset = this.getOffsetPos((IBlockReader)world, pos);
        BlockState offsetState = world.func_180495_p(offset);
        if (offsetState.func_196958_f() || offset.equals((Object)pos)) {
            return true;
        }
        VoxelShape voxelshape = state.func_196954_c((IBlockReader)world, offset);
        voxelshape.func_197755_b((p_228348_3_, p_228348_5_, p_228348_7_, p_228348_9_, p_228348_11_, p_228348_13_) -> {
            double d1 = Math.min(1.0, p_228348_9_ - p_228348_3_);
            double d2 = Math.min(1.0, p_228348_11_ - p_228348_5_);
            double d3 = Math.min(1.0, p_228348_13_ - p_228348_7_);
            int i = Math.max(2, MathHelper.func_76143_f((double)(d1 / 0.25)));
            int j = Math.max(2, MathHelper.func_76143_f((double)(d2 / 0.25)));
            int k = Math.max(2, MathHelper.func_76143_f((double)(d3 / 0.25)));
            for (int l = 0; l < i; ++l) {
                for (int i1 = 0; i1 < j; ++i1) {
                    for (int j1 = 0; j1 < k; ++j1) {
                        double d4 = ((double)l + 0.5) / (double)i;
                        double d5 = ((double)i1 + 0.5) / (double)j;
                        double d6 = ((double)j1 + 0.5) / (double)k;
                        double d7 = d4 * d1 + p_228348_3_;
                        double d8 = d5 * d2 + p_228348_5_;
                        double d9 = d6 * d3 + p_228348_7_;
                        manager.func_78873_a((Particle)new DiggingParticle((ClientWorld)world, (double)pos.func_177958_n() + d7, (double)pos.func_177956_o() + d8, (double)pos.func_177952_p() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5, offsetState).func_174846_a(pos));
                    }
                }
            }
        });
        return true;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        BlockPos offset = this.getOffsetPos(world, pos);
        BlockState offsetState = world.func_180495_p(offset);
        if (offsetState.func_196958_f() || offsetState.func_177230_c() == this || !(target instanceof BlockRayTraceResult)) {
            return ItemStack.field_190927_a;
        }
        BlockRayTraceResult fake_brtr = new BlockRayTraceResult(target.func_216347_e().func_72441_c((double)offset.func_177958_n(), (double)offset.func_177956_o(), (double)offset.func_177952_p()), ((BlockRayTraceResult)target).func_216354_b(), offset, ((BlockRayTraceResult)target).func_216353_d());
        return offsetState.getPickBlock((RayTraceResult)fake_brtr, world, offset, player);
    }

    public boolean func_200123_i(BlockState p_200123_1_, IBlockReader p_200123_2_, BlockPos p_200123_3_) {
        return true;
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.INVISIBLE;
    }
}

