/*
 * Decompiled with CFR 0.152.
 */
package com.ma.capabilities.playerdata.magic.resources;

import com.ma.ManaAndArtifice;
import com.ma.api.capabilities.resource.ICastingResource;
import com.ma.api.capabilities.resource.ICastingResourceRegistry;
import com.ma.api.events.CastingResourceRegistrationEvent;
import com.ma.capabilities.playerdata.magic.resources.Mana;
import com.ma.capabilities.playerdata.magic.resources.Souls;
import java.security.InvalidParameterException;
import java.util.HashMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod.EventBusSubscriber(modid="mana-and-artifice", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CastingResourceRegistry
implements ICastingResourceRegistry {
    private HashMap<ResourceLocation, Class<? extends ICastingResource>> _registry = new HashMap();
    public static final CastingResourceRegistry Instance = new CastingResourceRegistry();

    private void registerDefaults() {
        this.register(Mana.IDENTIFIER, Mana.class);
        this.register(Souls.IDENTIFIER, Souls.class);
    }

    @SubscribeEvent
    public static void RequestRegistration(FMLCommonSetupEvent event) {
        Instance.registerDefaults();
        MinecraftForge.EVENT_BUS.post((Event)new CastingResourceRegistrationEvent(Instance));
        ManaAndArtifice.instance.proxy.sendCastingResourceGuiEvents();
    }

    @Override
    public void register(ResourceLocation identifier, Class<? extends ICastingResource> clazz) {
        if (identifier == null) {
            return;
        }
        if (this._registry.containsKey(identifier)) {
            throw new InvalidParameterException("The Casting Resource Identifier " + identifier.toString() + "is already in use.");
        }
        this._registry.put(identifier, clazz);
    }

    public Class<? extends ICastingResource> getRegisteredClass(ResourceLocation rLoc) {
        return this._registry.getOrDefault(rLoc, this._registry.get(Mana.IDENTIFIER));
    }
}

