/*
 * Decompiled with CFR 0.152.
 */
package com.ma.capabilities.playerdata.progression;

import com.ma.ManaAndArtifice;
import com.ma.api.capabilities.Faction;
import com.ma.api.capabilities.IPlayerProgression;
import java.util.Iterator;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;

public class PlayerProgressionStorage
implements Capability.IStorage<IPlayerProgression> {
    final String KEY_TIER = "tier";
    final String KEY_FACTION = "faction";
    final String KEY_FACTION_STANDING = "faction_standing";
    final String KEY_PROGRESSION = "progression_completion";
    final String KEY_RAID_CHANCE = "raid_chance_";
    final String KEY_RAID_STATS = "raid_stats_";

    public INBT writeNBT(Capability<IPlayerProgression> capability, IPlayerProgression instance, Direction side) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("tier", instance.getTier());
        if (instance.hasAlliedFaction()) {
            nbt.func_74778_a("faction", instance.getAlliedFaction().name());
            nbt.func_74768_a("faction_standing", instance.getFactionStanding());
        }
        ListNBT progressionSteps = new ListNBT();
        for (ResourceLocation rLoc : instance.getCompletedProgressionSteps()) {
            progressionSteps.add((Object)StringNBT.func_229705_a_((String)rLoc.toString()));
        }
        nbt.func_218657_a("progression_completion", (INBT)progressionSteps);
        for (Faction f : Faction.values()) {
            String key = "raid_chance_" + f.toString();
            nbt.func_74780_a(key, instance.getRaidChance(f));
            key = "raid_stats_" + f.toString();
            nbt.func_218657_a(key, (INBT)instance.getFactionDifficultyStats(f).writeToNBT());
        }
        return nbt;
    }

    public void readNBT(Capability<IPlayerProgression> capability, IPlayerProgression instance, Direction side, INBT nbt) {
        if (nbt instanceof CompoundNBT) {
            CompoundNBT cnbt = (CompoundNBT)nbt;
            if (cnbt.func_74764_b("tier")) {
                instance.setTier(cnbt.func_74762_e("tier"), null);
            }
            if (cnbt.func_74764_b("faction")) {
                instance.setAlliedFaction(Faction.valueOf(cnbt.func_74779_i("faction")), null);
            }
            if (cnbt.func_74764_b("faction_standing")) {
                instance.setFactionStanding(cnbt.func_74762_e("faction_standing"));
            }
            if (cnbt.func_74764_b("progression_completion")) {
                ListNBT progressionSteps = cnbt.func_150295_c("progression_completion", 8);
                Iterator it = progressionSteps.iterator();
                while (it.hasNext()) {
                    instance.addTierProgressionComplete(new ResourceLocation(((INBT)it.next()).func_150285_a_()));
                }
            }
            for (Faction f : Faction.values()) {
                String key = "raid_chance_" + f.toString();
                if (cnbt.func_74764_b(key)) {
                    instance.setRaidChance(f, cnbt.func_74769_h(key));
                }
                if (!cnbt.func_74764_b(key = "raid_stats_" + f.toString())) continue;
                instance.getFactionDifficultyStats(f).readFromNBT(cnbt.func_74775_l(key));
            }
        } else {
            ManaAndArtifice.LOGGER.error("Progression NBT passed back not an instance of CompoundNBT - save data was NOT loaded!");
        }
    }
}

