/*
 * Decompiled with CFR 0.152.
 */
package com.ma.capabilities.worlddata;

import com.ma.api.capabilities.IRitualTeleportLocation;
import com.ma.api.capabilities.IWellspringNodeRegistry;
import com.ma.api.capabilities.IWorldMagic;
import com.ma.api.spells.base.ISpellRune;
import com.ma.capabilities.worlddata.RitualTeleportLocation;
import com.ma.capabilities.worlddata.WellspringNodeRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class WorldMagic
implements IWorldMagic {
    private static final int MAX_RUNES_PER_PLAYER = 5;
    private NonNullList<IRitualTeleportLocation> teleport_locations = NonNullList.func_191196_a();
    private WellspringNodeRegistry wellsprings;
    private ArrayList<BlockPos> warding_candle_locations;
    private Map<UUID, LinkedList<UUID>> playerRunes = new HashMap<UUID, LinkedList<UUID>>();
    private Map<UUID, Entity> knownRunes = new HashMap<UUID, Entity>();

    public WorldMagic() {
        this(false);
    }

    public WorldMagic(boolean isOverworld) {
        this.warding_candle_locations = new ArrayList();
        this.wellsprings = new WellspringNodeRegistry();
        this.wellsprings.isOverworld = isOverworld;
    }

    @Override
    @Nullable
    public IRitualTeleportLocation getRitualTeleportBlockLocation(List<ResourceLocation> reagents, RegistryKey<World> world) {
        for (int i = 0; i < this.teleport_locations.size(); ++i) {
            if (!((IRitualTeleportLocation)this.teleport_locations.get(i)).matches(reagents)) continue;
            IRitualTeleportLocation location = (IRitualTeleportLocation)this.teleport_locations.get(i);
            location.tryCorrectWorldKey(world);
            return location;
        }
        return null;
    }

    @Override
    @Nullable
    public List<ResourceLocation> getRitualTeleportBlockReagents(BlockPos pos) {
        for (int i = 0; i < this.teleport_locations.size(); ++i) {
            if (!((IRitualTeleportLocation)this.teleport_locations.get(i)).matches(pos)) continue;
            return ((IRitualTeleportLocation)this.teleport_locations.get(i)).getReagents();
        }
        return null;
    }

    @Override
    public IRitualTeleportLocation[] getAllTeleportLocations() {
        Object[] locations = new IRitualTeleportLocation[this.teleport_locations.size()];
        return (IRitualTeleportLocation[])this.teleport_locations.toArray(locations);
    }

    @Override
    public boolean setRitualTeleportLocation(ServerWorld world, BlockPos pos, List<ResourceLocation> reagents, Direction direction) {
        return this.setRitualTeleportLocation(new RitualTeleportLocation((RegistryKey<World>)world.func_234923_W_(), pos, reagents, direction));
    }

    @Override
    public boolean setRitualTeleportLocation(IRitualTeleportLocation location) {
        if (this.getRitualTeleportBlockLocation((List<ResourceLocation>)location.getReagents(), location.getWorldType()) != null) {
            return false;
        }
        this.teleport_locations.add((Object)location);
        return true;
    }

    @Override
    public void removeRitualTeleportLocation(BlockPos pos) {
        for (int i = 0; i < this.teleport_locations.size(); ++i) {
            if (!((IRitualTeleportLocation)this.teleport_locations.get(i)).matches(pos)) continue;
            this.teleport_locations.remove(i);
            break;
        }
    }

    private boolean isBlockWarded(BlockPos pos) {
        return false;
    }

    @Override
    public boolean canPlayerUnlock(BlockPos pos, PlayerEntity player) {
        if (!this.isBlockWarded(pos)) {
            return true;
        }
        return player.func_184812_l_();
    }

    @Override
    public boolean wardBlock(BlockPos pos, PlayerEntity caster, Collection<ResourceLocation> patterns) {
        return false;
    }

    @Override
    public void addRune(PlayerEntity player, ISpellRune<?> rune) {
        LinkedList<UUID> player_owned_runes;
        if (this.isRuneKnown(rune.getID())) {
            return;
        }
        if (!this.playerRunes.containsKey(player.func_110124_au())) {
            this.playerRunes.put(player.func_110124_au(), new LinkedList());
        }
        if (!(player_owned_runes = this.playerRunes.get(player.func_110124_au())).contains(rune.getID())) {
            while (player_owned_runes.size() >= 5) {
                UUID first = player_owned_runes.poll();
                this.removeRune(player.func_110124_au(), first);
            }
            player_owned_runes.add(rune.getID());
        }
        this.knownRunes.put(rune.getID(), (Entity)rune);
    }

    @Override
    public void addUnreferencedRune(UUID player, UUID rune) {
        if (!this.playerRunes.containsKey(player)) {
            this.playerRunes.put(player, new LinkedList());
        }
        LinkedList<UUID> player_owned_runes = this.playerRunes.get(player);
        player_owned_runes.add(rune);
    }

    @Override
    public void removeRune(UUID player, UUID rune) {
        if (this.playerRunes.containsKey(player)) {
            this.playerRunes.get(player).remove(rune);
        }
        if (this.knownRunes.containsKey(rune)) {
            Entity runeEntity = this.knownRunes.get(rune);
            if (runeEntity != null) {
                runeEntity.remove(false);
            }
            this.knownRunes.remove(rune);
        }
    }

    @Override
    public boolean isRuneKnown(UUID rune) {
        if (rune == null) {
            return false;
        }
        return this.knownRunes.containsKey(rune);
    }

    @Override
    public boolean wasRuneRemoved(UUID player, UUID rune) {
        return !this.playerRunes.containsKey(player) || !this.playerRunes.get(player).contains(rune);
    }

    @Override
    public UUID[] getKnownPlayersWithRunes() {
        return this.playerRunes.keySet().toArray(new UUID[0]);
    }

    @Override
    public UUID[] getKnownRunesForPlayer(UUID player) {
        if (!this.playerRunes.containsKey(player)) {
            return new UUID[0];
        }
        return this.playerRunes.get(player).toArray(new UUID[0]);
    }

    @Override
    public List<Long> getAllWardingCandleLocations() {
        return this.warding_candle_locations.stream().map(bp -> bp.func_218275_a()).collect(Collectors.toList());
    }

    @Override
    public void setWardingCandleLocations(List<Long> locations) {
        this.warding_candle_locations.clear();
        this.warding_candle_locations.addAll(locations.stream().map(l -> BlockPos.func_218283_e((long)l)).collect(Collectors.toList()));
    }

    @Override
    public void addWardingCandleLocation(BlockPos location) {
        long posLong = location.func_218275_a();
        if (!this.warding_candle_locations.stream().anyMatch(pos -> pos.func_218275_a() == posLong)) {
            this.warding_candle_locations.add(location);
        }
    }

    @Override
    public void removeWardingCandleLocation(BlockPos location) {
        long posLong = location.func_218275_a();
        this.warding_candle_locations.removeIf(pos -> pos.func_218275_a() == posLong);
    }

    @Override
    public boolean isWithinWardingCandle(BlockPos pos) {
        return this.warding_candle_locations.stream().anyMatch(p -> Math.abs(p.func_177958_n() - pos.func_177958_n()) <= 32 && Math.abs(p.func_177956_o() - pos.func_177956_o()) <= 32 && Math.abs(p.func_177952_p() - pos.func_177952_p()) <= 32);
    }

    @Override
    public IWellspringNodeRegistry getWellspringRegistry() {
        return this.wellsprings;
    }
}

