/*
 * Decompiled with CFR 0.152.
 */
package com.ma.commands;

import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class CommandSetPlayerTier {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"settier").requires(commandSource -> commandSource.func_197034_c(2))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"tier", (ArgumentType)IntegerArgumentType.integer((int)1, (int)5)).executes(context -> CommandSetPlayerTier.setTier((CommandSource)context.getSource(), Collections.singleton(((CommandSource)context.getSource()).func_197035_h()), IntegerArgumentType.getInteger((CommandContext)context, (String)"tier")))).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197094_d()).executes(context -> CommandSetPlayerTier.setTier((CommandSource)context.getSource(), EntityArgument.func_197090_e((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"tier"))))));
    }

    private static int setTier(CommandSource source, Collection<ServerPlayerEntity> players, int tier) {
        if (players == null || players.size() == 0) {
            return 0;
        }
        for (ServerPlayerEntity spe : players) {
            spe.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(progression -> progression.setTier(tier, (PlayerEntity)spe));
        }
        if (players.size() == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("mana-and-artifice.commands.tier.success", new Object[]{players.iterator().next().func_145748_c_(), tier}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("mana-and-artifice.commands.tier.success", new Object[]{players.size(), tier}), true);
        }
        return 1;
    }
}

