/*
 * Decompiled with CFR 0.152.
 */
package com.ma.commands;

import com.google.gson.JsonObject;
import com.ma.recipes.multiblock.MultiblockConfiguration;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.server.ServerWorld;

public class CommandStructureDiff {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"structurediff").then(Commands.func_197056_a((String)"baseline", (ArgumentType)StringArgumentType.string()).then(Commands.func_197056_a((String)"variation", (ArgumentType)StringArgumentType.string()).executes(context -> CommandStructureDiff.computeDiff((CommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"baseline"), StringArgumentType.getString((CommandContext)context, (String)"variation"))))));
    }

    private static int computeDiff(CommandSource source, String firstStructure, String secondStructure) {
        ServerWorld sw = source.func_197023_e();
        ArrayList<BlockState> blockStates = new ArrayList<BlockState>();
        MultiblockConfiguration first = MultiblockConfiguration.loadStructure(sw.func_184163_y(), new ResourceLocation(firstStructure), blockStates);
        MultiblockConfiguration second = MultiblockConfiguration.loadStructure(sw.func_184163_y(), new ResourceLocation(secondStructure), blockStates);
        if (!first.getIsValid()) {
            source.func_197021_a((ITextComponent)new StringTextComponent("Unable to locate first structure"));
            return 0;
        }
        if (!second.getIsValid()) {
            source.func_197021_a((ITextComponent)new StringTextComponent("Unable to locate second structure"));
            return 0;
        }
        JsonObject diff = first.computeRecipeDiff(second, blockStates);
        source.func_197030_a((ITextComponent)new StringTextComponent(diff.toString()), true);
        return 1;
    }
}

