/*
 * Decompiled with CFR 0.152.
 */
package com.ma.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class GeneralModConfig {
    public static ForgeConfigSpec.BooleanValue MA_MODIFY_VILLAGER_TRADES;
    public static ForgeConfigSpec.BooleanValue MA_DISABLE_VILLAGER_REGISTRATION;
    public static ForgeConfigSpec.BooleanValue CLASSIC_RAIDS;
    public static ForgeConfigSpec.DoubleValue RAID_CHANCE_BASE;
    public static ForgeConfigSpec.DoubleValue RAID_CHANCE_TIER;
    public static ForgeConfigSpec.IntValue RAID_SPAWN_ATTEMPTS;
    public static ForgeConfigSpec.IntValue MA_NODE_DISTANCE;
    public static ForgeConfigSpec.BooleanValue MA_WELLSPRING_POWER_FACTION;
    public static ForgeConfigSpec.BooleanValue MA_GENERIC_WELLSPRINGS;
    public static ForgeConfigSpec.IntValue MA_VINTEUM_VEIN_SIZE;
    public static ForgeConfigSpec.IntValue MA_VINTEUM_VEIN_COUNT;
    public static ForgeConfigSpec.IntValue MA_VINTEUM_VEIN_YVALUE;
    public static ForgeConfigSpec.BooleanValue MA_GRADUAL_TIME_CHANGE;
    public static ForgeConfigSpec.DoubleValue MA_FORTIFICATION_DAMAGE;
    public static ForgeConfigSpec.ConfigValue<String> MA_SPELL_DIMENSION_BLACKLIST;
    public static ForgeConfigSpec.ConfigValue<String> MA_SPELL_BIOME_BLACKLIST;
    public static ForgeConfigSpec.IntValue MA_PHYLACTERY_KILLS;
    public static ForgeConfigSpec.BooleanValue MA_SUMMON_BOSSES;
    public static ForgeConfigSpec.BooleanValue MA_SUMMON_INTERACTIONS;
    public static ForgeConfigSpec.BooleanValue MA_PHYLACTERY_BOSSES;
    public static ForgeConfigSpec.BooleanValue MA_METEOR_JUMP;
    public static ForgeConfigSpec.IntValue MA_SPELLWEAVER_REFLECTCHARGES;
    public static ForgeConfigSpec.IntValue MA_SPELLWEAVER_RECHARGETIME;
    public static ForgeConfigSpec.DoubleValue MA_DRUIDIC_REFLECTCHANCE;
    public static ForgeConfigSpec.DoubleValue MA_DRUIDIC_TELEPORTCHANCE;
    public static ForgeConfigSpec.IntValue MA_SOULS_PLAYER;
    public static ForgeConfigSpec.IntValue MA_SOULS_VILLAGER;
    public static ForgeConfigSpec.IntValue MA_SOULS_FACTION;
    public static ForgeConfigSpec.IntValue MA_SOULS_MOB;
    public static ForgeConfigSpec.IntValue MA_SOULS_ANIMAL;
    public static ForgeConfigSpec.IntValue MA_SOULS_UNDEAD;
    public static ForgeConfigSpec.ConfigValue<String> MA_WARD_BLACKLIST;
    public static ForgeConfigSpec.ConfigValue<String> MA_WARD_WHITELIST;
    public static ForgeConfigSpec.DoubleValue MA_TIER_PCT;
    public static ForgeConfigSpec.BooleanValue LITE_MODE;
    public static ForgeConfigSpec.DoubleValue MA_MELEE_DIST;
    public static ForgeConfigSpec.IntValue MA_AVERAGE_MANAWEAVE_COST;

    public static void init(ForgeConfigSpec.Builder serverBuilder) {
        GeneralModConfig.initGeneralOptions(serverBuilder);
        GeneralModConfig.initVillagerTradeConfig(serverBuilder);
        GeneralModConfig.initFactionRaidConfig(serverBuilder);
        GeneralModConfig.initWorldgenOptions(serverBuilder);
        GeneralModConfig.initSoulsoptions(serverBuilder);
        GeneralModConfig.initArtifactOptions(serverBuilder);
    }

    private static void initVillagerTradeConfig(ForgeConfigSpec.Builder serverBuilder) {
        serverBuilder.comment("Mana and Artifice // Villager Modification").push("ma_villager_modification");
        MA_MODIFY_VILLAGER_TRADES = serverBuilder.comment("Adjust librarian villagers to not have enchanted books until tier 3.  This is done for balancing and to remove the exploit of rolling librarians for cheap enchants. [true / false]").define("modifyVillagerTrades", true);
        serverBuilder.pop();
    }

    private static void initFactionRaidConfig(ForgeConfigSpec.Builder serverBuilder) {
        serverBuilder.comment("Mana and Artifice // Faction Raids").comment("Raids are incremented when you use items/spells from the other factions.  When they get angry enough, you will be raided.").push("ma_faction_raids");
        CLASSIC_RAIDS = serverBuilder.comment("Should classic raiding be enabled?  Raids are based on a chance value.  The value is increased each day there is not a raid.  If the chance hits a total of 1.0 or greater, it's a guaranteed raid.  The chance resets after a raid successfully spawns.").define("classicRaids", false);
        RAID_CHANCE_BASE = serverBuilder.comment("Adjust the base amount per day that the chance to be raided goes up for each player.  This has no effect if classic raids are disabled.").defineInRange("raidBaselineIncrease", 0.05, 0.0, 1.0);
        RAID_CHANCE_TIER = serverBuilder.comment("Adjust the amount per day that the chance to be raided goes up for each player based on their tier above 3 (this value * (tier-3)).  This is added to the baseline.  This has no effect if classic raids are disabled.").defineInRange("raidTierIncrease", 0.05, 0.0, 1.0);
        RAID_SPAWN_ATTEMPTS = serverBuilder.comment("How many attempts (within a 20x20x5 box centered on the player in question) should the game make to spawn a raid?  Note this will be re-attempted every 100 ticks until a successful spawn is made.  If you're lagging due to raid spawn attempts, lower this setting.").defineInRange("raidSpawnAttempts", 100, 1, 1000);
        serverBuilder.pop();
    }

    private static void initGeneralOptions(ForgeConfigSpec.Builder serverBuilder) {
        serverBuilder.comment("Mana and Artifice // General Options").push("ma_general_options");
        MA_GRADUAL_TIME_CHANGE = serverBuilder.comment("Rituals of Aurora and Eventide by default will change time gradually for a prettier effect.  However this isn't without its performance impacts, and this can be toggled off by setting this to false, making the transition instant like the /time set commands. [true / false]").define("gradualTimeChange", true);
        MA_WARD_BLACKLIST = serverBuilder.comment("A comma separated list of entity IDs that the warding candle should ignore, regardless of detection (use this if it's stopping you from something you think it shouldn't; this isn't to expand what it will block)").define("wardingCandleBlacklist", (Object)"");
        MA_WARD_WHITELIST = serverBuilder.comment("A comma separated list of entity IDs that the warding candle should block (in addition to what it blocks by default); use this to expand what it will block.  Note that blacklist overrides this, so an entry in both will be blacklisted.").define("wardingCandleWhitelist", (Object)"");
        MA_TIER_PCT = serverBuilder.comment("Change this to determine how many of a tier's tasks need to be completed before tiering up is allowed.  It is a percentage of the total tasks in the tier.  If you set this above 1, you cannot tier up through normal gameplay.  Use with caution.").defineInRange("tierCompletePct", 0.8, 0.01, 2.0);
        MA_MELEE_DIST = serverBuilder.comment("What the mod considers 'melee distance' between two entities when one attacks the other.  This value is squared, so if you want 8 blocks put 64 in this config.").defineInRange("meleeDistance", 64.0, 1.0, 4096.0);
        MA_AVERAGE_MANAWEAVE_COST = serverBuilder.comment("What the mod considers to be the average manaweave cost when generating manaweaves automatically for the player.").defineInRange("averageManaweaveCost", 25, 0, 500);
        MA_SPELL_DIMENSION_BLACKLIST = serverBuilder.comment("Comma separated list of dimension ids that spells can't be cast in.").define("spellDimensionBlacklist", (Object)"");
        MA_SPELL_BIOME_BLACKLIST = serverBuilder.comment("Comma separated list of biome ids that spells can't be cast in.").define("spellBiomeBlacklist", (Object)"");
        MA_FORTIFICATION_DAMAGE = serverBuilder.comment("How much damage does the fortification effect set all damage to").defineInRange("fortificationDamageAmount", 4.0, 1.0, 20.0);
        MA_PHYLACTERY_KILLS = serverBuilder.comment("How many kills does it take to fill up a crystal phylactery").defineInRange("phylacteryKills", 100, 1, 1000);
        MA_SUMMON_BOSSES = serverBuilder.comment("Can bosses be summoned?").define("bossSummons", false);
        MA_PHYLACTERY_BOSSES = serverBuilder.comment("Can bosses be captured in phylacteries?").define("bossPhylacteries", false);
        MA_SUMMON_INTERACTIONS = serverBuilder.comment("Should summons be able to be right clicked with items to interact?  For example, shearing sheep or milking cows that have been summoned.").define("summonInteractions", true);
        LITE_MODE = serverBuilder.comment("If true, the Ritual of Arcana will instantly rote spells upon completion, in addition to giving you the spell..").define("liteMode", false);
        MA_DISABLE_VILLAGER_REGISTRATION = serverBuilder.comment("Set this to true to disable new villager profession registration.  This allows compatibility with Bukkit.  Note that you'll need to ensure the Codex Arcana is obtainable through different means!").define("disableNewProfessions", false);
        serverBuilder.pop();
    }

    private static void initArtifactOptions(ForgeConfigSpec.Builder serverBuilder) {
        serverBuilder.comment("Mana and Artifice // Artifact Options").push("ma_artifact_options");
        MA_METEOR_JUMP = serverBuilder.comment("By default meteor jump will follow the mobGriefing rule.  Set this to true to override that regardless of the game rule.").define("meteorJumpDestruction", true);
        MA_SPELLWEAVER_REFLECTCHARGES = serverBuilder.comment("How many reflect charges the Spellweaver armor set has").defineInRange("councilArmorReflectCharges", 3, 0, 99);
        MA_SPELLWEAVER_RECHARGETIME = serverBuilder.comment("How many ticks the Spellweaver armor set needs to regenerate one reflect charge").defineInRange("councilArmorReflectRecharge", 100, 20, 2000);
        MA_DRUIDIC_REFLECTCHANCE = serverBuilder.comment("The percent chance the fey armor will reflect projectiles.").defineInRange("feyArmorReflectChance", (double)0.2f, 0.0, 1.0);
        MA_DRUIDIC_TELEPORTCHANCE = serverBuilder.comment("The percent chance the fey armor will randomly teleport melee attackers.").defineInRange("feyArmorTeleportChance", (double)0.2f, 0.0, 1.0);
        serverBuilder.pop();
    }

    private static void initWorldgenOptions(ForgeConfigSpec.Builder serverBuilder) {
        serverBuilder.comment("Mana and Artifice // Worldgen Options").push("ma_worldgen_options");
        MA_NODE_DISTANCE = serverBuilder.comment("How far apart wellspring nodes must be as a minimum.  They can be farther than this depending on world seed and generation.").defineInRange("wellspringDistance", 500, 100, 15000);
        MA_WELLSPRING_POWER_FACTION = serverBuilder.comment("If true, total wellspring power will be calculated per faction rather than per player.").define("wellspringFactionClaims", false);
        MA_GENERIC_WELLSPRINGS = serverBuilder.comment("If true, wellsprings will generate with no affinity and the type of lens used will set the affinity of the node.").define("genericWellsprings", false);
        MA_VINTEUM_VEIN_SIZE = serverBuilder.comment("Size of vinteum veins").defineInRange("vinteumVeinSize", 9, 1, 20);
        MA_VINTEUM_VEIN_COUNT = serverBuilder.comment("Count of vinteum veins").defineInRange("vinteumVeinCount", 20, 1, 100);
        MA_VINTEUM_VEIN_YVALUE = serverBuilder.comment("Max Y-value of vinteum veins").defineInRange("vinteumVeinYValue", 63, 10, 255);
        serverBuilder.pop();
    }

    private static void initSoulsoptions(ForgeConfigSpec.Builder serverBuilder) {
        MA_SOULS_PLAYER = serverBuilder.comment("How many souls are players worth when killed?").defineInRange("playerSouls", 2500, 1, 20000);
        MA_SOULS_VILLAGER = serverBuilder.comment("How many souls are villagers worth when killed?").defineInRange("villagerSouls", 250, 1, 20000);
        MA_SOULS_FACTION = serverBuilder.comment("How many souls are enemy faction members worth when killed?").defineInRange("factionSouls", 250, 1, 20000);
        MA_SOULS_MOB = serverBuilder.comment("How many souls are mobs worth when killed?").defineInRange("mobSouls", 150, 1, 20000);
        MA_SOULS_ANIMAL = serverBuilder.comment("How many souls are animals worth when killed?").defineInRange("animalSouls", 100, 1, 20000);
        MA_SOULS_UNDEAD = serverBuilder.comment("How many souls are undead worth when killed?").defineInRange("undeadSouls", 50, 1, 20000);
    }
}

