/*
 * Decompiled with CFR 0.152.
 */
package com.ma.enchantments.auras;

import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.enchantments.MAEnchantmentBase;
import com.ma.items.ItemInit;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraftforge.fml.RegistryObject;
import top.theillusivec4.curios.api.CuriosApi;

public class Aura
extends MAEnchantmentBase {
    private int _duration = 100;
    private int _magnitude = 0;
    private int _radius = 25;
    private float _manaCost;
    private Effect _effect;
    private RegistryObject<Effect> _deferredEffect;
    private Predicate<PlayerEntity> _applicationPredicate;

    public Aura(Enchantment.Rarity rarityIn) {
        super(rarityIn, EnchantmentType.ARMOR, new EquipmentSlotType[]{EquipmentSlotType.CHEST});
    }

    public boolean func_92089_a(ItemStack stack) {
        return stack.func_77973_b() instanceof ArmorItem && ((ArmorItem)stack.func_77973_b()).func_185083_B_() == EquipmentSlotType.CHEST;
    }

    protected boolean func_77326_a(Enchantment ench) {
        return !(ench instanceof Aura);
    }

    public int func_77319_d() {
        return 1;
    }

    public int func_77325_b() {
        return 1;
    }

    public Aura withDuration(int duration) {
        this._duration = duration;
        return this;
    }

    public Aura withMagnitude(int magnitude) {
        this._magnitude = magnitude;
        return this;
    }

    public Aura withRadius(int radius) {
        this._radius = radius;
        return this;
    }

    public Aura withManaCost(float manaCost) {
        this._manaCost = manaCost;
        return this;
    }

    public Aura withEffect(Effect effect) {
        this._effect = effect;
        return this;
    }

    public Aura withEffect(RegistryObject<Effect> effect) {
        this._deferredEffect = effect;
        return this;
    }

    public Aura withPredicate(Predicate<PlayerEntity> predicate) {
        this._applicationPredicate = predicate;
        return this;
    }

    private Effect getEffect() {
        if (this._effect == null && this._deferredEffect != null && this._deferredEffect.isPresent()) {
            this._effect = (Effect)this._deferredEffect.get();
        }
        return this._effect;
    }

    public void apply(PlayerEntity source, int enchantmentLevel, boolean manaOnly) {
        if (this._applicationPredicate != null && !this._applicationPredicate.test(source)) {
            return;
        }
        source.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
            boolean hasBelt = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemInit.BELT_SELFISHNESS.get(), (LivingEntity)source).isPresent();
            List players = hasBelt ? Arrays.asList(source) : source.field_70170_p.func_217357_a(PlayerEntity.class, source.func_174813_aQ().func_186662_g((double)this._radius));
            for (PlayerEntity player : players) {
                float adjustedManaCost = this._manaCost * (float)(hasBelt ? 2 : 5);
                if (m.getCastingResource().getAmount() < adjustedManaCost) break;
                if (source.func_96124_cp() != null && !player.func_184191_r((Entity)source)) continue;
                if (!manaOnly) {
                    EffectInstance newInst = new EffectInstance(this.getEffect(), this._duration, enchantmentLevel - 1 + this._magnitude, true, false);
                    player.func_195064_c(newInst);
                }
                m.getCastingResource().consume(adjustedManaCost);
            }
        });
    }
}

