/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.boss;

import com.google.common.collect.Maps;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.entities.ai.ThreatTable;
import com.ma.events.delayed.DelayedEventQueue;
import com.ma.events.delayed.TimedDelayedEvent;
import com.ma.spells.SpellCaster;
import com.ma.spells.crafting.ModifiedSpellPart;
import com.ma.spells.crafting.SpellRecipe;
import com.ma.tools.CollectionUtils;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.commons.lang3.mutable.MutableObject;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.SoundKeyframeEvent;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public abstract class BossMonster<T extends BossMonster<?>>
extends MonsterEntity
implements IAnimatable {
    private AnimationFactory animFactory;
    private static final DataParameter<Integer> DATA_ID_INV = EntityDataManager.func_187226_a(BossMonster.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DATA_STATE = EntityDataManager.func_187226_a(BossMonster.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> DATA_SHOW_BOSS_BAR = EntityDataManager.func_187226_a(BossMonster.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final Predicate<LivingEntity> LIVING_ENTITY_SELECTOR = entity -> entity.func_70089_S() && entity.func_190631_cK();
    protected static final EntityPredicate TARGETING_CONDITIONS = new EntityPredicate().func_221013_a(20.0).func_221012_a(LIVING_ENTITY_SELECTOR);
    private static final EntityPredicate HURT_BY_TARGETING = new EntityPredicate().func_221014_c().func_221010_e();
    protected static final int ACTION_ATTACK = 1;
    private final Map<Integer, Integer> cooldowns = Maps.newHashMap();
    protected ThreatTable threat;
    private float lastMobDamageTaken;

    protected BossMonster(EntityType<? extends MonsterEntity> p_i48553_1_, World p_i48553_2_) {
        super(p_i48553_1_, p_i48553_2_);
        this.animFactory = new AnimationFactory((IAnimatable)this);
        this.threat = new ThreatTable();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.cooldowns.keySet().forEach(c -> {
            int cd = this.cooldowns.get(c);
            if (cd > 0) {
                this.cooldowns.put((Integer)c, cd - 1);
            }
        });
        if (this.field_70170_p.field_72995_K) {
            this.spawnParticles();
        }
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_200203_b(@Nullable ITextComponent p_200203_1_) {
        super.func_200203_b(p_200203_1_);
        this.getBossEvent().func_186739_a(this.func_145748_c_());
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.doesRegenerate() && this.field_70173_aa % this.getPassiveHealRate() == 0) {
            this.func_70691_i(this.getPassiveHealAmount());
        }
        this.getBossEvent().func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_213295_a(BlockState p_213295_1_, Vector3d p_213295_2_) {
    }

    public void func_184178_b(ServerPlayerEntity p_184178_1_) {
        super.func_184178_b(p_184178_1_);
        if (((Boolean)this.field_70180_af.func_187225_a(DATA_SHOW_BOSS_BAR)).booleanValue()) {
            this.getBossEvent().func_186760_a(p_184178_1_);
        }
    }

    public void func_184203_c(ServerPlayerEntity p_184203_1_) {
        super.func_184203_c(p_184203_1_);
        this.getBossEvent().func_186761_b(p_184203_1_);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_ID_INV, (Object)0);
        this.field_70180_af.func_187214_a(DATA_STATE, (Object)0);
        this.field_70180_af.func_187214_a(DATA_SHOW_BOSS_BAR, (Object)true);
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74768_a("Invul", this.getInvulnerableTicks());
        nbt.func_74768_a("state", ((Integer)this.field_70180_af.func_187225_a(DATA_STATE)).intValue());
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.setInvulnerableTicks(nbt.func_74762_e("Invul"));
        if (this.func_145818_k_()) {
            this.getBossEvent().func_186739_a(this.func_145748_c_());
        }
        this.field_70180_af.func_187227_b(DATA_STATE, (Object)nbt.func_74762_e("state"));
    }

    public boolean func_70097_a(DamageSource type, float amount) {
        if (this.getInvulnerableTicks() > 0 && type != DamageSource.field_76380_i) {
            return false;
        }
        if (this.isDamageCheaty(type) || this.isSourceTooFar(type)) {
            this.teleportToTarget(type);
            return false;
        }
        boolean success = super.func_70097_a(type, amount);
        if (success && type.func_76346_g() != null && type.func_76346_g() instanceof LivingEntity && type.func_76346_g().func_145782_y() != this.func_145782_y()) {
            this.threat.addThreat((LivingEntity)type.func_76346_g(), amount, this.func_70638_az());
            this.lastMobDamageTaken = amount;
        }
        return success;
    }

    protected boolean isDamageCheaty(DamageSource type) {
        return type == DamageSource.field_191291_g || type == DamageSource.field_76371_c || type == DamageSource.field_76368_d || type == DamageSource.field_82728_o || type == DamageSource.field_76371_c;
    }

    protected boolean isSourceTooFar(DamageSource type) {
        Entity e = type.func_76346_g();
        if (e == null) {
            return false;
        }
        return this.func_213303_ch().func_72436_e(e.func_213303_ch()) > 1024.0;
    }

    protected abstract ServerBossInfo getBossEvent();

    protected void setCooldown(int id, int ticks) {
        this.cooldowns.put(id, ticks);
    }

    protected boolean isOnCooldown(int id) {
        return this.cooldowns.getOrDefault(id, 0) > 0;
    }

    protected float getPassiveHealAmount() {
        return 1.0f;
    }

    protected int getPassiveHealRate() {
        return 40;
    }

    protected boolean doesRegenerate() {
        if (this.getInvulnerableTicks() > 0) {
            return false;
        }
        return this.getPassiveHealRate() > 0 && this.getPassiveHealAmount() > 0.0f;
    }

    protected void updateState(int ... flags) {
        int finalFlag = 0;
        for (int i : flags) {
            finalFlag |= i;
        }
        this.field_70180_af.func_187227_b(DATA_STATE, (Object)finalFlag);
    }

    protected void clearState(int ... flags) {
        int finalFlag = (Integer)this.field_70180_af.func_187225_a(DATA_STATE);
        for (int i : flags) {
            finalFlag &= ~i;
        }
        this.field_70180_af.func_187227_b(DATA_STATE, (Object)finalFlag);
    }

    protected void clearState() {
        this.field_70180_af.func_187227_b(DATA_STATE, (Object)0);
    }

    protected boolean flagSet(int flag) {
        int data = (Integer)this.field_70180_af.func_187225_a(DATA_STATE);
        return (data & flag) != 0;
    }

    protected void onFlagChanged(int newFlags) {
    }

    protected void showBossBar() {
        this.field_70180_af.func_187227_b(DATA_SHOW_BOSS_BAR, (Object)true);
        this.getBossEvent().func_186758_d(true);
    }

    protected void hideBossBar() {
        this.field_70180_af.func_187227_b(DATA_SHOW_BOSS_BAR, (Object)false);
        this.getBossEvent().func_186758_d(false);
    }

    public void func_184206_a(DataParameter<?> param) {
        super.func_184206_a(param);
        if (param == DATA_STATE) {
            this.onFlagChanged((Integer)this.field_70180_af.func_187225_a(DATA_STATE));
        }
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate);
        data.addAnimationController(controller);
        controller.registerSoundListener(this::soundListener);
    }

    protected final <ENTITY extends IAnimatable> void soundListener(SoundKeyframeEvent<ENTITY> event) {
        this.playSoundForAnim(event.sound);
    }

    protected void playSoundForAnim(String sound) {
    }

    public AnimationFactory getFactory() {
        return this.animFactory;
    }

    protected abstract <E extends IAnimatable> PlayState predicate(AnimationEvent<E> var1);

    protected void teleportToTarget(DamageSource type) {
        Entity e = type.func_76346_g();
        if (e != null) {
            if (e instanceof LivingEntity) {
                this.threat.initializeThreat((LivingEntity)e);
            }
            this.func_70634_a(e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_());
        }
    }

    @Nullable
    protected PlayerEntity getRandomNearbyPlayer(Predicate<PlayerEntity> predicate) {
        List nearbyPlayers = this.field_70170_p.func_217373_a(TARGETING_CONDITIONS, (LivingEntity)this, this.func_174813_aQ().func_186662_g(20.0));
        MutableObject selection = new MutableObject(null);
        if (predicate != null) {
            CollectionUtils.getRandom(nearbyPlayers.stream().filter(p -> predicate.test((PlayerEntity)p)).collect(Collectors.toList())).ifPresent(p -> selection.setValue(p));
        }
        if (selection.getValue() == null) {
            CollectionUtils.getRandom(nearbyPlayers).ifPresent(p -> selection.setValue(p));
        }
        return (PlayerEntity)selection.getValue();
    }

    public int getInvulnerableTicks() {
        return (Integer)this.field_70180_af.func_187225_a(DATA_ID_INV);
    }

    public void setInvulnerableTicks(int ticks) {
        this.field_70180_af.func_187227_b(DATA_ID_INV, (Object)ticks);
    }

    public abstract void setupSpawn();

    @Nullable
    protected LivingEntity getRandomThreatTableTarget(double distance) {
        int entityID = this.threat.getRandomThreatEntry(this.field_70170_p, (LivingEntity)this, distance);
        if (entityID == -1) {
            return this.func_70638_az();
        }
        Entity e = this.field_70170_p.func_73045_a(entityID);
        if (e == null || !(e instanceof LivingEntity)) {
            return this.func_70638_az();
        }
        return (LivingEntity)e;
    }

    protected void spawnParticles() {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public class CastSpellAtTargetGoal
    extends Goal {
        private final double moveSpeedAmp;
        private final float maxAttackDistance;
        private final float minAttackDistance;
        private final int attackCooldown;
        private int seeTime;
        private boolean strafingClockwise;
        private boolean strafingBackwards;
        private int strafingTime = -1;
        private ItemStack spell;
        private final int actionId;
        private Predicate<BossMonster<?>> additionalUsePredicate;
        private final boolean randomThreatTarget;
        private LivingEntity target;
        private boolean isWaitingOnAnim = false;
        private final int effectDelayTicks;
        private final int resetTicks;
        private final BiConsumer<String, String> callbackFunction;

        public CastSpellAtTargetGoal(ItemStack spell, double moveSpeedAmpIn, int attackCooldownIn, float maxAttackDistanceIn, float minAttackDistanceIn, boolean randomTargetFromThreatTable, int cooldownId, int delayTicks, int resetTicks, BiConsumer<String, String> resetCallback) {
            this.moveSpeedAmp = moveSpeedAmpIn;
            this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
            this.minAttackDistance = minAttackDistanceIn * minAttackDistanceIn;
            this.spell = spell;
            this.actionId = cooldownId;
            this.attackCooldown = attackCooldownIn;
            this.effectDelayTicks = delayTicks;
            this.resetTicks = resetTicks;
            this.callbackFunction = resetCallback;
            this.randomThreatTarget = randomTargetFromThreatTable;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public CastSpellAtTargetGoal setUsePredicate(Predicate<BossMonster<?>> predicate) {
            this.additionalUsePredicate = predicate;
            return this;
        }

        public boolean func_75250_a() {
            return BossMonster.this.func_70638_az() != null && !BossMonster.this.isOnCooldown(this.actionId) && !BossMonster.this.isOnCooldown(1) && BossMonster.this.func_70638_az().func_70068_e((Entity)BossMonster.this) >= (double)this.minAttackDistance && (this.additionalUsePredicate == null || this.additionalUsePredicate.test(BossMonster.this));
        }

        public boolean func_75253_b() {
            if (this.target == null || this.target.func_233643_dh_() || this.target.func_213303_ch().func_72436_e(BossMonster.this.func_213303_ch()) > BossMonster.this.func_233637_b_(Attributes.field_233819_b_)) {
                return false;
            }
            if (!BossMonster.this.isOnCooldown(this.actionId)) {
                return false;
            }
            if (this.isWaitingOnAnim) {
                return true;
            }
            return this.func_75250_a() || !BossMonster.this.func_70661_as().func_75500_f();
        }

        public void func_75249_e() {
            super.func_75249_e();
            this.target = this.randomThreatTarget ? BossMonster.this.getRandomThreatTableTarget(BossMonster.this.func_233637_b_(Attributes.field_233819_b_)) : BossMonster.this.func_70638_az();
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.target = null;
            BossMonster.this.setCooldown(this.actionId, this.attackCooldown);
            this.seeTime = 0;
            this.isWaitingOnAnim = false;
        }

        private void castCallback(String identifier, LivingEntity target) {
            SpellRecipe recipe = SpellRecipe.fromNBT(this.spell.func_77978_p());
            if (!recipe.isValid()) {
                return;
            }
            Vector3d origin = BossMonster.this.func_213303_ch().func_72441_c(0.0, (double)BossMonster.this.func_70047_e(), 0.0);
            Vector3d targetPos = target.func_213303_ch().func_72441_c(0.0, (double)target.func_70047_e(), 0.0);
            Vector3d targetVelocity = target.func_213303_ch().func_178786_a(target.field_70142_S, target.field_70137_T, target.field_70136_U);
            targetVelocity = targetVelocity.func_178786_a(0.0, target.func_110148_a((Attribute)ForgeMod.ENTITY_GRAVITY.get()).func_111126_e(), 0.0);
            if (target.func_233570_aj_()) {
                targetVelocity = targetVelocity.func_72441_c(0.0, -targetVelocity.field_72448_b, 0.0);
            }
            double distance = origin.func_72438_d(targetPos);
            double speed = ((ModifiedSpellPart)recipe.getShape()).getValue(com.ma.api.spells.attributes.Attribute.SPEED);
            int ticksToArrive = (int)Math.round(distance / speed);
            Vector3d adjustedTargetPos = targetPos.func_178787_e(targetVelocity.func_186678_a((double)ticksToArrive));
            Vector3d delta = adjustedTargetPos.func_178788_d(origin).func_72432_b();
            SpellCaster.Affect(this.spell, SpellRecipe.fromNBT(this.spell.func_77978_p()), BossMonster.this.field_70170_p, new SpellSource((LivingEntity)BossMonster.this, Hand.MAIN_HAND, origin, delta));
            this.func_75251_c();
        }

        public void func_75246_d() {
            if (this.target == null) {
                this.func_75251_c();
                return;
            }
            if (this.isWaitingOnAnim) {
                return;
            }
            LivingEntity livingentity = BossMonster.this.func_70638_az();
            if (livingentity != null) {
                boolean positiveSeeTime;
                double d0 = BossMonster.this.func_70092_e(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_());
                boolean canSee = BossMonster.this.func_70635_at().func_75522_a((Entity)livingentity);
                boolean bl = positiveSeeTime = this.seeTime > 0;
                if (canSee != positiveSeeTime) {
                    this.seeTime = 0;
                }
                this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
                if (!(d0 > (double)this.maxAttackDistance) && this.seeTime >= 20) {
                    BossMonster.this.func_70661_as().func_75499_g();
                    ++this.strafingTime;
                } else {
                    BossMonster.this.func_70661_as().func_75497_a((Entity)livingentity, this.moveSpeedAmp);
                    this.strafingTime = -1;
                }
                if (this.strafingTime >= 20) {
                    if ((double)BossMonster.this.func_70681_au().nextFloat() < 0.3) {
                        boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                    }
                    if ((double)BossMonster.this.func_70681_au().nextFloat() < 0.3) {
                        this.strafingBackwards = !this.strafingBackwards;
                    }
                    this.strafingTime = 0;
                }
                if (this.strafingTime > -1) {
                    if (d0 > (double)(this.maxAttackDistance * 0.75f)) {
                        this.strafingBackwards = false;
                    } else if (d0 < (double)(this.maxAttackDistance * 0.25f)) {
                        this.strafingBackwards = true;
                    }
                    BossMonster.this.func_70605_aq().func_188488_a(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                    BossMonster.this.func_70625_a((Entity)livingentity, 30.0f, 30.0f);
                } else {
                    BossMonster.this.func_70671_ap().func_75651_a((Entity)livingentity, 30.0f, 30.0f);
                }
                if (!canSee && this.seeTime < -60) {
                    this.func_75251_c();
                } else if (canSee) {
                    DelayedEventQueue.pushEvent(BossMonster.this.field_70170_p, new TimedDelayedEvent<LivingEntity>("cast", this.effectDelayTicks, livingentity, this::castCallback));
                    DelayedEventQueue.pushEvent(BossMonster.this.field_70170_p, new TimedDelayedEvent<String>("resetAttack", this.resetTicks, "", this.callbackFunction));
                    BossMonster.this.updateState(1, this.actionId);
                    this.isWaitingOnAnim = true;
                }
            }
        }
    }

    public class ThreatTableHurtByTargetGoal
    extends TargetGoal {
        private boolean alertSameType;
        private int timestamp;
        private final Class<?>[] toIgnoreDamage;
        private Class<?>[] toIgnoreAlert;

        public ThreatTableHurtByTargetGoal(CreatureEntity owner, Class<?> ... ignoreDamageFrom) {
            super((MobEntity)owner, true);
            this.toIgnoreDamage = ignoreDamageFrom;
            this.func_220684_a(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean func_75250_a() {
            int i = this.field_75299_d.func_142015_aE();
            LivingEntity livingentity = this.field_75299_d.func_70643_av();
            if (i != this.timestamp && livingentity != null) {
                if (livingentity.func_200600_R() == EntityType.field_200729_aH && this.field_75299_d.field_70170_p.func_82736_K().func_223586_b(GameRules.field_234896_G_)) {
                    return false;
                }
                for (Class<?> oclass : this.toIgnoreDamage) {
                    if (!oclass.isAssignableFrom(livingentity.getClass())) continue;
                    return false;
                }
                if (this.func_220777_a(livingentity, HURT_BY_TARGETING)) {
                    return BossMonster.this.threat.shouldSwitchTarget(BossMonster.this.func_70638_az(), livingentity);
                }
            }
            return false;
        }

        public ThreatTableHurtByTargetGoal setAlertOthers(Class<?> ... p_220794_1_) {
            this.alertSameType = true;
            this.toIgnoreAlert = p_220794_1_;
            return this;
        }

        public void func_75249_e() {
            this.field_75299_d.func_70624_b(this.field_75299_d.func_70643_av());
            this.field_188509_g = this.field_75299_d.func_70638_az();
            this.timestamp = this.field_75299_d.func_142015_aE();
            this.field_188510_h = 300;
            if (this.alertSameType) {
                this.alertOthers();
            }
            super.func_75249_e();
        }

        protected void alertOthers() {
            double d0 = this.func_111175_f();
            AxisAlignedBB axisalignedbb = AxisAlignedBB.func_241549_a_((Vector3d)this.field_75299_d.func_213303_ch()).func_72314_b(d0, 10.0, d0);
            List list = this.field_75299_d.field_70170_p.func_225317_b(this.field_75299_d.getClass(), axisalignedbb);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                MobEntity mobentity = (MobEntity)iterator.next();
                if (this.field_75299_d == mobentity || mobentity.func_70638_az() != null || this.field_75299_d instanceof TameableEntity && ((TameableEntity)this.field_75299_d).func_70902_q() != ((TameableEntity)mobentity).func_70902_q() || mobentity.func_184191_r((Entity)this.field_75299_d.func_70643_av())) continue;
                if (this.toIgnoreAlert != null) {
                    boolean flag = false;
                    for (Class<?> oclass : this.toIgnoreAlert) {
                        if (mobentity.getClass() != oclass) continue;
                        flag = true;
                        break;
                    }
                    if (flag) continue;
                }
                this.alertOther(mobentity, this.field_75299_d.func_70643_av());
            }
            return;
        }

        protected void alertOther(MobEntity other, LivingEntity target) {
            other.func_70624_b(target);
        }
    }

    class DoNothingGoal
    extends Goal {
        private final int actionId;

        public DoNothingGoal() {
            this(-1);
        }

        public DoNothingGoal(int actionId) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.actionId = actionId;
        }

        public boolean func_75250_a() {
            return this.actionId == -1 ? BossMonster.this.getInvulnerableTicks() > 0 : BossMonster.this.flagSet(this.actionId);
        }
    }
}

