/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.constructs.ai;

import com.ma.entities.constructs.ai.base.ConstructActions;
import com.ma.entities.constructs.ai.base.ConstructCommand;
import com.ma.entities.constructs.animated.EntityAnimatedConstruct;
import com.ma.items.ItemInit;
import com.ma.items.constructs.parts._base.ConstructCapability;
import com.ma.items.runes.ItemRuneMarking;
import java.util.EnumSet;
import net.minecraft.block.BlockState;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;

public class ConstructActivate
extends ConstructCommand {
    private static final int INTERACT_TIME = 20;
    private static final ConstructCapability[] requiredCaps = new ConstructCapability[0];
    private int interactTimer = 20;
    private BlockPos interactPos = null;

    public ConstructActivate(EntityAnimatedConstruct construct) {
        super(construct);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    @Override
    public boolean func_75250_a() {
        if (!super.func_75250_a()) {
            return false;
        }
        if (this.interactPos == null || !this.construct.field_70170_p.func_195588_v(this.interactPos)) {
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.activate_missing", new Object[0]), false);
            return false;
        }
        return true;
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        this.moveBlockTarget = this.interactPos;
        if (this.doMove()) {
            if (this.interactTimer > 0) {
                --this.interactTimer;
            } else {
                BlockState state = this.construct.field_70170_p.func_180495_p(this.interactPos);
                this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.activate_success", this.translate(state), this.interactPos.func_177958_n(), this.interactPos.func_177956_o(), this.interactPos.func_177952_p()), true);
                PlayerEntity player = this.getOrCreatePlayer();
                BlockRayTraceResult brtr = new BlockRayTraceResult(new Vector3d((double)this.interactPos.func_177958_n() + 0.5, (double)this.interactPos.func_177956_o() + 0.5, (double)this.interactPos.func_177952_p() + 0.5), Direction.DOWN, this.interactPos, true);
                state.func_227031_a_(this.construct.field_70170_p, player, Hand.MAIN_HAND, brtr);
                this.interactTimer = 20;
                this.construct.func_184609_a(Math.random() < 0.5 ? Hand.MAIN_HAND : Hand.OFF_HAND);
                this.isFinished = true;
            }
        }
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
        this.interactTimer = 20;
    }

    @Override
    public ConstructActions getType() {
        return ConstructActions.ACTIVATE;
    }

    @Override
    public Inventory createConfigurationInventory() {
        return new Inventory(1);
    }

    @Override
    public ConstructCapability[] requiredCapabilities() {
        return requiredCaps;
    }

    @Override
    public void copyFrom(ConstructCommand other) {
        if (other instanceof ConstructActivate) {
            this.interactPos = ((ConstructActivate)other).interactPos;
        }
    }

    @Override
    public void readNBT(CompoundNBT nbt) {
    }

    @Override
    protected CompoundNBT writeInternal(CompoundNBT nbt) {
        return nbt;
    }

    @Override
    public void getDataFromInventory(Inventory config) {
        ItemStack marker = config.func_70301_a(0);
        if (!marker.func_190926_b() && marker.func_77973_b() == ItemInit.RUNE_MARKING.get()) {
            this.interactPos = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getLocation(marker);
        }
    }

    @Override
    public boolean isFullyConfigured() {
        return this.interactPos != null;
    }
}

