/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.constructs.ai;

import com.ma.entities.constructs.ai.base.ConstructActions;
import com.ma.entities.constructs.ai.base.ConstructCommand;
import com.ma.entities.constructs.animated.EntityAnimatedConstruct;
import com.ma.items.ItemInit;
import com.ma.items.constructs.parts._base.ConstructCapability;
import com.ma.items.runes.ItemRuneMarking;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;

public class ConstructDropItem
extends ConstructCommand {
    private static final int INTERACT_TIME = 20;
    private static final ConstructCapability[] requiredCaps = new ConstructCapability[]{ConstructCapability.CARRY};
    private int interactTimer = 20;
    protected BlockPos blockPos;
    protected Direction side;

    public ConstructDropItem(EntityAnimatedConstruct construct) {
        super(construct);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    @Override
    public boolean func_75250_a() {
        return super.func_75250_a() && this.blockPos != null && this.side != null;
    }

    @Override
    public boolean func_75253_b() {
        return super.func_75253_b() && this.func_75250_a();
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        if (this.construct.getCarryingHands().length == 0) {
            if (!this.isSuccess) {
                this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.drop_item_hands_empty", new Object[0]));
            }
            this.isFinished = true;
            this.construct.field_70714_bg.func_85156_a((Goal)this);
            return;
        }
        this.moveBlockTarget = this.blockPos;
        if (this.doMove()) {
            Hand[] carrying = this.construct.getCarryingHands();
            if (this.interactTimer > 0) {
                if (this.interactTimer == 5 && carrying.length > 0) {
                    this.construct.func_184609_a(carrying[0]);
                }
                --this.interactTimer;
            } else if (this.interactTimer == 0) {
                if (carrying.length == 0) {
                    this.isFinished = true;
                    return;
                }
                String itemTranslated = "";
                Hand hand = carrying[0];
                ItemStack stack = this.construct.func_184586_b(hand);
                ItemEntity item = new ItemEntity(this.construct.field_70170_p, (double)this.blockPos.func_177958_n() + 0.5, (double)this.blockPos.func_177956_o() + 0.5, (double)this.blockPos.func_177952_p() + 0.5, stack.func_77946_l());
                item.func_213293_j(0.0, 0.25, 0.0);
                item.func_174869_p();
                this.construct.field_70170_p.func_217376_c((Entity)item);
                this.construct.func_184611_a(hand, ItemStack.field_190927_a);
                this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.drop_item_success", itemTranslated, this.blockPos.func_177958_n(), this.blockPos.func_177956_o(), this.blockPos.func_177952_p()));
                return;
            }
        }
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
        this.interactTimer = 20;
    }

    @Override
    public ConstructActions getType() {
        return ConstructActions.DROP_ITEM;
    }

    @Override
    public Inventory createConfigurationInventory() {
        return new Inventory(1);
    }

    @Override
    public ConstructCapability[] requiredCapabilities() {
        return requiredCaps;
    }

    @Override
    public void copyFrom(ConstructCommand other) {
        if (other instanceof ConstructDropItem) {
            this.side = ((ConstructDropItem)other).side;
            this.blockPos = ((ConstructDropItem)other).blockPos;
        }
    }

    @Override
    public CompoundNBT writeInternal(CompoundNBT nbt) {
        if (this.blockPos != null) {
            nbt.func_218657_a("blockPos", (INBT)NBTUtil.func_186859_a((BlockPos)this.blockPos));
        }
        if (this.side != null) {
            nbt.func_74768_a("direction", this.side.func_176745_a());
        }
        return nbt;
    }

    @Override
    public void readNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("blockPos")) {
            this.blockPos = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("blockPos"));
        }
        if (nbt.func_74764_b("direction")) {
            this.side = Direction.func_82600_a((int)nbt.func_74762_e("direction"));
        }
    }

    @Override
    public void getDataFromInventory(Inventory config) {
        ItemStack marker = config.func_70301_a(0);
        if (!marker.func_190926_b() && marker.func_77973_b() == ItemInit.RUNE_MARKING.get()) {
            this.blockPos = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getLocation(marker);
            this.side = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getFace(marker);
        }
    }

    @Override
    public boolean isFullyConfigured() {
        return this.blockPos != null && this.side != null;
    }
}

