/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.constructs.ai;

import com.ma.entities.constructs.ai.base.ConstructActions;
import com.ma.entities.constructs.ai.base.ConstructCommandTileEntityInteract;
import com.ma.entities.constructs.animated.EntityAnimatedConstruct;
import com.ma.items.constructs.parts._base.ConstructCapability;
import com.ma.tools.InventoryUtilities;
import java.util.EnumSet;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ConstructPlaceItem
extends ConstructCommandTileEntityInteract<TileEntity> {
    private static final int INTERACT_TIME = 20;
    private static final ConstructCapability[] requiredCaps = new ConstructCapability[]{ConstructCapability.CARRY};
    private int interactTimer = 20;

    public ConstructPlaceItem(EntityAnimatedConstruct construct) {
        super(construct, TileEntity.class);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    @Override
    public boolean func_75250_a() {
        return super.func_75250_a();
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        if (this.construct.getCarryingHands().length == 0) {
            if (this.interactTimer >= 20) {
                ++this.interactTimer;
                if (this.interactTimer >= 36) {
                    this.isFinished = true;
                    this.construct.field_70714_bg.func_85156_a((Goal)this);
                }
            } else {
                this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.place_hands_empty", this.translate((TileEntity)this.getTileEntity())));
                this.isFinished = true;
                this.construct.field_70714_bg.func_85156_a((Goal)this);
            }
            return;
        }
        if (this.getTileEntity() != null) {
            LazyOptional handler = this.getTileEntity().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.side);
            if (handler.isPresent()) {
                if (this.doMove()) {
                    Hand[] carrying = this.construct.getCarryingHands();
                    if (this.interactTimer > 0) {
                        if (this.interactTimer == 5 && carrying.length > 0) {
                            this.construct.func_184609_a(carrying[0]);
                        }
                        --this.interactTimer;
                    } else if (this.interactTimer == 0) {
                        if (carrying.length == 0) {
                            this.interactTimer = -1;
                        } else {
                            this.preInteract();
                            ItemStack stack = this.construct.func_184586_b(carrying[0]);
                            String stackTranslated = this.translate(stack);
                            String containerTranslated = this.translate((TileEntity)this.getTileEntity());
                            if (InventoryUtilities.mergeIntoInventory((IItemHandler)handler.resolve().get(), stack)) {
                                this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.place_success", stackTranslated, containerTranslated));
                                this.construct.func_184611_a(carrying[0], ItemStack.field_190927_a);
                            } else {
                                this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.place_fail", stackTranslated, containerTranslated));
                                this.isFinished = true;
                            }
                            this.interactTimer = 20;
                        }
                    }
                }
            } else {
                this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.inv_missing_cap", this.translate((TileEntity)this.getTileEntity())));
            }
        }
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
        this.interactTimer = 20;
    }

    @Override
    public ConstructActions getType() {
        return ConstructActions.PLACE_ITEM;
    }

    @Override
    public Inventory createConfigurationInventory() {
        return new Inventory(1);
    }

    @Override
    public ConstructCapability[] requiredCapabilities() {
        return requiredCaps;
    }
}

