/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.faction;

import com.ma.api.affinity.Affinity;
import com.ma.api.capabilities.Faction;
import com.ma.api.entities.IFactionEnemy;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.api.spells.DamageTypes;
import com.ma.api.spells.attributes.Attribute;
import com.ma.effects.EffectInit;
import com.ma.entities.ai.CastSpellOnSelfGoal;
import com.ma.entities.ai.FactionTierWrapperGoal;
import com.ma.entities.ai.RetaliateOnAttackGoal;
import com.ma.items.ItemInit;
import com.ma.network.ServerMessageDispatcher;
import com.ma.spells.SpellsInit;
import com.ma.spells.crafting.SpellRecipe;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityPixie
extends FlyingEntity
implements IFactionEnemy<EntityPixie>,
IMob,
IEntityAdditionalSpawnData {
    private static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(EntityPixie.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> AFFINITY = EntityDataManager.func_187226_a(EntityPixie.class, (IDataSerializer)DataSerializers.field_187192_b);
    private PlayerEntity raidTarget;
    private int tier;
    private HashMap<String, Integer> damageResists;

    public EntityPixie(EntityType<? extends FlyingEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_189654_d(true);
        this.field_70765_h = new MoveHelperController(this);
        this.damageResists = new HashMap();
    }

    public static boolean canSpawnPredicate(EntityType<EntityPixie> type, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return worldIn.func_175659_aa() != Difficulty.PEACEFUL && MonsterEntity.func_223323_a((IServerWorld)worldIn, (BlockPos)pos, (Random)randomIn) && EntityPixie.func_223315_a(type, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (!this.field_70170_p.field_72995_K) {
            this.pickRandomAffinity();
        }
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        this.applyInitialSpawnTier((IWorld)worldIn);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean func_70104_M() {
        return false;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SFX.Entity.Pixie.HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SFX.Entity.Pixie.DEATH;
    }

    public void func_70623_bb() {
        super.func_70623_bb();
        this.raidTargetDespawn();
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K && this.field_70170_p.func_73046_m() != null && this.field_70170_p.func_73046_m().func_240793_aU_().func_176130_y() == Difficulty.PEACEFUL) {
            this.remove(false);
        }
    }

    @Override
    public Faction getFaction() {
        return Faction.FEY_COURT;
    }

    @Override
    public PlayerEntity getRaidTarget() {
        return this.raidTarget;
    }

    @Override
    public HashMap<String, Integer> getDamageResists() {
        return this.damageResists;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        amount = this.applyDamageResists(source, amount);
        return super.func_70097_a(source, amount);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        this.onKilled(cause);
    }

    @Override
    public void setRaidTarget(PlayerEntity player) {
        this.raidTarget = player;
        this.func_70624_b((LivingEntity)player);
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public void setTier(int tier) {
        this.tier = tier;
        this.func_110148_a(Attributes.field_233818_a_).func_233769_c_(new AttributeModifier("tier_health_bonus", (double)(tier + 1), AttributeModifier.Operation.MULTIPLY_BASE));
        this.func_110148_a(Attributes.field_233826_i_).func_233769_c_(new AttributeModifier("tier_armor_bonus", (double)(5 * tier), AttributeModifier.Operation.ADDITION));
        this.func_70606_j(this.func_110138_aP());
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        this.writeFactionData(compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.readFactionData(compound);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACKING, (Object)false);
        this.field_70180_af.func_187214_a(AFFINITY, (Object)Affinity.WIND.ordinal());
    }

    public boolean isAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.field_70180_af.func_187227_b(ATTACKING, (Object)attacking);
    }

    public Affinity getAffinity() {
        return Affinity.values()[(Integer)this.field_70180_af.func_187225_a(AFFINITY)];
    }

    private void pickRandomAffinity() {
        Affinity[] validAffinities = new Affinity[]{Affinity.FIRE, Affinity.EARTH, Affinity.WATER, Affinity.WIND};
        this.field_70180_af.func_187227_b(AFFINITY, (Object)validAffinities[(int)(Math.random() * (double)validAffinities.length)].ordinal());
    }

    protected void func_82167_n(Entity entityIn) {
    }

    protected void func_85033_bc() {
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(5, (Goal)new PixieFlyGoal(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new FactionTierWrapperGoal(2, this, new CastSpellOnSelfGoal<EntityPixie>(this, this.createBlinkSpell(), pix -> pix.func_70638_az() != null && pix.func_70638_az().func_70068_e((Entity)pix) < 16.0)));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAroundGoal(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new BoltAttackGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new RetaliateOnAttackGoal((MobEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, this::factionTargetPlayerPredicate));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 10, true, false, this::factionTargetHelpPredicate));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 10, true, false, e -> e instanceof IFactionEnemy && ((IFactionEnemy)e).getFaction() != this.getFaction()));
    }

    private ItemStack createBlinkSpell() {
        ItemStack invisSpell = new ItemStack((IItemProvider)ItemInit.SPELL.get());
        SpellRecipe invis = new SpellRecipe();
        invis.setShape(SpellsInit.SELF);
        invis.addComponent(SpellsInit.BLINK);
        invis.changeComponentAttributeValue(0, Attribute.RANGE, 12.0f);
        invis.writeToNBT(invisSpell.func_196082_o());
        return invisSpell;
    }

    public static AttributeModifierMap.MutableAttribute getGlobalAttributes() {
        return FlyingEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 5.0).func_233815_a_(Attributes.field_233821_d_, (double)0.45f).func_233815_a_(Attributes.field_233823_f_, 1.0).func_233815_a_(Attributes.field_233825_h_, 40.0).func_233815_a_(Attributes.field_233819_b_, 32.0).func_233815_a_(Attributes.field_233824_g_, 1.0).func_233815_a_(Attributes.field_233820_c_, 0.0);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.tier = additionalData.readInt();
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeInt(this.tier);
    }

    static class PixieFlyGoal
    extends Goal {
        private final EntityPixie parentEntity;

        public PixieFlyGoal(EntityPixie pixie) {
            this.parentEntity = pixie;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            MovementController movementcontroller = this.parentEntity.func_70605_aq();
            if (!movementcontroller.func_75640_a()) {
                return true;
            }
            if (this.parentEntity.func_70638_az() == null) {
                double d2;
                double d1;
                double d0 = movementcontroller.func_179917_d() - this.parentEntity.func_226277_ct_();
                double d3 = d0 * d0 + (d1 = movementcontroller.func_179919_e() - this.parentEntity.func_226278_cu_()) * d1 + (d2 = movementcontroller.func_179918_f() - this.parentEntity.func_226281_cx_()) * d2;
                return d3 < 4.0 || d3 > 3600.0;
            }
            double dist = this.parentEntity.func_70638_az().func_70068_e((Entity)this.parentEntity);
            return !this.parentEntity.func_70685_l((Entity)this.parentEntity.func_70638_az()) || dist > 25.0 || dist < 4.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            if (this.parentEntity.func_70638_az() == null) {
                Random random = this.parentEntity.func_70681_au();
                double d0 = this.parentEntity.func_226277_ct_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double d1 = this.parentEntity.func_226278_cu_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double d2 = this.parentEntity.func_226281_cx_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                int count = 0;
                int y = (int)d1;
                boolean ground = false;
                while (count < 16) {
                    if (this.parentEntity.field_70170_p.func_175623_d(new BlockPos(d0, (double)y, d2))) {
                        ++count;
                        --y;
                        continue;
                    }
                    ground = true;
                    break;
                }
                if (!ground) {
                    d1 -= 16.0;
                }
                this.parentEntity.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
            } else {
                Vector3d direction = this.parentEntity.func_213303_ch().func_178788_d(this.parentEntity.func_70638_az().func_213303_ch()).func_72432_b();
                direction = direction.func_72441_c(0.0, -direction.field_72448_b, 0.0);
                Vector3d offset = direction.func_186678_a(10.0);
                Vector3d target = this.parentEntity.func_70638_az().func_213303_ch().func_178787_e(offset).func_72441_c(0.0, 3.0, 0.0);
                this.parentEntity.func_70605_aq().func_75642_a(target.field_72450_a, target.field_72448_b, target.field_72449_c, 1.0);
            }
        }
    }

    static class BoltAttackGoal
    extends Goal {
        private final EntityPixie parentEntity;
        public int attackTimer;

        public BoltAttackGoal(EntityPixie pixie) {
            this.parentEntity = pixie;
        }

        public boolean func_75250_a() {
            return this.parentEntity.func_70638_az() != null;
        }

        public void func_75249_e() {
            this.attackTimer = 0;
        }

        public void func_75251_c() {
            this.parentEntity.setAttacking(false);
        }

        public boolean func_75253_b() {
            return this.parentEntity.func_70638_az() != null && this.parentEntity.func_70638_az().func_70089_S();
        }

        public void func_75246_d() {
            LivingEntity livingentity = this.parentEntity.func_70638_az();
            if (livingentity == null) {
                return;
            }
            if (livingentity.func_70068_e((Entity)this.parentEntity) < 144.0 && this.parentEntity.func_70685_l((Entity)livingentity)) {
                ++this.attackTimer;
                if (this.attackTimer != 10 || !this.parentEntity.func_174814_R()) {
                    // empty if block
                }
                if (this.attackTimer >= 60) {
                    if (!this.parentEntity.func_174814_R()) {
                        this.parentEntity.func_184185_a(SFX.Entity.Pixie.ATTACK, 1.0f, (float)((double)0.9f + Math.random() * (double)0.2f));
                    }
                    boolean isMiss = Math.random() > (double)(0.3f + (float)this.parentEntity.getTier() * 0.5f);
                    Vector3d offset = new Vector3d(0.0, 0.0, 0.0);
                    if (isMiss) {
                        offset = new Vector3d(Math.random() - 0.5, Math.random() - 0.5, Math.random() * 0.5);
                    }
                    ServerMessageDispatcher.sendParticleSpawn(this.parentEntity.func_226277_ct_(), this.parentEntity.func_226278_cu_(), this.parentEntity.func_226281_cx_(), this.parentEntity.func_70638_az().func_226277_ct_() + offset.func_82615_a(), this.parentEntity.func_70638_az().func_226278_cu_() + (double)this.parentEntity.func_70638_az().func_70047_e() + offset.func_82617_b(), this.parentEntity.func_70638_az().func_226281_cx_() + offset.func_82616_c(), 64.0f, (RegistryKey<World>)this.parentEntity.field_70170_p.func_234923_W_(), (MAParticleType)ParticleInit.LIGHTNING_BOLT.get());
                    if (!isMiss) {
                        switch (this.parentEntity.getAffinity()) {
                            case EARTH: {
                                this.applyEarthEffect();
                                break;
                            }
                            case WATER: {
                                this.applyWaterEffect();
                                break;
                            }
                            case FIRE: {
                                this.applyFireEffect();
                                break;
                            }
                            default: {
                                this.applyAirEffect();
                            }
                        }
                    }
                    this.attackTimer = 0;
                }
            } else if (this.attackTimer > 0) {
                --this.attackTimer;
            }
            this.parentEntity.setAttacking(this.attackTimer > 10);
        }

        private void applyAirEffect() {
            LivingEntity tgt = this.parentEntity.func_70638_az();
            if (tgt.func_233570_aj_()) {
                tgt.func_70024_g((double)-0.2f + Math.random() * (double)0.4f, 1.0, (double)-0.2f + Math.random() * (double)0.4f);
                if (tgt instanceof PlayerEntity) {
                    ((ServerPlayerEntity)tgt).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)tgt));
                }
            }
        }

        private void applyWaterEffect() {
            if (this.parentEntity.func_70638_az().func_70090_H()) {
                this.parentEntity.func_70638_az().func_195064_c(new EffectInstance((Effect)EffectInit.WATERY_GRAVE.get(), 10));
            } else {
                this.parentEntity.func_70638_az().func_195064_c(new EffectInstance(Effects.field_76421_d, 20, 2));
            }
            this.parentEntity.func_70638_az().func_70097_a(DamageTypes.causeSourcedFrostDamage((LivingEntity)this.parentEntity), (float)(2 * this.parentEntity.getTier()));
        }

        private void applyEarthEffect() {
            if (!this.parentEntity.func_70638_az().func_233570_aj_() && this.parentEntity.func_70638_az().func_70660_b((Effect)EffectInit.GRAVITY_WELL.get()) == null) {
                this.parentEntity.func_70638_az().func_195064_c(new EffectInstance((Effect)EffectInit.GRAVITY_WELL.get(), 100));
            } else {
                this.parentEntity.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this.parentEntity), 4.0f);
            }
        }

        private void applyFireEffect() {
            this.parentEntity.func_70638_az().func_195064_c(new EffectInstance(Effects.field_76437_t, 100));
            if (this.parentEntity.func_70638_az() instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)this.parentEntity.func_70638_az();
                player.func_184193_aE().forEach(stack -> stack.func_222118_a(5, (LivingEntity)player, item -> {}));
            }
        }
    }

    static class LookAroundGoal
    extends Goal {
        private final EntityPixie parentEntity;

        public LookAroundGoal(EntityPixie ghast) {
            this.parentEntity = ghast;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.parentEntity.func_70638_az() == null) {
                Vector3d vector3d = this.parentEntity.func_213322_ci();
                this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)vector3d.field_72450_a, (double)vector3d.field_72449_c)) * 57.295776f;
            } else {
                LivingEntity livingentity = this.parentEntity.func_70638_az();
                if (livingentity.func_70068_e((Entity)this.parentEntity) < 4096.0) {
                    double d1 = livingentity.func_226277_ct_() - this.parentEntity.func_226277_ct_();
                    double d2 = livingentity.func_226281_cx_() - this.parentEntity.func_226281_cx_();
                    this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)d1, (double)d2)) * 57.295776f;
                }
            }
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final EntityPixie parentEntity;
        private int courseChangeCooldown;

        public MoveHelperController(EntityPixie pixie) {
            super((MobEntity)pixie);
            this.parentEntity = pixie;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO && this.courseChangeCooldown-- <= 0) {
                this.courseChangeCooldown += this.parentEntity.func_70681_au().nextInt(5) + 2;
                Vector3d vector3d = new Vector3d(this.field_75646_b - this.parentEntity.func_226277_ct_(), this.field_75647_c - this.parentEntity.func_226278_cu_(), this.field_75644_d - this.parentEntity.func_226281_cx_());
                double d0 = vector3d.func_72433_c();
                if (this.isCollided(vector3d = vector3d.func_72432_b(), MathHelper.func_76143_f((double)d0))) {
                    this.parentEntity.func_213317_d(this.parentEntity.func_213322_ci().func_178787_e(vector3d.func_186678_a(0.1)));
                } else {
                    this.field_188491_h = MovementController.Action.WAIT;
                }
            }
        }

        private boolean isCollided(Vector3d p_220673_1_, int p_220673_2_) {
            AxisAlignedBB axisalignedbb = this.parentEntity.func_174813_aQ();
            for (int i = 1; i < p_220673_2_; ++i) {
                if (this.parentEntity.field_70170_p.func_226665_a__((Entity)this.parentEntity, axisalignedbb = axisalignedbb.func_191194_a(p_220673_1_))) continue;
                return false;
            }
            return true;
        }
    }
}

