/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.faction;

import com.ma.api.capabilities.Faction;
import com.ma.api.entities.IFactionEnemy;
import com.ma.api.sound.SFX;
import com.ma.effects.EffectInit;
import com.ma.entities.EntityInit;
import com.ma.entities.IAnimPacketSync;
import com.ma.entities.ai.AIPredicateWrapperGoal;
import com.ma.entities.ai.FactionTierWrapperGoal;
import com.ma.entities.projectile.EntitySkeletonAssassinBolo;
import com.ma.entities.projectile.EntitySkeletonAssassinShuriken;
import com.ma.events.delayed.DelayedEventQueue;
import com.ma.events.delayed.TimedDelayedEvent;
import com.ma.network.ServerMessageDispatcher;
import com.ma.tools.math.Vector3;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FleeSunGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.CustomInstructionKeyframeEvent;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EntitySkeletonAssassin
extends MonsterEntity
implements IAnimatable,
AnimationController.ICustomInstructionListener,
IAnimPacketSync<EntitySkeletonAssassin>,
IFactionEnemy<EntitySkeletonAssassin>,
IEntityAdditionalSpawnData,
IRangedAttackMob {
    private static final String INSTRUCTION_DAMAGE = "damage";
    private static final String INSTRUCTION_BOLO = "bolo";
    private static final String INSTRUCTION_SMOKEBOMB = "smokebomb";
    private static final String INSTRUCTION_BACKFLIP = "backflip";
    private static final int COOLDOWN_BOLO = 300;
    private static final int COOLDOWN_BACKFLIP = 100;
    private static final int COOLDOWN_SMOKEBOMB = 1200;
    private AnimationFactory animFactory = new AnimationFactory((IAnimatable)this);
    private boolean isActing = false;
    private boolean isMeleeAttacking = false;
    private boolean throwingShuriken = false;
    private boolean smokeBomb = false;
    private boolean throwingBolo = false;
    private boolean backflipping = false;
    private int boloCooldown = 0;
    private int backflipCooldown = 0;
    private int smokeBombCooldown = 0;
    private boolean instantTransition = false;
    private PlayerEntity raidTarget;
    private int tier;
    private HashMap<String, Integer> damageResists = new HashMap();

    public EntitySkeletonAssassin(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.2f;
    }

    public EntitySkeletonAssassin(World worldIn) {
        this((EntityType<? extends MonsterEntity>)((EntityType)EntityInit.SKELETON_ASSASSIN.get()), worldIn);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        this.applyInitialSpawnTier((IWorld)worldIn);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public static boolean canSpawnPredicate(EntityType<EntitySkeletonAssassin> p_234351_0_, IWorld p_234351_1_, SpawnReason p_234351_2_, BlockPos p_234351_3_, Random p_234351_4_) {
        if (p_234351_1_ instanceof IServerWorld) {
            return p_234351_3_.func_177956_o() <= 60 && MonsterEntity.func_223325_c(p_234351_0_, (IServerWorld)((IServerWorld)p_234351_1_), (SpawnReason)p_234351_2_, (BlockPos)p_234351_3_, (Random)p_234351_4_);
        }
        return false;
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate);
        controller.registerCustomInstructionListener((AnimationController.ICustomInstructionListener)this);
        data.addAnimationController(controller);
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.instantTransition) {
            event.getController().transitionLengthTicks = 0.0;
            this.instantTransition = false;
        } else {
            event.getController().transitionLengthTicks = 5.0;
        }
        if (!this.isActing) {
            if (this.func_213322_ci().func_72441_c(0.0, -this.func_213322_ci().field_72448_b, 0.0).func_72433_c() > (double)0.02f) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.skeleton_assassin.run", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.skeleton_assassin.idle", Boolean.valueOf(true)));
            }
        } else if (this.throwingShuriken) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.skeleton_assassin.quick_throw", Boolean.valueOf(false)));
        } else if (this.smokeBomb) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.skeleton_assassin.smoke_bomb", Boolean.valueOf(false)));
        } else if (this.throwingBolo) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.skeleton_assassin.outerhand_throw", Boolean.valueOf(false)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.skeleton_assassin.slash", Boolean.valueOf(false)));
        }
        return PlayState.CONTINUE;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.boloCooldown > 0) {
            --this.boloCooldown;
        }
        if (this.backflipCooldown > 0) {
            --this.backflipCooldown;
        }
        if (this.smokeBombCooldown > 0) {
            --this.smokeBombCooldown;
        }
        if (this.func_70089_S() && this.func_204609_dp()) {
            this.func_70015_d(8);
        }
    }

    @Override
    public Faction getFaction() {
        return Faction.UNDEAD;
    }

    @Override
    public void setRaidTarget(PlayerEntity player) {
        this.raidTarget = player;
        this.func_70624_b((LivingEntity)player);
    }

    @Override
    public PlayerEntity getRaidTarget() {
        return this.raidTarget;
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public void setTier(int tier) {
        this.tier = tier;
        this.func_110148_a(Attributes.field_233818_a_).func_233769_c_(new AttributeModifier("tier_health_bonus", (double)(tier + 1), AttributeModifier.Operation.MULTIPLY_BASE));
        this.func_110148_a(Attributes.field_233826_i_).func_233769_c_(new AttributeModifier("tier_armor_bonus", (double)(5 * tier), AttributeModifier.Operation.ADDITION));
        this.func_70606_j(this.func_110138_aP());
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        this.writeFactionData(compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.readFactionData(compound);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, new AIPredicateWrapperGoal<EntitySkeletonAssassin>(this, (Goal)new MeleeAttackGoal((CreatureEntity)this, this.func_233637_b_(Attributes.field_233821_d_), false)).executionPredicate(me -> me.func_70638_az() != null && me.func_70638_az().func_70089_S() && me.func_82150_aj()));
        this.field_70714_bg.func_75776_a(2, (Goal)new FleeSunGoal((CreatureEntity)this, this.func_233637_b_(Attributes.field_233821_d_)));
        this.field_70714_bg.func_75776_a(3, (Goal)new FactionTierWrapperGoal(2, this, new SmokeBombGoal()));
        this.field_70714_bg.func_75776_a(4, (Goal)new FactionTierWrapperGoal(1, this, new BoloGoal(this, this.func_233637_b_(Attributes.field_233821_d_), 20, 15, 24.0f)));
        this.field_70714_bg.func_75776_a(5, (Goal)new ShootGoal(this, this.func_233637_b_(Attributes.field_233821_d_), 20, 15, 12.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new MeleeAttackGoal((CreatureEntity)this, this.func_233637_b_(Attributes.field_233821_d_), false));
        this.field_70714_bg.func_75776_a(7, (Goal)new RandomWalkingGoal((CreatureEntity)this, (double)0.35f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, this::factionTargetPlayerPredicate));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 10, true, false, this::factionTargetHelpPredicate));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 10, true, false, e -> e instanceof IFactionEnemy && ((IFactionEnemy)e).getFaction() != this.getFaction()));
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        if (this.isActing) {
            return;
        }
        DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<LivingEntity>(INSTRUCTION_DAMAGE, 2, target, this::handleDelayCallback));
        DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<String>("resetattack", 10, "", this::handleDelayCallback));
        this.isActing = true;
        this.throwingShuriken = true;
        ServerMessageDispatcher.sendEntityStateMessage(this);
    }

    private void throwBolo(LivingEntity target, float distanceFactor) {
        if (this.isActing) {
            return;
        }
        DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<LivingEntity>(INSTRUCTION_BOLO, 17, target, this::handleDelayCallback));
        DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<String>("resetattack", 22, "", this::handleDelayCallback));
        this.isActing = true;
        this.throwingBolo = true;
        ServerMessageDispatcher.sendEntityStateMessage(this);
    }

    private void throwSmokeBomb() {
        if (this.isActing) {
            return;
        }
        DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<LivingEntity>(INSTRUCTION_SMOKEBOMB, 28, (LivingEntity)this, this::handleDelayCallback));
        DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<String>("resetattack", 30, "", this::handleDelayCallback));
        this.isActing = true;
        this.smokeBomb = true;
        ServerMessageDispatcher.sendEntityStateMessage(this);
    }

    private void doBackflip() {
        if (this.isActing) {
            return;
        }
        DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<LivingEntity>(INSTRUCTION_BACKFLIP, 31, (LivingEntity)this, this::handleDelayCallback));
        DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<String>("resetattack", 32, "", this::handleDelayCallback));
        this.isActing = true;
        this.backflipping = true;
        ServerMessageDispatcher.sendEntityStateMessage(this);
    }

    public boolean spawnShuriken(Entity target) {
        Vector3d direction = target == this ? Vector3d.func_189984_a((Vector2f)this.func_189653_aC()).func_72432_b() : target.func_213303_ch().func_72441_c(0.0, (double)(target.func_213302_cg() * 0.5f), 0.0).func_178788_d(this.func_213303_ch()).func_72432_b();
        EntitySkeletonAssassinShuriken shuriken = new EntitySkeletonAssassinShuriken(this.field_70170_p, (LivingEntity)this);
        shuriken.func_212361_a((Entity)this);
        shuriken.func_70186_c(direction.field_72450_a, direction.field_72448_b, direction.field_72449_c, 1.6f, 0.0f);
        this.field_70170_p.func_217376_c((Entity)shuriken);
        this.func_184185_a(SFX.Entity.SkeletonAssassin.SHURIKEN_THROW, 1.0f, (float)(0.9 + Math.random() * 0.2));
        return true;
    }

    public boolean spawnBolo(Entity target) {
        Vector3d direction = target.func_213303_ch().func_178787_e(target.func_213322_ci()).func_72441_c(0.0, (double)(target.func_213302_cg() * 0.5f), 0.0).func_178788_d(this.func_213303_ch()).func_72432_b();
        EntitySkeletonAssassinBolo bolo = new EntitySkeletonAssassinBolo(this.field_70170_p, (LivingEntity)this);
        bolo.func_212361_a((Entity)this);
        bolo.func_70186_c(direction.field_72450_a, direction.field_72448_b, direction.field_72449_c, 2.5f, 0.0f);
        this.field_70170_p.func_217376_c((Entity)bolo);
        this.func_184185_a(SFX.Entity.SkeletonAssassin.BOLO_THROW, 1.0f, (float)(0.9 + Math.random() * 0.2));
        return true;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
    }

    @Override
    public HashMap<String, Integer> getDamageResists() {
        return this.damageResists;
    }

    public SoundEvent func_184639_G() {
        return SoundEvents.field_190036_ha;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187856_fd;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187864_fh;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.isActing) {
            return true;
        }
        DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<Entity>(INSTRUCTION_DAMAGE, 10, entityIn, this::handleDelayCallback));
        DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<String>("resetattack", 20, "", this::handleDelayCallback));
        this.isActing = true;
        ServerMessageDispatcher.sendEntityStateMessage(this);
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76379_h) {
            return false;
        }
        if (source.func_76355_l() == "ma-frost") {
            amount *= 0.5f;
        }
        amount = this.applyDamageResists(source, amount);
        return super.func_70097_a(source, amount);
    }

    public boolean damageEntity(Entity entityIn) {
        boolean flag;
        int i;
        if (this.func_70638_az() == null) {
            return false;
        }
        double dist = this.func_70068_e((Entity)this.func_70638_az());
        if (dist > 9.0) {
            return false;
        }
        float f = (float)this.func_233637_b_(Attributes.field_233823_f_);
        float f1 = (float)this.func_233637_b_(Attributes.field_233824_g_);
        if (entityIn instanceof LivingEntity) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (CreatureAttribute)((LivingEntity)entityIn).func_70668_bt());
            f1 += (float)EnchantmentHelper.func_77501_a((LivingEntity)this);
            if (this.func_82150_aj()) {
                if (!((LivingEntity)entityIn).func_70644_a((Effect)EffectInit.ELDRIN_SIGHT.get())) {
                    f *= (float)(this.getTier() + 2);
                }
                this.func_195063_d(Effects.field_76441_p);
            }
        }
        if ((i = EnchantmentHelper.func_90036_a((LivingEntity)this)) > 0 || this.func_70027_ad()) {
            entityIn.func_70015_d(i * 4);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), f)) {
            if (f1 > 0.0f && entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).func_233627_a_(f1 * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
            }
            if (entityIn instanceof PlayerEntity) {
                PlayerEntity playerentity = (PlayerEntity)entityIn;
                this.maybeDisableShield(playerentity, this.func_184614_ca(), playerentity.func_184587_cr() ? playerentity.func_184607_cu() : ItemStack.field_190927_a);
            }
            this.func_174815_a((LivingEntity)this, entityIn);
            this.func_130011_c(entityIn);
        }
        return flag;
    }

    public void func_70623_bb() {
        super.func_70623_bb();
        this.raidTargetDespawn();
    }

    private void maybeDisableShield(PlayerEntity p_233655_1_, ItemStack p_233655_2_, ItemStack p_233655_3_) {
        if (!p_233655_2_.func_190926_b() && !p_233655_3_.func_190926_b() && p_233655_2_.func_77973_b() instanceof AxeItem && p_233655_3_.func_77973_b() == Items.field_185159_cQ) {
            float f = 0.25f + (float)EnchantmentHelper.func_185293_e((LivingEntity)this) * 0.05f;
            if (this.field_70146_Z.nextFloat() < f) {
                p_233655_1_.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                this.field_70170_p.func_72960_a((Entity)p_233655_1_, (byte)30);
            }
        }
    }

    public AnimationFactory getFactory() {
        return this.animFactory;
    }

    public static AttributeModifierMap.MutableAttribute getGlobalAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 8.0).func_233815_a_(Attributes.field_233821_d_, (double)0.6f).func_233815_a_(Attributes.field_233823_f_, 6.0).func_233815_a_(Attributes.field_233825_h_, 40.0).func_233815_a_(Attributes.field_233824_g_, 1.0).func_233815_a_(Attributes.field_233820_c_, 0.0);
    }

    private void handleDelayCallback(String identifier, Entity entity) {
        if (this.func_70089_S()) {
            if (!this.field_70170_p.field_72995_K) {
                switch (identifier) {
                    case "damage": {
                        if (this.throwingShuriken) {
                            this.spawnShuriken(entity);
                            break;
                        }
                        this.damageEntity(entity);
                        break;
                    }
                    case "bolo": {
                        this.spawnBolo(entity);
                        this.boloCooldown = 300;
                        break;
                    }
                    case "smokebomb": {
                        this.func_195064_c(new EffectInstance(Effects.field_76441_p, 200));
                        this.func_184185_a(SFX.Entity.SkeletonAssassin.SMOKE_BOMB, 1.0f, (float)(0.8 + Math.random() * 0.2));
                        this.smokeBombCooldown = 1200;
                        break;
                    }
                    case "backflip": {
                        this.backflipCooldown = 100;
                    }
                }
            } else {
                switch (identifier) {
                    case "smokebomb": {
                        for (int i = 0; i < 50; ++i) {
                            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218417_ae, this.func_226277_ct_() - 0.25 + Math.random() * 0.5, this.func_226278_cu_() + Math.random() * 2.0, this.func_226281_cx_() - 0.25 + Math.random() * 0.5, 0.0, 0.0, 0.0);
                        }
                        break;
                    }
                }
            }
        }
    }

    private void handleDelayCallback(String identifier, String data) {
        if (!this.field_70170_p.field_72995_K) {
            boolean wasFlipping = this.backflipping;
            this.isActing = false;
            this.throwingShuriken = false;
            this.throwingBolo = false;
            this.smokeBomb = false;
            this.backflipping = false;
            if (!this.backflipping && wasFlipping) {
                this.instantTransition = true;
            }
            ServerMessageDispatcher.sendEntityStateMessage(this);
        }
    }

    public void executeInstruction(CustomInstructionKeyframeEvent event) {
    }

    @Override
    public CompoundNBT getPacketData() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("attacking", this.isActing);
        nbt.func_74757_a("shuriken", this.throwingShuriken);
        nbt.func_74757_a(INSTRUCTION_BOLO, this.throwingBolo);
        nbt.func_74757_a("smoke", this.smokeBomb);
        nbt.func_74757_a(INSTRUCTION_BACKFLIP, this.backflipping);
        return nbt;
    }

    @Override
    public void handlePacketData(CompoundNBT nbt) {
        this.isActing = nbt.func_74767_n("attacking");
        this.throwingShuriken = nbt.func_74767_n("shuriken");
        this.throwingBolo = nbt.func_74767_n(INSTRUCTION_BOLO);
        this.smokeBomb = nbt.func_74767_n("smoke");
        this.backflipping = nbt.func_74767_n(INSTRUCTION_BACKFLIP);
        if (this.smokeBomb) {
            DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<LivingEntity>(INSTRUCTION_SMOKEBOMB, 22, (LivingEntity)this, this::handleDelayCallback));
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.tier = additionalData.readInt();
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeInt(this.tier);
    }

    public class BackflipGoal
    extends Goal {
        private Vector3 start;
        private Vector3 end;
        private int tick_count;
        private float move_time = 31.0f;

        public boolean func_75250_a() {
            LivingEntity target = EntitySkeletonAssassin.this.func_70638_az();
            if (target != null && !EntitySkeletonAssassin.this.isActing && EntitySkeletonAssassin.this.backflipCooldown == 0) {
                double dist = EntitySkeletonAssassin.this.func_70068_e((Entity)target);
                if (dist > 9.0) {
                    return false;
                }
                Vector3d startPos = EntitySkeletonAssassin.this.func_213303_ch().func_72441_c(0.0, 0.5, 0.0);
                Vector3d delta = startPos.func_178788_d(target.func_213303_ch().func_72441_c(0.0, 0.5, 0.0)).func_72432_b();
                delta = new Vector3d(delta.field_72450_a, 0.0, delta.field_72449_c);
                Vector3d endPos = startPos.func_178787_e(delta.func_186678_a(10.0));
                int count = 0;
                while (!EntitySkeletonAssassin.this.field_70170_p.func_175623_d(new BlockPos(endPos.field_72450_a, endPos.field_72448_b, endPos.field_72449_c)) && count < 10) {
                    ++count;
                    endPos = endPos.func_72441_c(0.0, 1.0, 0.0);
                }
                if (count >= 10) {
                    return false;
                }
                RayTraceContext ctx = new RayTraceContext(startPos, endPos, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)EntitySkeletonAssassin.this);
                BlockRayTraceResult brtr = EntitySkeletonAssassin.this.field_70170_p.func_217299_a(ctx);
                if (brtr.func_216346_c() == RayTraceResult.Type.MISS) {
                    this.start = new Vector3(EntitySkeletonAssassin.this.func_213303_ch());
                    this.end = new Vector3(endPos.func_178786_a(0.0, 0.5, 0.0));
                } else {
                    this.start = new Vector3(EntitySkeletonAssassin.this.func_213303_ch());
                    this.end = new Vector3(brtr.func_216347_e().func_178787_e(delta));
                }
                return this.start != null && this.end != null && !(this.start.distanceSqTo(this.end) < 5.0);
            }
            return false;
        }

        public void func_75249_e() {
            super.func_75249_e();
            EntitySkeletonAssassin.this.doBackflip();
        }

        public boolean func_75253_b() {
            return EntitySkeletonAssassin.this.isActing && EntitySkeletonAssassin.this.backflipping;
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.start = null;
            this.end = null;
            this.tick_count = 0;
        }

        public void func_75246_d() {
            ++this.tick_count;
            if ((float)this.tick_count <= this.move_time) {
                Vector3 interp_pos = Vector3.lerp(this.start, this.end, (float)this.tick_count / this.move_time);
                EntitySkeletonAssassin.this.func_70107_b(interp_pos.x, interp_pos.y, interp_pos.z);
                EntitySkeletonAssassin.this.func_230245_c_(true);
            }
        }
    }

    public class SmokeBombGoal
    extends Goal {
        public SmokeBombGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean func_75250_a() {
            return EntitySkeletonAssassin.this.func_70638_az() != null && !EntitySkeletonAssassin.this.isActing && EntitySkeletonAssassin.this.smokeBombCooldown == 0;
        }

        public boolean func_75253_b() {
            return EntitySkeletonAssassin.this.isActing && EntitySkeletonAssassin.this.throwingBolo;
        }

        public void func_75249_e() {
            EntitySkeletonAssassin.this.throwSmokeBomb();
        }
    }

    public class BoloGoal
    extends Goal {
        private int rangedAttackTime = -1;
        private final int attackIntervalMin;
        private final int maxRangedAttackTime;
        private final float attackRadius;
        private final float maxAttackDistance;

        public BoloGoal(IRangedAttackMob attacker, double movespeed, int maxAttackTime, float maxAttackDistanceIn) {
            this(attacker, movespeed, maxAttackTime, maxAttackTime, maxAttackDistanceIn);
        }

        public BoloGoal(IRangedAttackMob attacker, double movespeed, int p_i1650_4_, int maxAttackTime, float maxAttackDistanceIn) {
            this.attackIntervalMin = p_i1650_4_;
            this.maxRangedAttackTime = maxAttackTime;
            this.attackRadius = maxAttackDistanceIn;
            this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            if (EntitySkeletonAssassin.this.isActing || EntitySkeletonAssassin.this.boloCooldown > 0) {
                return false;
            }
            LivingEntity livingentity = EntitySkeletonAssassin.this.func_70638_az();
            return livingentity != null && livingentity.func_70089_S() && livingentity.func_226278_cu_() > EntitySkeletonAssassin.this.func_226278_cu_() + 2.0 && (livingentity.field_70160_al || !livingentity.func_233570_aj_() || livingentity instanceof PlayerEntity && ((PlayerEntity)livingentity).field_71075_bZ.field_75100_b);
        }

        public boolean func_75253_b() {
            return this.func_75250_a() || !EntitySkeletonAssassin.this.func_70661_as().func_244428_t();
        }

        public void func_75251_c() {
            this.rangedAttackTime = -1;
        }

        public void func_75246_d() {
            LivingEntity e = EntitySkeletonAssassin.this.func_70638_az();
            if (e == null) {
                return;
            }
            double distance = EntitySkeletonAssassin.this.func_70092_e(e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_());
            boolean canSeeTarget = EntitySkeletonAssassin.this.func_70635_at().func_75522_a((Entity)e);
            if (distance <= (double)this.maxAttackDistance && canSeeTarget) {
                EntitySkeletonAssassin.this.func_70661_as().func_75499_g();
            } else {
                EntitySkeletonAssassin.this.func_70661_as().func_75497_a((Entity)e, EntitySkeletonAssassin.this.func_233637_b_(Attributes.field_233821_d_));
            }
            EntitySkeletonAssassin.this.func_70671_ap().func_75651_a((Entity)e, 30.0f, 30.0f);
            if (--this.rangedAttackTime == 0) {
                if (!canSeeTarget) {
                    return;
                }
                float f = MathHelper.func_76133_a((double)distance) / this.attackRadius;
                float lvt_5_1_ = MathHelper.func_76131_a((float)f, (float)0.1f, (float)1.0f);
                EntitySkeletonAssassin.this.throwBolo(e, lvt_5_1_);
                this.rangedAttackTime = MathHelper.func_76141_d((float)(f * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
            } else if (this.rangedAttackTime < 0) {
                float f2 = MathHelper.func_76133_a((double)distance) / this.attackRadius;
                this.rangedAttackTime = MathHelper.func_76141_d((float)(f2 * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
            }
        }
    }

    public class ShootGoal
    extends Goal {
        private int rangedAttackTime = -1;
        private final int attackIntervalMin;
        private final int maxRangedAttackTime;
        private final float attackRadius;
        private final float maxAttackDistance;

        public ShootGoal(IRangedAttackMob attacker, double movespeed, int maxAttackTime, float maxAttackDistanceIn) {
            this(attacker, movespeed, maxAttackTime, maxAttackTime, maxAttackDistanceIn);
        }

        public ShootGoal(IRangedAttackMob attacker, double movespeed, int p_i1650_4_, int maxAttackTime, float maxAttackDistanceIn) {
            this.attackIntervalMin = p_i1650_4_;
            this.maxRangedAttackTime = maxAttackTime;
            this.attackRadius = maxAttackDistanceIn;
            this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = EntitySkeletonAssassin.this.func_70638_az();
            return livingentity != null && livingentity.func_70089_S() && livingentity.func_70068_e((Entity)EntitySkeletonAssassin.this) > 16.0;
        }

        public boolean func_75253_b() {
            return this.func_75250_a() && !EntitySkeletonAssassin.this.func_70661_as().func_244428_t();
        }

        public void func_75251_c() {
            this.rangedAttackTime = -1;
        }

        public void func_75246_d() {
            LivingEntity e = EntitySkeletonAssassin.this.func_70638_az();
            if (e == null) {
                return;
            }
            double distance = EntitySkeletonAssassin.this.func_70092_e(e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_());
            boolean canSeeTarget = EntitySkeletonAssassin.this.func_70635_at().func_75522_a((Entity)e);
            if (distance <= (double)this.maxAttackDistance && canSeeTarget) {
                EntitySkeletonAssassin.this.func_70661_as().func_75499_g();
            } else {
                EntitySkeletonAssassin.this.func_70661_as().func_75497_a((Entity)e, EntitySkeletonAssassin.this.func_233637_b_(Attributes.field_233821_d_));
            }
            EntitySkeletonAssassin.this.func_70671_ap().func_75651_a((Entity)e, 30.0f, 30.0f);
            if (--this.rangedAttackTime == 0 && !EntitySkeletonAssassin.this.isActing) {
                if (!canSeeTarget) {
                    return;
                }
                float f = MathHelper.func_76133_a((double)distance) / this.attackRadius;
                float lvt_5_1_ = MathHelper.func_76131_a((float)f, (float)0.1f, (float)1.0f);
                EntitySkeletonAssassin.this.func_82196_d(e, lvt_5_1_);
                this.rangedAttackTime = MathHelper.func_76141_d((float)(f * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
            } else if (this.rangedAttackTime < 0) {
                float f2 = MathHelper.func_76133_a((double)distance) / this.attackRadius;
                this.rangedAttackTime = MathHelper.func_76141_d((float)(f2 * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
            }
        }
    }
}

