/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.faction;

import com.ma.api.capabilities.Faction;
import com.ma.api.entities.IFactionEnemy;
import com.ma.api.entities.ISpellInteractibleEntity;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Shape;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.effects.EffectInit;
import com.ma.entities.IAnimPacketSync;
import com.ma.entities.ai.FactionTierWrapperGoal;
import com.ma.entities.sorcery.targeting.EntitySpellProjectile;
import com.ma.events.delayed.DelayedEventQueue;
import com.ma.events.delayed.TimedDelayedEvent;
import com.ma.network.ServerMessageDispatcher;
import com.ma.spells.SpellsInit;
import com.ma.tools.math.MathUtils;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.CustomInstructionKeyframeEvent;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EntitySpellbreaker
extends MonsterEntity
implements IAnimatable,
AnimationController.ICustomInstructionListener,
IAnimPacketSync<EntitySpellbreaker>,
ISpellInteractibleEntity<EntitySpellbreaker>,
IFactionEnemy<EntitySpellbreaker>,
IEntityAdditionalSpawnData {
    private static final String INSTRUCTION_DAMAGE = "damage";
    private static final String INSTRUCTION_SILENCE = "silence";
    private static final String INSTRUCTION_RALLY = "rally";
    private static final int SHIELD_BASH_CD = 300;
    private static final int RALLY_CD = 3600;
    private AnimationFactory animFactory = new AnimationFactory((IAnimatable)this);
    private int shieldBashCooldown = 0;
    private int rallyCooldown = 0;
    private boolean isActing = false;
    private boolean isMeleeAttacking = false;
    private boolean isShieldBashing = false;
    private boolean isRallying = false;
    private PlayerEntity raidTarget;
    private int tier;
    private HashMap<String, Integer> damageResists = new HashMap();

    public EntitySpellbreaker(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.2f;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return super.func_184601_bQ(damageSourceIn);
    }

    protected SoundEvent func_184615_bR() {
        return super.func_184615_bR();
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        this.applyInitialSpawnTier((IWorld)worldIn);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void func_70623_bb() {
        super.func_70623_bb();
        this.raidTargetDespawn();
    }

    @Override
    public Faction getFaction() {
        return Faction.ANCIENT_WIZARDS;
    }

    @Override
    public PlayerEntity getRaidTarget() {
        return this.raidTarget;
    }

    @Override
    public void setRaidTarget(PlayerEntity player) {
        this.raidTarget = player;
        this.func_70624_b((LivingEntity)player);
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public void setTier(int tier) {
        this.tier = tier;
        this.func_110148_a(Attributes.field_233818_a_).func_233769_c_(new AttributeModifier("tier_health_bonus", (double)(tier + 1), AttributeModifier.Operation.MULTIPLY_BASE));
        this.func_110148_a(Attributes.field_233826_i_).func_233769_c_(new AttributeModifier("tier_armor_bonus", (double)(5 * tier), AttributeModifier.Operation.ADDITION));
        this.func_70606_j(this.func_110138_aP());
    }

    @Override
    public HashMap<String, Integer> getDamageResists() {
        return this.damageResists;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        amount = this.applyDamageResists(source, amount);
        return super.func_70097_a(source, amount);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        this.writeFactionData(compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.readFactionData(compound);
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate);
        controller.registerCustomInstructionListener((AnimationController.ICustomInstructionListener)this);
        data.addAnimationController(controller);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        event.getController().transitionLengthTicks = 2.0;
        if (!this.isActing) {
            if (this.func_213322_ci().func_72441_c(0.0, -this.func_213322_ci().field_72448_b, 0.0).func_72433_c() > (double)0.02f) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.combat_walk", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.combat_idle", Boolean.valueOf(true)));
            }
        } else if (this.isShieldBashing) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.combat_shield_bash", Boolean.valueOf(false)));
        } else if (this.isRallying) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.combat_rally", Boolean.valueOf(false)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.combat_stab", Boolean.valueOf(false)));
        }
        return PlayState.CONTINUE;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        --this.shieldBashCooldown;
        --this.rallyCooldown;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new FactionTierWrapperGoal(2, this, new RallyGoal()));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, this.func_233637_b_(Attributes.field_233821_d_), false));
        this.field_70714_bg.func_75776_a(5, (Goal)new RandomWalkingGoal((CreatureEntity)this, (double)0.35f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, this::factionTargetPlayerPredicate));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 10, true, false, this::factionTargetHelpPredicate));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 10, true, false, e -> e instanceof IFactionEnemy && ((IFactionEnemy)e).getFaction() != this.getFaction()));
    }

    public void func_226292_a_(Hand p_226292_1_, boolean p_226292_2_) {
        if (this.isActing) {
            return;
        }
        DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<String>("resetattack", 40, "", this::handleDelayCallback));
        this.isActing = true;
        this.isMeleeAttacking = true;
        ServerMessageDispatcher.sendEntityStateMessage(this);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (!this.isMeleeAttacking) {
            return true;
        }
        if (this.tier >= 2 && this.shieldBashCooldown <= 0) {
            this.isShieldBashing = true;
            DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<Entity>(INSTRUCTION_SILENCE, 20, entityIn, this::handleDelayCallback));
        } else {
            DelayedEventQueue.pushEvent(this.field_70170_p, new TimedDelayedEvent<Entity>(INSTRUCTION_DAMAGE, 20, entityIn, this::handleDelayCallback));
        }
        this.isMeleeAttacking = false;
        return true;
    }

    public boolean damageEntity(Entity entityIn) {
        boolean flag;
        int i;
        float f = (float)this.func_233637_b_(Attributes.field_233823_f_);
        float f1 = (float)this.func_233637_b_(Attributes.field_233824_g_);
        if (entityIn instanceof LivingEntity) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (CreatureAttribute)((LivingEntity)entityIn).func_70668_bt());
            f1 += (float)EnchantmentHelper.func_77501_a((LivingEntity)this);
        }
        if ((i = EnchantmentHelper.func_90036_a((LivingEntity)this)) > 0) {
            entityIn.func_70015_d(i * 4);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), f)) {
            if (f1 > 0.0f && entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).func_233627_a_(f1 * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
            }
            if (entityIn instanceof PlayerEntity) {
                PlayerEntity playerentity = (PlayerEntity)entityIn;
                this.maybeDisableShield(playerentity, this.func_184614_ca(), playerentity.func_184587_cr() ? playerentity.func_184607_cu() : ItemStack.field_190927_a);
            }
            this.func_174815_a((LivingEntity)this, entityIn);
            this.func_130011_c(entityIn);
            if (this.field_70146_Z.nextFloat() < 0.4f && entityIn instanceof MobEntity) {
                ((MobEntity)entityIn).func_70624_b((LivingEntity)this);
            }
        }
        return flag;
    }

    private void maybeDisableShield(PlayerEntity p_233655_1_, ItemStack p_233655_2_, ItemStack p_233655_3_) {
        if (!p_233655_2_.func_190926_b() && !p_233655_3_.func_190926_b() && p_233655_2_.func_77973_b() instanceof AxeItem && p_233655_3_.func_77973_b() == Items.field_185159_cQ) {
            float f = 0.25f + (float)EnchantmentHelper.func_185293_e((LivingEntity)this) * 0.05f;
            if (this.field_70146_Z.nextFloat() < f) {
                p_233655_1_.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                this.field_70170_p.func_72960_a((Entity)p_233655_1_, (byte)30);
            }
        }
    }

    public AnimationFactory getFactory() {
        return this.animFactory;
    }

    public static AttributeModifierMap.MutableAttribute getGlobalAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 30.0).func_233815_a_(Attributes.field_233821_d_, (double)0.55f).func_233815_a_(Attributes.field_233823_f_, 6.0).func_233815_a_(Attributes.field_233825_h_, 40.0).func_233815_a_(Attributes.field_233824_g_, 1.0).func_233815_a_(Attributes.field_233820_c_, 1.0);
    }

    private void handleDelayCallback(String identifier, Entity entity) {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            switch (identifier) {
                case "damage": {
                    this.damageEntity(entity);
                    this.func_184185_a(SFX.Entity.Generic.WOOSH, 1.0f, (float)(0.9 + Math.random() * (double)0.2f));
                    break;
                }
                case "silence": {
                    this.damageEntity(entity);
                    if (entity instanceof PlayerEntity) {
                        ((PlayerEntity)entity).func_195064_c(new EffectInstance((Effect)EffectInit.SILENCE.get(), 100));
                    }
                    this.func_184185_a(SFX.Entity.Spellbreaker.SHIELD_BASH, 1.0f, (float)(0.9 + Math.random() * (double)0.2f));
                    break;
                }
                case "rally": {
                    this.func_184185_a(SFX.Entity.Spellbreaker.RALLY, 1.0f, 1.0f);
                    List allies = this.field_70170_p.func_175647_a(MonsterEntity.class, this.func_174813_aQ().func_186662_g(10.0), e -> e.func_70089_S() && e instanceof EntitySpellbreaker);
                    for (MonsterEntity m : allies) {
                        m.func_195064_c(new EffectInstance(Effects.field_76429_m, 300, 1, false, true));
                        m.func_195064_c(new EffectInstance(Effects.field_76428_l, 100, 1, false, false));
                        m.func_195064_c(new EffectInstance(Effects.field_76420_g, 300, 2, false, true));
                    }
                    break;
                }
            }
        }
    }

    private void handleDelayCallback(String identifier, String data) {
        if (!this.field_70170_p.field_72995_K) {
            this.isActing = false;
            if (this.isShieldBashing) {
                this.shieldBashCooldown = 300;
                this.isShieldBashing = false;
            } else if (this.isRallying) {
                this.rallyCooldown = 3600;
                this.isRallying = false;
            }
            ServerMessageDispatcher.sendEntityStateMessage(this);
        }
    }

    public void executeInstruction(CustomInstructionKeyframeEvent event) {
    }

    @Override
    public CompoundNBT getPacketData() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("attacking", this.isActing);
        nbt.func_74757_a("shield_bashing", this.isShieldBashing);
        nbt.func_74757_a("rallying", this.isRallying);
        return nbt;
    }

    @Override
    public void handlePacketData(CompoundNBT nbt) {
        this.isActing = nbt.func_74767_n("attacking");
        this.isShieldBashing = nbt.func_74767_n("shield_bashing");
        this.isRallying = nbt.func_74767_n("rallying");
    }

    @Override
    public boolean onShapeTarget(ISpellDefinition spell, SpellSource source) {
        if (!spell.isValid()) {
            return false;
        }
        if (!source.hasCasterReference()) {
            return false;
        }
        Vector3d direction = this.func_213303_ch().func_178788_d(source.getOrigin()).func_72432_b();
        Vector3d look = Vector3d.func_189984_a((Vector2f)this.func_189653_aC());
        float angleDeg = (float)(Math.acos(look.func_72430_b(direction)) * 180.0 / Math.PI);
        if (angleDeg > 120.0f && angleDeg < 170.0f) {
            if (!this.field_70170_p.field_72995_K) {
                Vector3d reflect = MathUtils.reflect(look, direction);
                Shape shape = spell.getShape().getPart();
                CompoundNBT spellData = new CompoundNBT();
                spell.writeToNBT(spellData);
                if (shape != SpellsInit.BEAM) {
                    if (shape == SpellsInit.PROJECTILE) {
                        EntitySpellProjectile newProjectile = new EntitySpellProjectile((LivingEntity)this, this.field_70170_p);
                        newProjectile.setSpellRecipe(spellData);
                        newProjectile.shoot((Entity)this, reflect, 1.0f, 0.1f);
                        this.field_70170_p.func_217376_c((Entity)newProjectile);
                    } else if (shape == SpellsInit.BOLT) {
                        ServerMessageDispatcher.sendParticleSpawn(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_226277_ct_() + reflect.field_72450_a * 8.0, this.func_226278_cu_() + reflect.field_72448_b * 8.0, this.func_226281_cx_() + reflect.field_72449_c * 8.0, 64.0f, (RegistryKey<World>)this.field_70170_p.func_234923_W_(), (MAParticleType)ParticleInit.LIGHTNING_BOLT.get());
                    }
                }
            }
            return true;
        }
        return false;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.tier = additionalData.readInt();
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeInt(this.tier);
    }

    public class RallyGoal
    extends Goal {
        public RallyGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return EntitySpellbreaker.this.rallyCooldown <= 0 && EntitySpellbreaker.this.func_70638_az() != null && EntitySpellbreaker.this.func_110143_aJ() < EntitySpellbreaker.this.func_110138_aP() * 0.75f && !EntitySpellbreaker.this.func_70644_a(Effects.field_76428_l) && !EntitySpellbreaker.this.func_70644_a(Effects.field_76429_m) && !EntitySpellbreaker.this.func_70644_a(Effects.field_76420_g) && !EntitySpellbreaker.this.isActing;
        }

        public void func_75249_e() {
            EntitySpellbreaker.this.func_70661_as().func_75499_g();
            EntitySpellbreaker.this.isRallying = true;
            EntitySpellbreaker.this.isActing = true;
            DelayedEventQueue.pushEvent(EntitySpellbreaker.this.field_70170_p, new TimedDelayedEvent<LivingEntity>(EntitySpellbreaker.INSTRUCTION_RALLY, 20, (LivingEntity)EntitySpellbreaker.this, (x$0, x$1) -> EntitySpellbreaker.this.handleDelayCallback(x$0, x$1)));
            DelayedEventQueue.pushEvent(EntitySpellbreaker.this.field_70170_p, new TimedDelayedEvent<String>("resetattack", 40, "", (x$0, x$1) -> EntitySpellbreaker.this.handleDelayCallback(x$0, x$1)));
            ServerMessageDispatcher.sendEntityStateMessage(EntitySpellbreaker.this);
        }

        public boolean func_75253_b() {
            return EntitySpellbreaker.this.isRallying;
        }
    }
}

