/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.faction;

import com.ma.ManaAndArtifice;
import com.ma.api.capabilities.Faction;
import com.ma.api.entities.FactionRaidRegistry;
import com.ma.api.entities.IFactionEnemy;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.entities.EntityInit;
import com.ma.tools.SummonUtils;
import com.mojang.datafixers.util.Pair;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.commons.lang3.mutable.MutableInt;

public class FactionRaidEntity
extends Entity {
    private static final DataParameter<Integer> FACTION = EntityDataManager.func_187226_a(FactionRaidEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private PlayerEntity player;
    private UUID playerUUID;
    private int strength;
    private boolean isProtective;
    private EffectInstance[] additionalEffects;

    public FactionRaidEntity(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public FactionRaidEntity(World world, PlayerEntity target, int strength) {
        super((EntityType)EntityInit.FACTION_RAID_ENTITY.get(), world);
        this.player = target;
        this.strength = strength;
    }

    public void setProtective(PlayerEntity guard) {
        this.player = guard;
        this.isProtective = true;
    }

    public void setAdditionalEffects(EffectInstance[] effects) {
        this.additionalEffects = effects;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 20 == 0 && !this.spawnRaidEntity()) {
            this.remove(false);
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.getFaction() == Faction.DEMONS) {
                this.spawnDemonParticles();
            } else if (this.getFaction() == Faction.UNDEAD) {
                this.spawnUndeadParticles();
            }
        } else if (this.field_70173_aa == 20) {
            switch (this.getFaction()) {
                case ANCIENT_WIZARDS: {
                    this.func_184185_a(SFX.Event.Faction.FACTION_RAID_COUNCIL, 1.0f, 1.0f);
                    break;
                }
                case DEMONS: {
                    this.func_184185_a(SFX.Event.Faction.FACTION_RAID_DEMONS, 1.0f, 1.0f);
                    break;
                }
                case FEY_COURT: {
                    this.func_184185_a(SFX.Event.Faction.FACTION_RAID_FEY, 1.0f, 1.0f);
                    break;
                }
                case UNDEAD: {
                    this.func_184185_a(SFX.Event.Faction.FACTION_RAID_DEMONS, 1.0f, 1.0f);
                    break;
                }
            }
        }
    }

    private void spawnDemonParticles() {
        int i;
        for (i = 0; i < 15; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.HELLFIRE.get())), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (double)-0.05f + Math.random() * (double)0.1f, (double)0.1f, (double)-0.05f + Math.random() * (double)0.1f);
        }
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197595_F, this.func_226277_ct_() - 0.5 + Math.random() * 1.0, this.func_226278_cu_(), this.func_226281_cx_() - 0.5 + Math.random() * 1.0, 0.0, (double)0.05f, 0.0);
        for (i = 0; i < 5; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218424_l, this.func_226277_ct_() - 1.5 + Math.random() * 3.0, this.func_226278_cu_(), this.func_226281_cx_() - 1.5 + Math.random() * 3.0, 0.0, (double)0.05f, 0.0);
        }
    }

    private void spawnUndeadParticles() {
        int i;
        for (i = 0; i < 15; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FROST.get())), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (double)-0.05f + Math.random() * (double)0.1f, (double)0.1f, (double)-0.05f + Math.random() * (double)0.1f);
        }
        for (i = 0; i < 5; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BONE.get())), this.func_226277_ct_() - 1.5 + Math.random() * 3.0, this.func_226278_cu_(), this.func_226281_cx_() - 1.5 + Math.random() * 3.0, 0.0, (double)0.05f, 0.0);
        }
    }

    private PlayerEntity getPlayer() {
        if (this.player == null && this.playerUUID != null) {
            this.player = this.field_70170_p.func_217371_b(this.playerUUID);
        }
        return this.player;
    }

    private boolean spawnRaidEntity() {
        if (this.getPlayer() == null) {
            return false;
        }
        Pair<EntityType<? extends IFactionEnemy<? extends MobEntity>>, Integer> soldier = FactionRaidRegistry.getSoldier(this.getFaction(), this.strength);
        if (soldier == null) {
            return false;
        }
        IFactionEnemy entity = (IFactionEnemy)((EntityType)soldier.getFirst()).func_200721_a(this.field_70170_p);
        if (!this.isProtective) {
            entity.setRaidTarget(this.getPlayer());
        } else {
            SummonUtils.setSummon((MobEntity)entity, this.player, 1200);
        }
        entity.setTier((Integer)soldier.getSecond());
        ((LivingEntity)entity).func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76429_m, 40, 3));
        if (this.additionalEffects != null) {
            for (EffectInstance inst : this.additionalEffects) {
                ((LivingEntity)entity).func_195064_c(new EffectInstance(inst.func_188419_a(), inst.func_76459_b(), inst.func_76458_c(), inst.func_82720_e(), inst.func_188418_e(), inst.func_205348_f()));
            }
        }
        this.field_70170_p.func_217376_c((Entity)entity);
        int entity_strength_rating = FactionRaidRegistry.getStrengthRating(this.getFaction(), (EntityType<? extends IFactionEnemy<? extends MobEntity>>)((EntityType)soldier.getFirst()), (Integer)soldier.getSecond());
        if (entity_strength_rating == -1) {
            return false;
        }
        this.strength -= entity_strength_rating;
        return this.strength > 0;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(FACTION, (Object)0);
    }

    protected void func_70037_a(CompoundNBT compound) {
        ListNBT nbt;
        if (compound.func_74764_b("strength")) {
            this.strength = compound.func_74762_e("strength");
        }
        if (compound.func_74764_b("protecting")) {
            this.isProtective = compound.func_74767_n("protecting");
        }
        if (compound.func_74764_b("faction")) {
            this.field_70180_af.func_187227_b(FACTION, (Object)compound.func_74762_e("faction"));
        }
        if (compound.func_74764_b("afx") && (nbt = compound.func_150295_c("afx", 10)) != null) {
            this.additionalEffects = new EffectInstance[nbt.size()];
            MutableInt idx = new MutableInt(0);
            nbt.forEach(n -> {
                this.additionalEffects[idx.intValue()] = EffectInstance.func_82722_b((CompoundNBT)((CompoundNBT)n));
            });
        }
        if (compound.func_74764_b("target")) {
            try {
                this.playerUUID = UUID.fromString(compound.func_74779_i("target"));
            }
            catch (Exception ex) {
                ManaAndArtifice.LOGGER.error("Failed to load player UUID when loading faction raid.  Skipping and despawning the raid.");
            }
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("strength", this.strength);
        compound.func_74768_a("faction", ((Integer)this.field_70180_af.func_187225_a(FACTION)).intValue());
        compound.func_74757_a("protecting", this.isProtective);
        if (this.additionalEffects != null) {
            ListNBT afx = new ListNBT();
            for (EffectInstance inst : this.additionalEffects) {
                CompoundNBT instSaved = inst.func_82719_a(new CompoundNBT());
                afx.add((Object)instSaved);
            }
            compound.func_218657_a("afx", (INBT)afx);
        }
        if (this.player != null) {
            compound.func_74778_a("target", this.player.func_110124_au().toString());
        }
    }

    public Faction getFaction() {
        return Faction.values()[(Integer)this.field_70180_af.func_187225_a(FACTION)];
    }

    public void setFaction(Faction faction) {
        this.field_70180_af.func_187227_b(FACTION, (Object)faction.ordinal());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

