/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.renderers;

import com.ma.entities.sorcery.EntityRift;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;

public class EntityRiftRenderer
extends EntityRenderer<EntityRift> {
    private static final ResourceLocation PORTAL_TEXTURE = new ResourceLocation("mana-and-artifice", "textures/entity/vortex.png");
    private static final RenderType RENDER_TYPE = RenderType.func_228644_e_((ResourceLocation)PORTAL_TEXTURE);

    public EntityRiftRenderer(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public void render(EntityRift entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        Quaternion cameraRotation = this.field_76990_c.func_229098_b_();
        Quaternion portalRotation = new Quaternion(0.0f, cameraRotation.func_195891_b(), 0.0f, cameraRotation.func_195894_d());
        float spawnPct = entityIn.getAge() < 20 ? (float)Math.min(entityIn.getAge(), 20) / 20.0f : (entityIn.getAge() > 180 ? 1.0f - (float)Math.min(entityIn.getAge() - 180, 20) / 20.0f : 1.0f);
        float scaleFactor = 1.0f * spawnPct;
        float portalSpinDegrees = entityIn.getAge() * 3 % 360;
        float verticalOffset = 1.0f;
        IVertexBuilder vertexBuilder = bufferIn.getBuffer(RENDER_TYPE);
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.0, (double)verticalOffset, 0.0);
        matrixStackIn.func_227862_a_(scaleFactor, scaleFactor, scaleFactor);
        matrixStackIn.func_227863_a_(portalRotation);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(portalSpinDegrees));
        matrixStackIn.func_227861_a_(0.0, -0.25, 0.0);
        MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
        Matrix4f renderMatrix = matrixstack$entry.func_227870_a_();
        Matrix3f normalMatrix = matrixstack$entry.func_227872_b_();
        float nrmV = (float)Math.cos((double)portalSpinDegrees * Math.PI / 180.0);
        float nrmH = (float)Math.cos((double)(portalSpinDegrees - 90.0f) * Math.PI / 180.0);
        int[] color = new int[]{105, 24, 152, 230};
        EntityRiftRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 0.0f, 0.0f, 0.0f, 1.0f, nrmH, nrmV, color);
        EntityRiftRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 1.0f, 0.0f, 1.0f, 1.0f, nrmH, nrmV, color);
        EntityRiftRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 1.0f, 1.0f, 1.0f, 0.0f, nrmH, nrmV, color);
        EntityRiftRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 0.0f, 1.0f, 0.0f, 0.0f, nrmH, nrmV, color);
        matrixStackIn.func_227865_b_();
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.0, (double)verticalOffset, 0.0);
        matrixStackIn.func_227862_a_(scaleFactor, scaleFactor, scaleFactor);
        matrixStackIn.func_227863_a_(portalRotation);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-portalSpinDegrees));
        matrixStackIn.func_227861_a_(0.0, -0.25, (double)0.001f);
        matrixstack$entry = matrixStackIn.func_227866_c_();
        renderMatrix = matrixstack$entry.func_227870_a_();
        normalMatrix = matrixstack$entry.func_227872_b_();
        nrmH = (float)Math.cos((double)(portalSpinDegrees + 90.0f) * Math.PI / 180.0);
        color = new int[]{186, 30, 180, 230};
        EntityRiftRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 0.0f, 0.0f, 0.0f, 1.0f, nrmH, nrmV, color);
        EntityRiftRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 1.0f, 0.0f, 1.0f, 1.0f, nrmH, nrmV, color);
        EntityRiftRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 1.0f, 1.0f, 1.0f, 0.0f, nrmH, nrmV, color);
        EntityRiftRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 0.0f, 1.0f, 0.0f, 0.0f, nrmH, nrmV, color);
        matrixStackIn.func_227865_b_();
        super.func_225623_a_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    private static void addVertex(IVertexBuilder vertexBuilder_, Matrix4f renderMatrix, Matrix3f normalMatrix, int packedLight, float x, float y, float u, float v, float nrmH, float nrmV, int[] color) {
        if (color.length != 4) {
            return;
        }
        vertexBuilder_.func_227888_a_(renderMatrix, x - 0.5f, y - 0.25f, 0.0f).func_225586_a_(color[0], color[1], color[2], color[3]).func_225583_a_(u, v).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normalMatrix, nrmH, nrmV, nrmH).func_181675_d();
    }

    public ResourceLocation getTextureLocation(EntityRift entity) {
        return PORTAL_TEXTURE;
    }
}

