/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.rituals;

import com.ma.ManaAndArtifice;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.api.sound.SFX;
import com.ma.entities.EntityInit;
import com.ma.entities.UtilityEntityBase;
import com.ma.entities.rituals.EntityFaerieQueen;
import java.util.UUID;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntityFeyLight
extends UtilityEntityBase {
    private static final DataParameter<String> CASTER_UUID = EntityDataManager.func_187226_a(EntityFeyLight.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<BlockPos> TARGET_POSITION = EntityDataManager.func_187226_a(EntityFeyLight.class, (IDataSerializer)DataSerializers.field_187200_j);
    private float angle = 0.0f;
    private int growTicks = 0;
    private static int maxGrowTicks = 40;

    public EntityFeyLight(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.age == 1 && this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_() - 9.0, this.func_226281_cx_(), SFX.Event.Ritual.FAERIE_SUMMON, SoundCategory.PLAYERS, 1.0f, 1.0f, false);
        }
        if (this.updateMovement()) {
            ++this.growTicks;
            if (this.growTicks > maxGrowTicks && !this.field_70170_p.field_72995_K) {
                this.remove(false);
                EntityFaerieQueen efq = (EntityFaerieQueen)((EntityType)EntityInit.FAERIE_QUEEN.get()).func_220331_a((ServerWorld)this.field_70170_p, null, null, this.func_233580_cy_().func_177977_b(), SpawnReason.EVENT, false, false);
                efq.setCasterUUID(this.getCasterUUID());
            }
        } else if (this.field_70170_p.field_72995_K) {
            float r = 0.25f;
            float r2 = r * 2.0f;
            this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.SPARKLE_STATIONARY.get())), this.func_226277_ct_() - (double)r + Math.random() * (double)r2, this.func_226278_cu_() - (double)r + Math.random() * (double)r2, this.func_226281_cx_() - (double)r + Math.random() * (double)r2, 0.0, 0.0, 0.0);
        }
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        double radius = 1.0;
        double velocity = 0.5;
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 100; ++i) {
                Vector3d pos = new Vector3d(this.field_70170_p.field_73012_v.nextGaussian(), this.field_70170_p.field_73012_v.nextGaussian(), this.field_70170_p.field_73012_v.nextGaussian()).func_72432_b();
                Vector3d vel = pos.func_186678_a(velocity);
                pos = pos.func_186678_a(radius);
                this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.SPARKLE_VELOCITY.get())), this.func_226277_ct_() + pos.field_72450_a, this.func_226278_cu_() + pos.field_72448_b, this.func_226281_cx_() + pos.field_72449_c, vel.field_72450_a, vel.field_72448_b, vel.field_72449_c);
            }
        }
    }

    private boolean updateMovement() {
        Vector3d me;
        Vector3d target = new Vector3d((double)this.getTargetPos().func_177958_n(), (double)this.getTargetPos().func_177956_o(), (double)this.getTargetPos().func_177952_p()).func_72441_c(0.5, 0.0, 0.5);
        if (target.func_72438_d(me = this.func_213303_ch()) < (double)0.2f || me.field_72448_b < target.field_72448_b) {
            return true;
        }
        Vector3d diff = me.func_178788_d(target);
        float radius = (float)diff.field_72448_b / 2.0f;
        this.angle = (float)((double)this.angle + 0.08726646324990228);
        Vector3d newPos = new Vector3d(target.field_72450_a + (double)radius * Math.cos(this.angle), target.field_72448_b + diff.field_72448_b - (double)0.09f, target.field_72449_c + (double)radius * Math.sin(this.angle));
        this.func_70107_b(newPos.field_72450_a, newPos.field_72448_b, newPos.field_72449_c);
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(CASTER_UUID, (Object)"");
        this.field_70180_af.func_187214_a(TARGET_POSITION, (Object)this.func_233580_cy_());
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_74764_b("caster")) {
            this.field_70180_af.func_187227_b(CASTER_UUID, (Object)compound.func_74779_i("caster"));
        }
        if (compound.func_74764_b("target_position")) {
            CompoundNBT targetPos = compound.func_74775_l("target_position");
            this.field_70180_af.func_187227_b(TARGET_POSITION, (Object)new BlockPos((double)targetPos.func_74760_g("x"), (double)targetPos.func_74760_g("y"), (double)targetPos.func_74760_g("z")));
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74778_a("caster", (String)this.field_70180_af.func_187225_a(CASTER_UUID));
        CompoundNBT targetPos = new CompoundNBT();
        targetPos.func_74776_a("x", (float)((BlockPos)this.field_70180_af.func_187225_a(TARGET_POSITION)).func_177958_n());
        targetPos.func_74776_a("y", (float)((BlockPos)this.field_70180_af.func_187225_a(TARGET_POSITION)).func_177956_o());
        targetPos.func_74776_a("z", (float)((BlockPos)this.field_70180_af.func_187225_a(TARGET_POSITION)).func_177952_p());
        compound.func_218657_a("target_position", (INBT)targetPos);
    }

    public UUID getCasterUUID() {
        try {
            UUID uUID = UUID.fromString((String)this.field_70180_af.func_187225_a(CASTER_UUID));
            return uUID;
        }
        catch (Exception exception) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return null;
    }

    public void setCasterUUID(UUID casterUUID) {
        if (casterUUID != null) {
            this.field_70180_af.func_187227_b(CASTER_UUID, (Object)casterUUID.toString());
        } else {
            ManaAndArtifice.LOGGER.error("Received null UUID for ritual caster.  Some effects may not apply!");
        }
    }

    public BlockPos getTargetPos() {
        return (BlockPos)this.field_70180_af.func_187225_a(TARGET_POSITION);
    }

    public void setTargetPos(BlockPos target) {
        this.field_70180_af.func_187227_b(TARGET_POSITION, (Object)target);
    }

    public float getGrowthAmount() {
        return (float)this.growTicks / (float)maxGrowTicks;
    }
}

