/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.sorcery.targeting;

import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.targeting.SpellContext;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.entities.EntityInit;
import com.ma.entities.sorcery.targeting.EntitySpellWall;
import com.ma.spells.SpellCaster;
import com.ma.spells.crafting.SpellRecipe;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntitySpellWave
extends EntitySpellWall {
    public EntitySpellWave(EntityType<? extends EntitySpellWave> entityTypeIn, World worldIn) {
        super((EntityType<? extends EntitySpellWall>)entityTypeIn, worldIn);
    }

    public EntitySpellWave(PlayerEntity caster, ISpellDefinition spell, World world) {
        super((EntityType<? extends EntitySpellWall>)((EntityType)EntityInit.SPELL_WAVE.get()), caster, spell, world);
        this.func_70107_b(caster.func_226277_ct_(), caster.func_226278_cu_(), caster.func_226281_cx_());
        float x = -MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(this.field_70125_A * ((float)Math.PI / 180)));
        float y = -MathHelper.func_76126_a((float)(this.field_70125_A * ((float)Math.PI / 180)));
        float z = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(this.field_70125_A * ((float)Math.PI / 180)));
        Vector3d motion = new Vector3d((double)x, (double)y, (double)z).func_72432_b().func_186678_a((double)this.getShapeAttribute(Attribute.SPEED));
        this.func_213317_d(motion);
    }

    @Override
    public void func_70071_h_() {
        this.func_70107_b(this.func_226277_ct_() + this.func_213322_ci().field_72450_a, this.func_226278_cu_() + this.func_213322_ci().field_72448_b, this.func_226281_cx_() + this.func_213322_ci().field_72449_c);
        super.func_70071_h_();
    }

    @Override
    protected void applyEffect(ItemStack stack, SpellRecipe recipe, PlayerEntity caster, ServerWorld world) {
        float radius_h = this.getShapeAttributeByAge(Attribute.WIDTH);
        float radius_v = this.getShapeAttributeByAge(Attribute.HEIGHT);
        SpellSource source = new SpellSource((LivingEntity)caster, caster.func_184600_cs());
        SpellContext context = new SpellContext(world, recipe, this);
        if (recipe.getComponents().stream().anyMatch(c -> ((Component)c.getPart()).targetsEntities())) {
            for (Entity e : this.targetEntities(radius_h, radius_v)) {
                SpellCaster.ApplyComponents(recipe, source, new SpellTarget(e), context);
            }
        }
        if (recipe.getComponents().stream().anyMatch(c -> ((Component)c.getPart()).targetsBlocks())) {
            for (BlockPos p : this.targetBlocks(radius_h, radius_v)) {
                SpellCaster.ApplyComponents(recipe, source, new SpellTarget(p, null), context);
            }
        }
    }

    @Override
    protected void spawnAirParticles() {
        Vector3d jitter = new Vector3d((double)-0.1f + Math.random() * (double)0.2f, 0.0, (double)-0.1f + Math.random() * (double)0.2f);
        this.spawnParticlesAlongRadius((MAParticleType)ParticleInit.AIR_VELOCITY.get(), this.func_213322_ci().func_186678_a(0.75).func_178787_e(jitter));
    }

    @Override
    protected void spawnArcaneParticles() {
        this.spawnParticlesAlongRadius((MAParticleType)ParticleInit.ARCANE.get(), this.func_213322_ci().func_186678_a(0.75));
    }

    @Override
    protected void spawnEnderParticles() {
        this.spawnParticlesAlongRadius((MAParticleType)ParticleInit.ENDER_VELOCITY.get(), this.func_213322_ci().func_186678_a(0.75));
    }

    @Override
    protected void spawnFireParticles(boolean hellfire, boolean lightning) {
        if (!lightning) {
            this.spawnParticlesAlongRadius(hellfire ? (MAParticleType)ParticleInit.HELLFIRE.get() : (MAParticleType)ParticleInit.FLAME.get(), this.func_213322_ci(), false, false);
        } else {
            this.spawnLightningParticlesAlongRadius(this.func_213322_ci().func_178787_e(new Vector3d(-0.5 + Math.random(), Math.random(), -0.5 + Math.random())));
        }
    }

    @Override
    protected void spawnWaterParticles(boolean frost) {
        this.spawnParticlesAlongRadius(frost ? (MAParticleType)ParticleInit.FROST.get() : (MAParticleType)ParticleInit.WATER.get(), this.func_213322_ci().func_186678_a(0.75));
    }

    @Override
    protected int getApplicationRate() {
        return 1;
    }
}

