/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.utility;

import com.ma.ManaAndArtifice;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.effects.EffectInit;
import com.ma.entities.EntityInit;
import com.ma.tools.math.Vector3;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityEldrinFlight
extends Entity
implements IEntityAdditionalSpawnData {
    private static final DataParameter<BlockPos> END_POS = EntityDataManager.func_187226_a(EntityEldrinFlight.class, (IDataSerializer)DataSerializers.field_187200_j);
    private Vector3 startPosition;
    private Vector3 endPosition;
    private Vector3 controlPointA;
    private Vector3 controlPointB;
    private float travelTime;
    private PlayerEntity player;
    private int age = 0;
    private boolean heightAdjusted = false;
    private static final int MIN_Y = 4;

    public EntityEldrinFlight(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public EntityEldrinFlight(World world, PlayerEntity player, Vector3d start, Vector3d end) {
        super((EntityType)EntityInit.ELDRIN_FLIGHT.get(), world);
        this.player = player;
        this.startPosition = new Vector3(start);
        if (!world.field_72995_K) {
            if (end.field_72448_b == -1.0) {
                IChunk chunk = world.func_217349_x(new BlockPos(end));
                int yPos = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE, (int)end.func_82615_a(), (int)end.func_82616_c());
                this.endPosition = new Vector3(end.field_72450_a, yPos + 1, end.field_72449_c);
            } else {
                this.endPosition = new Vector3(end);
            }
        } else {
            this.endPosition = new Vector3(end);
        }
        Vector3 delta = this.endPosition.sub(this.startPosition);
        this.controlPointA = this.startPosition.add(delta.scale(0.33f)).add(new Vector3(0.0, 100.0, 0.0));
        this.controlPointB = this.startPosition.add(delta.scale(0.66f)).add(new Vector3(0.0, 100.0, 0.0));
        this.field_70145_X = true;
        float blocksPerSecond = 50.0f;
        this.travelTime = delta.length() / blocksPerSecond * 20.0f;
        this.func_70107_b(start.func_82615_a(), start.func_82617_b(), start.func_82616_c());
    }

    public void func_70071_h_() {
        ++this.age;
        if (!(this.field_70170_p.field_72995_K || this.startPosition != null && this.endPosition != null && this.controlPointA != null && this.controlPointB != null)) {
            this.remove(false);
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.player == ManaAndArtifice.instance.proxy.getClientPlayer()) {
                ManaAndArtifice.instance.proxy.setRenderViewEntity(this);
            }
            this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_GRAVITY.get())), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (Math.random() - 0.5) * 0.2, 0.0, (Math.random() - 0.5) * 0.2);
            if (this.age < 60 && this.age % 10 == 0) {
                this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.TRAIL.get())), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (double)this.func_145782_y(), this.field_70170_p.field_73012_v.nextDouble(), (double)(this.travelTime + 70.0f - (float)this.age));
            }
        }
        if (!this.heightAdjusted) {
            if (this.getEndPos().func_177958_n() == 0 && this.getEndPos().func_177956_o() == 0 && this.getEndPos().func_177952_p() == 0) {
                this.setEndPos(new BlockPos(this.endPosition.toVec3D()));
            }
            if (this.field_70170_p.func_195588_v(this.getEndPos())) {
                BlockPos test = this.getEndPos();
                if (test.func_177956_o() > this.field_70170_p.func_234938_ad_()) {
                    int delta = this.field_70170_p.func_234938_ad_() - 3 - test.func_177956_o();
                    test = test.func_177982_a(0, delta, 0);
                }
                while (test.func_177956_o() > 4 && !this.field_70170_p.func_175623_d(test) && !this.field_70170_p.func_175623_d(test.func_177984_a())) {
                    test = test.func_177977_b();
                }
                while (test.func_177956_o() > 4 && this.field_70170_p.func_175623_d(test.func_177977_b())) {
                    test = test.func_177977_b();
                }
                while (test.func_177956_o() < this.field_70170_p.func_234938_ad_() - 3 && !this.field_70170_p.func_175623_d(test) && !this.field_70170_p.func_175623_d(test.func_177984_a())) {
                    test = test.func_177984_a();
                }
                if (!this.field_70170_p.func_175623_d(test) && !this.field_70170_p.func_175623_d(test.func_177984_a())) {
                    test.func_177982_a(0, this.field_70170_p.func_234938_ad_() - test.func_177956_o(), 0);
                }
                this.setEndPos(test);
                this.endPosition = new Vector3(test);
                this.heightAdjusted = true;
            }
        }
        if ((float)this.age < this.travelTime) {
            Vector3 tickPos = Vector3.bezier(this.startPosition, this.endPosition, this.controlPointA, this.controlPointB, (float)this.age / this.travelTime);
            Vector3 nextTickPos = Vector3.bezier(this.startPosition, this.endPosition, this.controlPointA, this.controlPointB, (float)this.age + 1.0f / this.travelTime);
            this.func_70107_b(tickPos.x, tickPos.y, tickPos.z);
            if (this.player != null) {
                this.player.func_230245_c_(true);
                this.player.getPersistentData().func_74757_a("eldrin_flight", true);
                this.func_70101_b(this.player.field_70177_z, this.player.field_70125_A);
                if (this.field_70170_p.field_72995_K) {
                    this.player.func_70107_b((double)tickPos.x, (double)tickPos.y, (double)tickPos.z);
                } else {
                    ((ServerPlayerEntity)this.player).func_70634_a((double)tickPos.x, (double)tickPos.y, (double)tickPos.z);
                    ((ServerPlayerEntity)this.player).field_71135_a.func_184342_d();
                }
            }
            this.func_200602_a(EntityAnchorArgument.Type.FEET, nextTickPos.toVec3D());
        } else if ((float)this.age >= this.travelTime) {
            if (!this.field_70170_p.field_72995_K) {
                this.remove(false);
                this.player.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            } else if (this.player == ManaAndArtifice.instance.proxy.getClientPlayer()) {
                ManaAndArtifice.instance.proxy.resetRenderViewEntity();
            }
        }
    }

    public void onRemovedFromWorld() {
        if (this.player != null) {
            if (this.field_70170_p.field_72995_K) {
                for (int i = 0; i < 200; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_GRAVITY.get())), this.player.func_226277_ct_(), this.player.func_226278_cu_(), this.player.func_226281_cx_(), (Math.random() - 0.5) * 0.2, Math.random() * 0.2, (Math.random() - 0.5) * 0.2);
                }
                ManaAndArtifice.instance.proxy.resetRenderViewEntity();
            }
            this.player.getPersistentData().func_82580_o("eldrin_flight");
            this.player.getPersistentData().func_82580_o("eldrin_flight_entity_id");
            this.player.field_70143_R = 0.0f;
            this.player.func_195063_d((Effect)EffectInit.ELDRIN_FLIGHT.get());
        }
        super.onRemovedFromWorld();
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(END_POS, (Object)BlockPos.field_177992_a);
    }

    private void setEndPos(BlockPos pos) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(END_POS, (Object)pos);
        }
    }

    private BlockPos getEndPos() {
        return (BlockPos)this.field_70180_af.func_187225_a(END_POS);
    }

    public void func_184206_a(DataParameter<?> p_184206_1_) {
        super.func_184206_a(p_184206_1_);
        if (p_184206_1_ == END_POS && this.field_70170_p.field_72995_K) {
            this.heightAdjusted = true;
            this.endPosition = new Vector3(this.getEndPos());
        }
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        if (this.player != null) {
            buffer.writeInt(this.player.func_145782_y());
        } else {
            buffer.writeInt(-1);
        }
        buffer.writeFloat(this.travelTime);
        buffer.writeDouble((double)this.startPosition.x);
        buffer.writeDouble((double)this.startPosition.y);
        buffer.writeDouble((double)this.startPosition.z);
        buffer.writeDouble((double)this.endPosition.x);
        buffer.writeDouble((double)this.endPosition.y);
        buffer.writeDouble((double)this.endPosition.z);
        buffer.writeDouble((double)this.controlPointA.x);
        buffer.writeDouble((double)this.controlPointA.y);
        buffer.writeDouble((double)this.controlPointA.z);
        buffer.writeDouble((double)this.controlPointB.x);
        buffer.writeDouble((double)this.controlPointB.y);
        buffer.writeDouble((double)this.controlPointB.z);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        Entity e = this.field_70170_p.func_73045_a(additionalData.readInt());
        if (e instanceof PlayerEntity) {
            this.player = (PlayerEntity)e;
        }
        this.travelTime = additionalData.readFloat();
        this.startPosition = new Vector3(additionalData.readDouble(), additionalData.readDouble(), additionalData.readDouble());
        this.endPosition = new Vector3(additionalData.readDouble(), additionalData.readDouble(), additionalData.readDouble());
        this.controlPointA = new Vector3(additionalData.readDouble(), additionalData.readDouble(), additionalData.readDouble());
        this.controlPointB = new Vector3(additionalData.readDouble(), additionalData.readDouble(), additionalData.readDouble());
    }
}

