/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.utility;

import com.ma.entities.EntityInit;
import com.ma.tools.BlockUtils;
import com.ma.tools.InventoryUtilities;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityFillHole
extends Entity {
    private static final String NBT_BLOCK = "place_block";
    private static final String NBT_POSITIONS = "positions";
    private static final String NBT_INDEX = "place_index";
    private static final String NBT_RADIUS = "radius";
    private static final String NBT_HEIGHT = "height";
    private static final String NBT_FINISHED_SCAN = "finished_scan";
    private static final String NBT_PLAYER_ID = "player_uuid";
    private static final int TICKS_BETWEEN_PLACE = 5;
    private Block placeBlock;
    private ArrayList<BlockPos> positions = new ArrayList();
    private int placeIndex = 0;
    private byte radius = 0;
    private byte height = 0;
    private boolean isValid = false;
    private boolean finishedScan = false;
    private UUID playerID = null;
    private PlayerEntity player = null;

    public EntityFillHole(EntityType<?> p_i48580_1_, World p_i48580_2_) {
        super(p_i48580_1_, p_i48580_2_);
    }

    public EntityFillHole(World world, Block toPlace, BlockPos center, PlayerEntity caster, int height, int radius) {
        this((EntityType)EntityInit.FILL_HOLE.get(), world);
        this.setData(toPlace, center, caster, height, radius);
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (!this.isValid) {
            this.func_70106_y();
            return;
        }
        if (!this.finishedScan) {
            if (this.placeIndex < this.height) {
                if (!this.scanLayer(this.func_233580_cy_().func_177982_a(0, this.placeIndex++, 0))) {
                    this.finishedScan = true;
                    this.placeIndex = 0;
                }
            } else {
                this.placeIndex = 0;
                this.finishedScan = true;
            }
        } else if (!this.tryPlaceBlock()) {
            this.func_70106_y();
        }
    }

    private boolean tryPlaceBlock() {
        PlayerEntity player = this.resolvePlayer();
        if (player == null) {
            return false;
        }
        if (this.placeIndex >= this.positions.size()) {
            return false;
        }
        BlockPos placePos = this.positions.get(this.placeIndex++);
        if (!player.func_184812_l_() && !InventoryUtilities.removeItemFromInventory(new ItemStack((IItemProvider)this.placeBlock), true, true, (IItemHandlerModifiable)new InvWrapper((IInventory)player.field_71071_by))) {
            return false;
        }
        if (this.field_70170_p.func_72839_b((Entity)this, new AxisAlignedBB(placePos)).size() == 0) {
            BlockUtils.placeBlock((ServerWorld)this.field_70170_p, placePos, Direction.DOWN, this.placeBlock.func_176223_P(), player);
        }
        return true;
    }

    @Nullable
    private PlayerEntity resolvePlayer() {
        if (this.playerID == null) {
            return null;
        }
        if (this.player == null) {
            this.player = this.field_70170_p.func_217371_b(this.playerID);
        }
        return this.player;
    }

    public void setData(Block toPlace, BlockPos center, PlayerEntity caster, int height, int radius) {
        this.placeBlock = toPlace;
        this.func_70107_b((float)center.func_177958_n() + 0.5f, (float)center.func_177956_o() + 0.5f, (float)center.func_177952_p() + 0.5f);
        this.height = (byte)height;
        this.radius = (byte)radius;
        if (caster.func_146103_bH() != null) {
            this.playerID = caster.func_146103_bH().getId();
            this.player = caster;
            this.isValid = true;
        } else {
            this.isValid = false;
        }
    }

    private boolean scanLayer(BlockPos center) {
        ArrayList<BlockPos> foundPositions = new ArrayList<BlockPos>();
        BlockRayTraceResult posZ = this.field_70170_p.func_217299_a(new RayTraceContext(Vector3d.func_237489_a_((Vector3i)center), Vector3d.func_237489_a_((Vector3i)center.func_177982_a(0, 0, (int)this.radius)), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, null));
        BlockRayTraceResult negZ = this.field_70170_p.func_217299_a(new RayTraceContext(Vector3d.func_237489_a_((Vector3i)center), Vector3d.func_237489_a_((Vector3i)center.func_177982_a(0, 0, (int)(-this.radius))), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, null));
        BlockRayTraceResult posX = this.field_70170_p.func_217299_a(new RayTraceContext(Vector3d.func_237489_a_((Vector3i)center), Vector3d.func_237489_a_((Vector3i)center.func_177982_a((int)this.radius, 0, 0)), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, null));
        BlockRayTraceResult negX = this.field_70170_p.func_217299_a(new RayTraceContext(Vector3d.func_237489_a_((Vector3i)center), Vector3d.func_237489_a_((Vector3i)center.func_177982_a((int)(-this.radius), 0, 0)), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, null));
        if (!(posZ.func_216346_c() != RayTraceResult.Type.MISS && negZ.func_216346_c() != RayTraceResult.Type.MISS || posX.func_216346_c() != RayTraceResult.Type.MISS && negX.func_216346_c() != RayTraceResult.Type.MISS)) {
            return false;
        }
        int rPZ = posZ.func_216346_c() == RayTraceResult.Type.MISS ? this.radius : Math.abs(center.func_177952_p() - posZ.func_216350_a().func_177952_p());
        int rNZ = negZ.func_216346_c() == RayTraceResult.Type.MISS ? -this.radius : -Math.abs(center.func_177952_p() - negZ.func_216350_a().func_177952_p());
        int rPX = posX.func_216346_c() == RayTraceResult.Type.MISS ? this.radius : Math.abs(center.func_177958_n() - posX.func_216350_a().func_177958_n());
        int rNX = negX.func_216346_c() == RayTraceResult.Type.MISS ? -this.radius : -Math.abs(center.func_177958_n() - negX.func_216350_a().func_177958_n());
        int zLen = rPZ - rNZ;
        int xLen = rPX - rNX;
        boolean zAxis = zLen >= xLen;
        for (int i = zAxis ? rNZ : rNX; i < (zAxis ? rPZ : rPX); ++i) {
            BlockPos offsetPos = center.func_177982_a(zAxis ? 0 : i, 0, zAxis ? i : 0);
            BlockPos rayEndPos = offsetPos.func_177982_a((int)(zAxis ? this.radius : (byte)0), 0, (int)(zAxis ? (byte)0 : this.radius));
            BlockPos rayEndNeg = offsetPos.func_177982_a((int)(zAxis ? -this.radius : (byte)0), 0, zAxis ? 0 : (int)(-this.radius));
            BlockRayTraceResult posPass = this.field_70170_p.func_217299_a(new RayTraceContext(Vector3d.func_237489_a_((Vector3i)offsetPos), Vector3d.func_237489_a_((Vector3i)rayEndPos), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, null));
            BlockRayTraceResult negPass = this.field_70170_p.func_217299_a(new RayTraceContext(Vector3d.func_237489_a_((Vector3i)offsetPos), Vector3d.func_237489_a_((Vector3i)rayEndNeg), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, null));
            if (posPass.func_216346_c() == RayTraceResult.Type.MISS && negPass.func_216346_c() == RayTraceResult.Type.MISS) continue;
            int posPassOffset = posPass.func_216346_c() == RayTraceResult.Type.MISS ? 0 : (int)Math.sqrt(offsetPos.func_177951_i((Vector3i)posPass.func_216350_a()));
            int negPassOffset = negPass.func_216346_c() == RayTraceResult.Type.MISS ? 0 : (int)(-Math.sqrt(offsetPos.func_177951_i((Vector3i)negPass.func_216350_a())));
            for (int o = negPassOffset + 1; o <= posPassOffset; ++o) {
                BlockPos passStepOffset = offsetPos.func_177982_a(zAxis ? o : 0, 0, zAxis ? 0 : o);
                foundPositions.add(passStepOffset);
            }
        }
        this.positions.addAll(foundPositions);
        return true;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT nbt) {
        if (nbt.func_74764_b(NBT_BLOCK) && nbt.func_74764_b(NBT_POSITIONS) && nbt.func_74764_b(NBT_INDEX) && nbt.func_74764_b(NBT_RADIUS) && nbt.func_74764_b(NBT_HEIGHT) && nbt.func_74764_b(NBT_FINISHED_SCAN) && nbt.func_74764_b(NBT_PLAYER_ID)) {
            this.placeBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.func_74779_i(NBT_BLOCK)));
            if (this.placeBlock != null) {
                ListNBT list = nbt.func_150295_c(NBT_POSITIONS, 4);
                list.forEach(l -> this.positions.add(BlockPos.func_218283_e((long)((LongNBT)l).func_150291_c())));
                this.placeIndex = nbt.func_74762_e(NBT_INDEX);
                this.radius = nbt.func_74771_c(NBT_RADIUS);
                this.height = nbt.func_74771_c(NBT_HEIGHT);
                this.finishedScan = nbt.func_74767_n(NBT_FINISHED_SCAN);
                this.playerID = UUID.fromString(nbt.func_74779_i(NBT_PLAYER_ID));
                this.isValid = true;
            }
        }
    }

    protected void func_213281_b(CompoundNBT nbt) {
        if (this.placeBlock == null && !this.isValid) {
            return;
        }
        nbt.func_74778_a(NBT_BLOCK, this.placeBlock.getRegistryName().toString());
        nbt.func_74768_a(NBT_INDEX, this.placeIndex);
        nbt.func_74774_a(NBT_HEIGHT, this.height);
        nbt.func_74774_a(NBT_RADIUS, this.radius);
        nbt.func_74778_a(NBT_PLAYER_ID, this.playerID.toString());
        nbt.func_74757_a(NBT_FINISHED_SCAN, this.finishedScan);
        ListNBT positions = new ListNBT();
        this.positions.forEach(bp -> positions.add((Object)LongNBT.func_229698_a_((long)bp.func_218275_a())));
        nbt.func_218657_a(NBT_POSITIONS, (INBT)positions);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

