/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.utility;

import com.ma.api.capabilities.IChunkMagic;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.capabilities.chunkdata.ChunkMagicProvider;
import com.ma.entities.EntityInit;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityResidualMagic
extends Entity {
    private static final DataParameter<Float> RESIDUAL_POWER = EntityDataManager.func_187226_a(EntityResidualMagic.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static int DECAY_RATE = 100;
    private static float DECAY_AMOUNT = 5.0f;
    private int age = 0;
    private int maxAge = 20;

    public EntityResidualMagic(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public EntityResidualMagic(World world, int x, int y, int z, float power) {
        this((EntityType)EntityInit.RESIDUAL_MAGIC.get(), world);
        this.func_70107_b(x, y, z);
        this.setResidualPower(power);
    }

    public EntityResidualMagic(World world, BlockPos pos, float power) {
        this((EntityType)EntityInit.RESIDUAL_MAGIC.get(), world);
        this.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        this.setResidualPower(power);
    }

    public void setResidualPower(float power) {
        IChunkMagic magic = this.getChunkMagic();
        if (magic != null) {
            magic.removeResidualMagic(((Float)this.field_70180_af.func_187225_a(RESIDUAL_POWER)).floatValue());
            magic.addResidualMagic(power);
        }
        this.field_70180_af.func_187227_b(RESIDUAL_POWER, (Object)Float.valueOf(power));
        this.maxAge = (int)(power / DECAY_AMOUNT) * DECAY_RATE;
    }

    public float getResidualPower() {
        return ((Float)this.field_70180_af.func_187225_a(RESIDUAL_POWER)).floatValue();
    }

    public void consume() {
        this.setResidualPower(0.0f);
    }

    private void decay(float amount) {
        this.field_70180_af.func_187227_b(RESIDUAL_POWER, (Object)Float.valueOf(Math.max(((Float)this.field_70180_af.func_187225_a(RESIDUAL_POWER)).floatValue() - amount, 0.0f)));
        IChunkMagic magic = this.getChunkMagic();
        if (magic != null) {
            magic.removeResidualMagic(amount);
        }
    }

    private IChunkMagic getChunkMagic() {
        Chunk chunk = (Chunk)this.field_70170_p.func_217349_x(this.func_233580_cy_());
        LazyOptional magicCapability = chunk.getCapability(ChunkMagicProvider.MAGIC);
        if (magicCapability.isPresent()) {
            return (IChunkMagic)magicCapability.orElse(null);
        }
        return null;
    }

    public void func_70071_h_() {
        ++this.age;
        if (!this.field_70170_p.field_72995_K) {
            if (this.age >= this.maxAge) {
                this.remove(false);
            }
            if (this.age % DECAY_RATE == 0) {
                this.decay(DECAY_AMOUNT);
            }
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(RESIDUAL_POWER, (Object)Float.valueOf(0.0f));
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_74764_b("residual_power")) {
            this.field_70180_af.func_187227_b(RESIDUAL_POWER, (Object)Float.valueOf(compound.func_74760_g("residual_power")));
        }
        if (compound.func_74764_b("age")) {
            this.age = compound.func_74762_e("age");
        }
        if (compound.func_74764_b("maxAge")) {
            this.maxAge = compound.func_74762_e("maxAge");
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74776_a("residual_power", ((Float)this.field_70180_af.func_187225_a(RESIDUAL_POWER)).floatValue());
        compound.func_74768_a("age", this.age);
        compound.func_74768_a("maxAge", this.maxAge);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnParticles() {
        if (Math.random() < 0.5) {
            return;
        }
        float power = ((Float)this.field_70180_af.func_187225_a(RESIDUAL_POWER)).floatValue() * 0.002f;
        this.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_SPHERE_ORBIT.get())), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (double)0.02f, Math.random() * 360.0, (double)power);
    }
}

